/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.tez.common.GcTimeUpdater;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.metrics.FileSystemStatisticUpdater;
import org.apache.tez.util.TezMxBeanResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCounterUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TaskCounterUpdater.class);
    private final TezCounters tezCounters;
    private final Configuration conf;
    private final Map<String, Map<String, FileSystemStatisticUpdater>> statisticUpdaters = new HashMap<String, Map<String, FileSystemStatisticUpdater>>();
    protected final GcTimeUpdater gcUpdater;
    private ResourceCalculatorProcessTree pTree;
    private long initCpuCumulativeTime = 0L;
    private final String pid;

    public TaskCounterUpdater(TezCounters counters, Configuration conf, String pid) {
        this.tezCounters = counters;
        this.conf = conf;
        this.gcUpdater = new GcTimeUpdater(this.tezCounters);
        this.pid = pid;
        this.initResourceCalculatorPlugin();
        this.recordInitialCpuStats();
    }

    public void updateCounters() {
        GlobalStorageStatistics globalStorageStatistics = FileSystem.getGlobalStorageStatistics();
        for (StorageStatistics stats : globalStorageStatistics) {
            Map updaterSet = this.statisticUpdaters.computeIfAbsent(stats.getScheme(), k -> new HashMap());
            FileSystemStatisticUpdater updater = updaterSet.computeIfAbsent(stats.getName(), k -> new FileSystemStatisticUpdater(this.tezCounters, stats));
            updater.updateCounters();
        }
        this.gcUpdater.incrementGcCounter();
        this.updateResourceCounters();
    }

    private void recordInitialCpuStats() {
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }

    void updateResourceCounters() {
        this.updateHeapUsageCounter();
        if (this.pTree == null) {
            return;
        }
        this.pTree.updateProcessTree();
        long cpuTime = this.pTree.getCumulativeCpuTime();
        long pMem = this.pTree.getRssMemorySize();
        long vMem = this.pTree.getVirtualMemorySize();
        this.tezCounters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS).setValue(cpuTime -= this.initCpuCumulativeTime);
        this.tezCounters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES).setValue(pMem);
        this.tezCounters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES).setValue(vMem);
    }

    private void updateHeapUsageCounter() {
        long currentHeapUsage = Runtime.getRuntime().totalMemory();
        this.tezCounters.findCounter((Enum)TaskCounter.COMMITTED_HEAP_BYTES).setValue(currentHeapUsage);
    }

    private void initResourceCalculatorPlugin() {
        Class clazz = this.conf.getClass("tez.task.resource.calculator.process-tree.class", TezMxBeanResourceCalculator.class, ResourceCalculatorProcessTree.class);
        this.pTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)this.pid, (Class)clazz, (Configuration)this.conf);
        LOG.info("Using ResourceCalculatorProcessTree : " + clazz.getName());
    }
}

