/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class TaskAssignmentAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"vertex", "node", "numTaskAttempts", "load"};
    private final CSVResult csvResult = new CSVResult(this.headers);

    public TaskAssignmentAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        HashMap<String, Integer> taskAttemptsPerNode = new HashMap<String, Integer>();
        for (VertexInfo vertex : dagInfo.getVertices()) {
            taskAttemptsPerNode.clear();
            for (TaskAttemptInfo attempt : vertex.getTaskAttempts()) {
                Integer previousValue = (Integer)taskAttemptsPerNode.get(attempt.getNodeId());
                taskAttemptsPerNode.put(attempt.getNodeId(), previousValue == null ? 1 : previousValue + 1);
            }
            double mean = (double)vertex.getTaskAttempts().size() / Math.max(1.0, (double)taskAttemptsPerNode.size());
            for (Map.Entry assignment : taskAttemptsPerNode.entrySet()) {
                this.addARecord(vertex.getVertexName(), (String)assignment.getKey(), (Integer)assignment.getValue(), (double)((Integer)assignment.getValue() * 100) / mean);
            }
        }
    }

    private void addARecord(String vertexName, String node, int numTasks, double load) {
        String[] record = new String[]{vertexName, node, String.valueOf(numTasks), String.format("%.2f", load)};
        this.csvResult.addRecord(record);
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Task Assignment Analyzer";
    }

    @Override
    public String getDescription() {
        return "Get the Task assignments on different nodes of the cluster";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        TaskAssignmentAnalyzer analyzer = new TaskAssignmentAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

