/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupJobStage
extends AbstractJobOrTaskStage<Boolean, Path> {
    private static final Logger LOG = LoggerFactory.getLogger(SetupJobStage.class);

    public SetupJobStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_setup", false);
    }

    @Override
    protected Path executeStage(Boolean deleteMarker) throws IOException {
        Path path = this.getJobAttemptDir();
        LOG.info("{}: Creating Job Attempt directory {}", (Object)this.getName(), (Object)path);
        this.createNewDirectory("Job setup", path);
        this.createNewDirectory("Creating task manifest dir", this.getTaskManifestDir());
        if (deleteMarker.booleanValue()) {
            this.deleteFile(this.getStageConfig().getJobSuccessMarkerPath(), "op_delete");
        }
        return path;
    }
}

