/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.history.parser.datamodel.BaseInfo;
import org.apache.tez.history.parser.datamodel.Container;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.apache.tez.util.StringInterner;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskInfo
extends BaseInfo {
    private static final Log LOG = LogFactory.getLog(TaskInfo.class);
    private final long startTime;
    private final long endTime;
    private final String diagnostics;
    private final String successfulAttemptId;
    private final long scheduledTime;
    private final String status;
    private final String taskId;
    private VertexInfo vertexInfo;
    private Map<String, TaskAttemptInfo> attemptInfoMap = Maps.newHashMap();

    TaskInfo(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        Preconditions.checkArgument((boolean)jsonObject.getString("entitytype").equalsIgnoreCase("TEZ_TASK_ID"));
        this.taskId = StringInterner.intern((String)jsonObject.optString("entity"));
        JSONObject otherInfoNode = jsonObject.getJSONObject("otherinfo");
        long sTime = otherInfoNode.optLong("startTime");
        long eTime = otherInfoNode.optLong("endTime");
        if (eTime < sTime) {
            LOG.warn((Object)("Task has got wrong start/end values. startTime=" + sTime + ", endTime=" + eTime + ". Will check timestamps in DAG started/finished events"));
            for (Event event : this.eventList) {
                switch (HistoryEventType.valueOf((String)event.getType())) {
                    case TASK_STARTED: {
                        sTime = event.getAbsoluteTime();
                        break;
                    }
                    case TASK_FINISHED: {
                        eTime = event.getAbsoluteTime();
                        break;
                    }
                }
            }
            if (eTime < sTime) {
                LOG.warn((Object)("Task has got wrong start/end values in events as well. startTime=" + sTime + ", endTime=" + eTime));
            }
        }
        this.startTime = sTime;
        this.endTime = eTime;
        this.diagnostics = otherInfoNode.optString("diagnostics");
        this.successfulAttemptId = StringInterner.intern((String)otherInfoNode.optString("successfulAttemptId"));
        this.scheduledTime = otherInfoNode.optLong("scheduledTime");
        this.status = StringInterner.intern((String)otherInfoNode.optString("status"));
    }

    @Override
    public final long getStartTimeInterval() {
        return this.startTime - this.vertexInfo.getDagInfo().getStartTime();
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final long getFinishTime() {
        return this.endTime;
    }

    @Override
    public final long getFinishTimeInterval() {
        long taskFinishTime = this.endTime - this.vertexInfo.getDagInfo().getStartTime();
        if (taskFinishTime < 0L) {
            for (TaskAttemptInfo attemptInfo : this.getTaskAttempts()) {
                taskFinishTime = attemptInfo.getFinishTimeInterval() > taskFinishTime ? attemptInfo.getFinishTimeInterval() : taskFinishTime;
            }
        }
        return taskFinishTime;
    }

    @Override
    public final String getDiagnostics() {
        return this.diagnostics;
    }

    public static TaskInfo create(JSONObject taskInfoObject) throws JSONException {
        return new TaskInfo(taskInfoObject);
    }

    void addTaskAttemptInfo(TaskAttemptInfo taskAttemptInfo) {
        this.attemptInfoMap.put(taskAttemptInfo.getTaskAttemptId(), taskAttemptInfo);
    }

    void setVertexInfo(VertexInfo vertexInfo) {
        this.vertexInfo = Objects.requireNonNull(vertexInfo, "Provide valid vertexInfo");
        vertexInfo.addTaskInfo(this);
    }

    public final VertexInfo getVertexInfo() {
        return this.vertexInfo;
    }

    public final List<TaskAttemptInfo> getTaskAttempts() {
        LinkedList attemptsList = Lists.newLinkedList(this.attemptInfoMap.values());
        Collections.sort(attemptsList, this.orderingOnAttemptStartTime());
        return Collections.unmodifiableList(attemptsList);
    }

    public final List<TaskAttemptInfo> getFailedTaskAttempts() {
        return this.getTaskAttempts(TaskAttemptState.FAILED);
    }

    public final List<TaskAttemptInfo> getKilledTaskAttempts() {
        return this.getTaskAttempts(TaskAttemptState.KILLED);
    }

    public final List<TaskAttemptInfo> getSuccessfulTaskAttempts() {
        return this.getTaskAttempts(TaskAttemptState.SUCCEEDED);
    }

    public final List<TaskAttemptInfo> getTaskAttempts(final TaskAttemptState state) {
        return Collections.unmodifiableList(Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Lists.newLinkedList(this.attemptInfoMap.values()), (Predicate)new Predicate<TaskAttemptInfo>(){

            public boolean apply(TaskAttemptInfo input) {
                return input.getStatus() != null && input.getStatus().equals(state.toString());
            }
        })));
    }

    public final Multimap<Container, TaskAttemptInfo> getContainersMapping() {
        LinkedHashMultimap containerMapping = LinkedHashMultimap.create();
        for (TaskAttemptInfo attemptInfo : this.getTaskAttempts()) {
            containerMapping.put((Object)attemptInfo.getContainer(), (Object)attemptInfo);
        }
        return Multimaps.unmodifiableMultimap((Multimap)containerMapping);
    }

    public final TaskAttemptInfo getSuccessfulTaskAttempt() {
        if (!Strings.isNullOrEmpty((String)this.getSuccessfulAttemptId())) {
            for (TaskAttemptInfo attemptInfo : this.getTaskAttempts()) {
                if (!attemptInfo.getTaskAttemptId().equals(this.getSuccessfulAttemptId())) continue;
                return attemptInfo;
            }
        }
        for (TaskAttemptInfo attemptInfo : this.getTaskAttempts()) {
            if (!attemptInfo.getStatus().equalsIgnoreCase(TaskAttemptState.SUCCEEDED.toString())) continue;
            return attemptInfo;
        }
        return null;
    }

    public final TaskAttemptInfo getLastTaskAttemptToFinish() {
        List<TaskAttemptInfo> attemptsList = this.getTaskAttempts();
        if (attemptsList.isEmpty()) {
            return null;
        }
        return (TaskAttemptInfo)Ordering.from((Comparator)new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return o1.getFinishTimeInterval() < o2.getFinishTimeInterval() ? -1 : (o1.getFinishTimeInterval() == o2.getFinishTimeInterval() ? 0 : 1);
            }
        }).max(attemptsList);
    }

    public final float getAvgTaskAttemptDuration() {
        float totalTaskDuration = 0.0f;
        List<TaskAttemptInfo> attemptsList = this.getTaskAttempts();
        if (attemptsList.size() == 0) {
            return 0.0f;
        }
        for (TaskAttemptInfo attemptInfo : attemptsList) {
            totalTaskDuration += (float)attemptInfo.getTimeTaken();
        }
        return totalTaskDuration * 1.0f / (float)attemptsList.size();
    }

    private Ordering<TaskAttemptInfo> orderingOnTimeTaken() {
        return Ordering.from((Comparator)new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return o1.getTimeTaken() < o2.getTimeTaken() ? -1 : (o1.getTimeTaken() == o2.getTimeTaken() ? 0 : 1);
            }
        });
    }

    private Ordering<TaskAttemptInfo> orderingOnAttemptStartTime() {
        return Ordering.from((Comparator)new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return o1.getStartTimeInterval() < o2.getStartTimeInterval() ? -1 : (o1.getStartTimeInterval() == o2.getStartTimeInterval() ? 0 : 1);
            }
        });
    }

    public final long getMinTaskAttemptDuration() {
        List<TaskAttemptInfo> attemptsList = this.getTaskAttempts();
        if (attemptsList.isEmpty()) {
            return 0L;
        }
        return ((TaskAttemptInfo)this.orderingOnTimeTaken().min(attemptsList)).getTimeTaken();
    }

    public final long getMaxTaskAttemptDuration() {
        List<TaskAttemptInfo> attemptsList = this.getTaskAttempts();
        if (attemptsList.isEmpty()) {
            return 0L;
        }
        return ((TaskAttemptInfo)this.orderingOnTimeTaken().max(attemptsList)).getTimeTaken();
    }

    public final int getNumberOfTaskAttempts() {
        return this.getTaskAttempts().size();
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getTaskId() {
        return this.taskId;
    }

    public final long getTimeTaken() {
        return this.getFinishTimeInterval() - this.getStartTimeInterval();
    }

    public final String getSuccessfulAttemptId() {
        return this.successfulAttemptId;
    }

    public final long getAbsoluteScheduleTime() {
        return this.scheduledTime;
    }

    public final long getScheduledTime() {
        return this.scheduledTime - this.getVertexInfo().getDagInfo().getStartTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("taskId=").append(this.getTaskId()).append(", ");
        sb.append("scheduledTime=").append(this.getAbsoluteScheduleTime()).append(", ");
        sb.append("startTime=").append(this.getStartTimeInterval()).append(", ");
        sb.append("finishTime=").append(this.getFinishTimeInterval()).append(", ");
        sb.append("timeTaken=").append(this.getTimeTaken()).append(", ");
        sb.append("events=").append(this.getEvents()).append(", ");
        sb.append("diagnostics=").append(this.getDiagnostics()).append(", ");
        sb.append("successfulAttempId=").append(this.getSuccessfulAttemptId()).append(", ");
        sb.append("status=").append(this.getStatus()).append(", ");
        sb.append("vertexName=").append(this.getVertexInfo().getVertexName());
        sb.append("]");
        return sb.toString();
    }
}

