/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.utils.Utils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class BaseInfo {
    protected TezCounters tezCounters;
    protected List<Event> eventList;

    BaseInfo(JSONObject jsonObject) throws JSONException {
        JSONObject otherInfoNode = jsonObject.getJSONObject("otherinfo");
        JSONObject countersObj = otherInfoNode.optJSONObject("counters");
        if (countersObj == null) {
            countersObj = new JSONObject(otherInfoNode.optString("counters"));
        }
        this.tezCounters = Utils.parseTezCountersFromJSON(countersObj);
        this.eventList = Lists.newArrayList();
        Utils.parseEvents(jsonObject.optJSONArray("events"), this.eventList);
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    public abstract long getStartTimeInterval();

    public abstract long getFinishTimeInterval();

    public abstract long getStartTime();

    public abstract long getFinishTime();

    public abstract String getDiagnostics();

    public List<Event> getEvents() {
        return this.eventList;
    }

    public Map<String, TezCounter> getCounter(String counterGroupName, String counter) {
        HashMap result = Maps.newHashMap();
        Iterator iterator = this.tezCounters.getGroupNames().iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            TezCounter tezCounter;
            String groupName;
            CounterGroup counterGroup = (CounterGroup)this.tezCounters.getGroup((String)iterator.next());
            if (counterGroupName != null && (groupName = counterGroup.getName()).equals(counterGroupName)) {
                found = true;
            }
            if ((tezCounter = counterGroup.getUnderlyingGroup().findCounter(counter, false)) != null) {
                result.put(counterGroup.getName(), tezCounter);
            }
            if (!found) continue;
            break;
        }
        return result;
    }

    public Map<String, TezCounter> getCounter(String counter) {
        return this.getCounter(null, counter);
    }
}

