/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser;

import com.google.common.base.Strings;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.history.logging.proto.HistoryEventProtoJsonConversion;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.history.logging.proto.ProtoMessageReader;
import org.apache.tez.history.parser.SimpleHistoryParser;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoHistoryParser
extends SimpleHistoryParser {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoHistoryParser.class);
    private List<File> protoFiles;

    public ProtoHistoryParser(List<File> files) {
        super(files);
        this.protoFiles = files;
    }

    @Override
    public DagInfo getDAGData(String dagId) throws TezException {
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dagId) ? 1 : 0) != 0, (Object)"Please provide valid dagId");
            dagId = dagId.trim();
            this.parseContents(dagId);
            this.linkParsedContents();
            this.addRawDataToDagInfo();
            return this.dagInfo;
        }
        catch (IOException | JSONException e) {
            LOG.error("Error in reading DAG ", e);
            throw new TezException(e);
        }
    }

    private void parseContents(String dagId) throws JSONException, FileNotFoundException, TezException, IOException {
        SimpleHistoryParser.JSONObjectSource source = this.getJsonSource();
        this.parse(dagId, source);
    }

    private SimpleHistoryParser.JSONObjectSource getJsonSource() throws IOException {
        final TezConfiguration conf = new TezConfiguration();
        final Iterator<File> fileIt = this.protoFiles.iterator();
        SimpleHistoryParser.JSONObjectSource source = new SimpleHistoryParser.JSONObjectSource(){
            private HistoryLoggerProtos.HistoryEventProto message = null;
            private ProtoMessageReader<HistoryLoggerProtos.HistoryEventProto> reader = new ProtoMessageReader((Configuration)conf, new Path(((File)fileIt.next()).getPath()), HistoryLoggerProtos.HistoryEventProto.PARSER);

            @Override
            public JSONObject next() throws JSONException {
                return HistoryEventProtoJsonConversion.convertToJson((HistoryLoggerProtos.HistoryEventProto)this.message);
            }

            @Override
            public boolean hasNext() throws IOException {
                try {
                    this.message = (HistoryLoggerProtos.HistoryEventProto)this.reader.readEvent();
                    return this.message != null;
                }
                catch (EOFException e) {
                    this.reader.close();
                    if (!fileIt.hasNext()) {
                        return false;
                    }
                    this.reader = new ProtoMessageReader((Configuration)conf, new Path(((File)fileIt.next()).getPath()), HistoryLoggerProtos.HistoryEventProto.PARSER);
                    try {
                        this.message = (HistoryLoggerProtos.HistoryEventProto)this.reader.readEvent();
                        return this.message != null;
                    }
                    catch (EOFException e2) {
                        return false;
                    }
                }
            }

            @Override
            public void close() {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOG.warn("error while closing ProtoMessageReader", (Throwable)e);
                }
            }
        };
        return source;
    }
}

