/*	$OpenBSD: s_exp2.c,v 1.9 2016/09/12 19:47:02 guenther Exp $	*/
/*-
 * Copyright (c) 2005 David Schultz <das@FreeBSD.ORG>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#include <float.h>
#include <math.h>

#include "math_private.h"

#define	TBLBITS	8
#define	TBLSIZE	(1 << TBLBITS)

//static const double
//    huge     = 0x1p1000,
//    redux    = 0x1.8p52 / TBLSIZE,
//    P1	     = 0x1.62e42fefa39efp-1,
//    P2	     = 0x1.ebfbdff82c575p-3,
//    P3	     = 0x1.c6b08d704a0a6p-5,
//    P4	     = 0x1.3b2ab88f70400p-7,
//    P5	     = 0x1.5d88003875c74p-10;

//static volatile double twom1000 = 0x1p-1000;

//static const double tbl[TBLSIZE * 2] = {
/*	exp2(z + eps)		eps	*/
//	0x1.6a09e667f3d5dp-1,	 0x1.9880p-44,
//	0x1.6b052fa751744p-1,	 0x1.8000p-50,
//	0x1.6c012750bd9fep-1,	-0x1.8780p-45,
//	0x1.6cfdcddd476bfp-1,	 0x1.ec00p-46,
//	0x1.6dfb23c651a29p-1,	-0x1.8000p-50,
//	0x1.6ef9298593ae3p-1,	-0x1.c000p-52,
//	0x1.6ff7df9519386p-1,	-0x1.fd80p-45,
//	0x1.70f7466f42da3p-1,	-0x1.c880p-45,
//	0x1.71f75e8ec5fc3p-1,	 0x1.3c00p-46,
//	0x1.72f8286eacf05p-1,	-0x1.8300p-44,
//	0x1.73f9a48a58152p-1,	-0x1.0c00p-47,
//	0x1.74fbd35d7ccfcp-1,	 0x1.f880p-45,
//	0x1.75feb564267f1p-1,	 0x1.3e00p-47,
//	0x1.77024b1ab6d48p-1,	-0x1.7d00p-45,
//	0x1.780694fde5d38p-1,	-0x1.d000p-50,
//	0x1.790b938ac1d00p-1,	 0x1.3000p-49,
//	0x1.7a11473eb0178p-1,	-0x1.d000p-49,
//	0x1.7b17b0976d060p-1,	 0x1.0400p-45,
//	0x1.7c1ed0130c133p-1,	 0x1.0000p-53,
//	0x1.7d26a62ff8636p-1,	-0x1.6900p-45,
//	0x1.7e2f336cf4e3bp-1,	-0x1.2e00p-47,
//	0x1.7f3878491c3e8p-1,	-0x1.4580p-45,
//	0x1.80427543e1b4ep-1,	 0x1.3000p-44,
//	0x1.814d2add1071ap-1,	 0x1.f000p-47,
//	0x1.82589994ccd7ep-1,	-0x1.1c00p-45,
//	0x1.8364c1eb942d0p-1,	 0x1.9d00p-45,
//	0x1.8471a4623cab5p-1,	 0x1.7100p-43,
//	0x1.857f4179f5bbcp-1,	 0x1.2600p-45,
//	0x1.868d99b4491afp-1,	-0x1.2c40p-44,
//	0x1.879cad931a395p-1,	-0x1.3000p-45,
//	0x1.88ac7d98a65b8p-1,	-0x1.a800p-45,
//	0x1.89bd0a4785800p-1,	-0x1.d000p-49,
//	0x1.8ace5422aa223p-1,	 0x1.3280p-44,
//	0x1.8be05bad619fap-1,	 0x1.2b40p-43,
//	0x1.8cf3216b54383p-1,	-0x1.ed00p-45,
//	0x1.8e06a5e08664cp-1,	-0x1.0500p-45,
//	0x1.8f1ae99157807p-1,	 0x1.8280p-45,
//	0x1.902fed0282c0ep-1,	-0x1.cb00p-46,
//	0x1.9145b0b91ff96p-1,	-0x1.5e00p-47,
//	0x1.925c353aa2ff9p-1,	 0x1.5400p-48,
//	0x1.93737b0cdc64ap-1,	 0x1.7200p-46,
//	0x1.948b82b5f98aep-1,	-0x1.9000p-47,
//	0x1.95a44cbc852cbp-1,	 0x1.5680p-45,
//	0x1.96bdd9a766f21p-1,	-0x1.6d00p-44,
//	0x1.97d829fde4e2ap-1,	-0x1.1000p-47,
//	0x1.98f33e47a23a3p-1,	 0x1.d000p-45,
//	0x1.9a0f170ca0604p-1,	-0x1.8a40p-44,
//	0x1.9b2bb4d53ff89p-1,	 0x1.55c0p-44,
//	0x1.9c49182a3f15bp-1,	 0x1.6b80p-45,
//	0x1.9d674194bb8c5p-1,	-0x1.c000p-49,
//	0x1.9e86319e3238ep-1,	 0x1.7d00p-46,
//	0x1.9fa5e8d07f302p-1,	 0x1.6400p-46,
//	0x1.a0c667b5de54dp-1,	-0x1.5000p-48,
//	0x1.a1e7aed8eb8f6p-1,	 0x1.9e00p-47,
//	0x1.a309bec4a2e27p-1,	 0x1.ad80p-45,
//	0x1.a42c980460a5dp-1,	-0x1.af00p-46,
//	0x1.a5503b23e259bp-1,	 0x1.b600p-47,
//	0x1.a674a8af46213p-1,	 0x1.8880p-44,
//	0x1.a799e1330b3a7p-1,	 0x1.1200p-46,
//	0x1.a8bfe53c12e8dp-1,	 0x1.6c00p-47,
//	0x1.a9e6b5579fcd2p-1,	-0x1.9b80p-45,
//	0x1.ab0e521356fb8p-1,	 0x1.b700p-45,
//	0x1.ac36bbfd3f381p-1,	 0x1.9000p-50,
//	0x1.ad5ff3a3c2780p-1,	 0x1.4000p-49,
//	0x1.ae89f995ad2a3p-1,	-0x1.c900p-45,
//	0x1.afb4ce622f367p-1,	 0x1.6500p-46,
//	0x1.b0e07298db790p-1,	 0x1.fd40p-45,
//	0x1.b20ce6c9a89a9p-1,	 0x1.2700p-46,
//	0x1.b33a2b84f1a4bp-1,	 0x1.d470p-43,
//	0x1.b468415b747e7p-1,	-0x1.8380p-44,
//	0x1.b59728de5593ap-1,	 0x1.8000p-54,
//	0x1.b6c6e29f1c56ap-1,	 0x1.ad00p-47,
//	0x1.b7f76f2fb5e50p-1,	 0x1.e800p-50,
//	0x1.b928cf22749b2p-1,	-0x1.4c00p-47,
//	0x1.ba5b030a10603p-1,	-0x1.d700p-47,
//	0x1.bb8e0b79a6f66p-1,	 0x1.d900p-47,
//	0x1.bcc1e904bc1ffp-1,	 0x1.2a00p-47,
//	0x1.bdf69c3f3a16fp-1,	-0x1.f780p-46,
//	0x1.bf2c25bd71db8p-1,	-0x1.0a00p-46,
//	0x1.c06286141b2e9p-1,	-0x1.1400p-46,
//	0x1.c199bdd8552e0p-1,	 0x1.be00p-47,
//	0x1.c2d1cd9fa64eep-1,	-0x1.9400p-47,
//	0x1.c40ab5fffd02fp-1,	-0x1.ed00p-47,
//	0x1.c544778fafd15p-1,	 0x1.9660p-44,
//	0x1.c67f12e57d0cbp-1,	-0x1.a100p-46,
//	0x1.c7ba88988c1b6p-1,	-0x1.8458p-42,
//	0x1.c8f6d9406e733p-1,	-0x1.a480p-46,
//	0x1.ca3405751c4dfp-1,	 0x1.b000p-51,
//	0x1.cb720dcef9094p-1,	 0x1.1400p-47,
//	0x1.ccb0f2e6d1689p-1,	 0x1.0200p-48,
//	0x1.cdf0b555dc412p-1,	 0x1.3600p-48,
//	0x1.cf3155b5bab3bp-1,	-0x1.6900p-47,
//	0x1.d072d4a0789bcp-1,	 0x1.9a00p-47,
//	0x1.d1b532b08c8fap-1,	-0x1.5e00p-46,
//	0x1.d2f87080d8a85p-1,	 0x1.d280p-46,
//	0x1.d43c8eacaa203p-1,	 0x1.1a00p-47,
//	0x1.d5818dcfba491p-1,	 0x1.f000p-50,
//	0x1.d6c76e862e6a1p-1,	-0x1.3a00p-47,
//	0x1.d80e316c9834ep-1,	-0x1.cd80p-47,
//	0x1.d955d71ff6090p-1,	 0x1.4c00p-48,
//	0x1.da9e603db32aep-1,	 0x1.f900p-48,
//	0x1.dbe7cd63a8325p-1,	 0x1.9800p-49,
//	0x1.dd321f301b445p-1,	-0x1.5200p-48,
//	0x1.de7d5641c05bfp-1,	-0x1.d700p-46,
//	0x1.dfc97337b9aecp-1,	-0x1.6140p-46,
//	0x1.e11676b197d5ep-1,	 0x1.b480p-47,
//	0x1.e264614f5a3e7p-1,	 0x1.0ce0p-43,
//	0x1.e3b333b16ee5cp-1,	 0x1.c680p-47,
//	0x1.e502ee78b3fb4p-1,	-0x1.9300p-47,
//	0x1.e653924676d68p-1,	-0x1.5000p-49,
//	0x1.e7a51fbc74c44p-1,	-0x1.7f80p-47,
//	0x1.e8f7977cdb726p-1,	-0x1.3700p-48,
//	0x1.ea4afa2a490e8p-1,	 0x1.5d00p-49,
//	0x1.eb9f4867ccae4p-1,	 0x1.61a0p-46,
//	0x1.ecf482d8e680dp-1,	 0x1.5500p-48,
//	0x1.ee4aaa2188514p-1,	 0x1.6400p-51,
//	0x1.efa1bee615a13p-1,	-0x1.e800p-49,
//	0x1.f0f9c1cb64106p-1,	-0x1.a880p-48,
//	0x1.f252b376bb963p-1,	-0x1.c900p-45,
//	0x1.f3ac948dd7275p-1,	 0x1.a000p-53,
//	0x1.f50765b6e4524p-1,	-0x1.4f00p-48,
//	0x1.f6632798844fdp-1,	 0x1.a800p-51,
//	0x1.f7bfdad9cbe38p-1,	 0x1.abc0p-48,
//	0x1.f91d802243c82p-1,	-0x1.4600p-50,
//	0x1.fa7c1819e908ep-1,	-0x1.b0c0p-47,
//	0x1.fbdba3692d511p-1,	-0x1.0e00p-51,
//	0x1.fd3c22b8f7194p-1,	-0x1.0de8p-46,
//	0x1.fe9d96b2a23eep-1,	 0x1.e430p-49,
//	0x1.0000000000000p+0,	 0x0.0000p+0,
//	0x1.00b1afa5abcbep+0,	-0x1.3400p-52,
//	0x1.0163da9fb3303p+0,	-0x1.2170p-46,
//	0x1.02168143b0282p+0,	 0x1.a400p-52,
//	0x1.02c9a3e77806cp+0,	 0x1.f980p-49,
//	0x1.037d42e11bbcap+0,	-0x1.7400p-51,
//	0x1.04315e86e7f89p+0,	 0x1.8300p-50,
//	0x1.04e5f72f65467p+0,	-0x1.a3f0p-46,
//	0x1.059b0d315855ap+0,	-0x1.2840p-47,
//	0x1.0650a0e3c1f95p+0,	 0x1.1600p-48,
//	0x1.0706b29ddf71ap+0,	 0x1.5240p-46,
//	0x1.07bd42b72a82dp+0,	-0x1.9a00p-49,
//	0x1.0874518759bd0p+0,	 0x1.6400p-49,
//	0x1.092bdf66607c8p+0,	-0x1.0780p-47,
//	0x1.09e3ecac6f383p+0,	-0x1.8000p-54,
//	0x1.0a9c79b1f3930p+0,	 0x1.fa00p-48,
//	0x1.0b5586cf988fcp+0,	-0x1.ac80p-48,
//	0x1.0c0f145e46c8ap+0,	 0x1.9c00p-50,
//	0x1.0cc922b724816p+0,	 0x1.5200p-47,
//	0x1.0d83b23395dd8p+0,	-0x1.ad00p-48,
//	0x1.0e3ec32d3d1f3p+0,	 0x1.bac0p-46,
//	0x1.0efa55fdfa9a6p+0,	-0x1.4e80p-47,
//	0x1.0fb66affed2f0p+0,	-0x1.d300p-47,
//	0x1.1073028d7234bp+0,	 0x1.1500p-48,
//	0x1.11301d0125b5bp+0,	 0x1.c000p-49,
//	0x1.11edbab5e2af9p+0,	 0x1.6bc0p-46,
//	0x1.12abdc06c31d5p+0,	 0x1.8400p-49,
//	0x1.136a814f2047dp+0,	-0x1.ed00p-47,
//	0x1.1429aaea92de9p+0,	 0x1.8e00p-49,
//	0x1.14e95934f3138p+0,	 0x1.b400p-49,
//	0x1.15a98c8a58e71p+0,	 0x1.5300p-47,
//	0x1.166a45471c3dfp+0,	 0x1.3380p-47,
//	0x1.172b83c7d5211p+0,	 0x1.8d40p-45,
//	0x1.17ed48695bb9fp+0,	-0x1.5d00p-47,
//	0x1.18af9388c8d93p+0,	-0x1.c880p-46,
//	0x1.1972658375d66p+0,	 0x1.1f00p-46,
//	0x1.1a35beb6fcba7p+0,	 0x1.0480p-46,
//	0x1.1af99f81387e3p+0,	-0x1.7390p-43,
//	0x1.1bbe084045d54p+0,	 0x1.4e40p-45,
//	0x1.1c82f95281c43p+0,	-0x1.a200p-47,
//	0x1.1d4873168b9b2p+0,	 0x1.3800p-49,
//	0x1.1e0e75eb44031p+0,	 0x1.ac00p-49,
//	0x1.1ed5022fcd938p+0,	 0x1.1900p-47,
//	0x1.1f9c18438cdf7p+0,	-0x1.b780p-46,
//	0x1.2063b88628d8fp+0,	 0x1.d940p-45,
//	0x1.212be3578a81ep+0,	 0x1.8000p-50,
//	0x1.21f49917ddd41p+0,	 0x1.b340p-45,
//	0x1.22bdda2791323p+0,	 0x1.9f80p-46,
//	0x1.2387a6e7561e7p+0,	-0x1.9c80p-46,
//	0x1.2451ffb821427p+0,	 0x1.2300p-47,
//	0x1.251ce4fb2a602p+0,	-0x1.3480p-46,
//	0x1.25e85711eceb0p+0,	 0x1.2700p-46,
//	0x1.26b4565e27d16p+0,	 0x1.1d00p-46,
//	0x1.2780e341de00fp+0,	 0x1.1ee0p-44,
//	0x1.284dfe1f5633ep+0,	-0x1.4c00p-46,
//	0x1.291ba7591bb30p+0,	-0x1.3d80p-46,
//	0x1.29e9df51fdf09p+0,	 0x1.8b00p-47,
//	0x1.2ab8a66d10e9bp+0,	-0x1.27c0p-45,
//	0x1.2b87fd0dada3ap+0,	 0x1.a340p-45,
//	0x1.2c57e39771af9p+0,	-0x1.0800p-46,
//	0x1.2d285a6e402d9p+0,	-0x1.ed00p-47,
//	0x1.2df961f641579p+0,	-0x1.4200p-48,
//	0x1.2ecafa93e2ecfp+0,	-0x1.4980p-45,
//	0x1.2f9d24abd8822p+0,	-0x1.6300p-46,
//	0x1.306fe0a31b625p+0,	-0x1.2360p-44,
//	0x1.31432edeea50bp+0,	-0x1.0df8p-40,
//	0x1.32170fc4cd7b8p+0,	-0x1.2480p-45,
//	0x1.32eb83ba8e9a2p+0,	-0x1.5980p-45,
//	0x1.33c08b2641766p+0,	 0x1.ed00p-46,
//	0x1.3496266e3fa27p+0,	-0x1.c000p-50,
//	0x1.356c55f929f0fp+0,	-0x1.0d80p-44,
//	0x1.36431a2de88b9p+0,	 0x1.2c80p-45,
//	0x1.371a7373aaa39p+0,	 0x1.0600p-45,
//	0x1.37f26231e74fep+0,	-0x1.6600p-46,
//	0x1.38cae6d05d838p+0,	-0x1.ae00p-47,
//	0x1.39a401b713ec3p+0,	-0x1.4720p-43,
//	0x1.3a7db34e5a020p+0,	 0x1.8200p-47,
//	0x1.3b57fbfec6e95p+0,	 0x1.e800p-44,
//	0x1.3c32dc313a8f2p+0,	 0x1.f800p-49,
//	0x1.3d0e544ede122p+0,	-0x1.7a00p-46,
//	0x1.3dea64c1234bbp+0,	 0x1.6300p-45,
//	0x1.3ec70df1c4eccp+0,	-0x1.8a60p-43,
//	0x1.3fa4504ac7e8cp+0,	-0x1.cdc0p-44,
//	0x1.40822c367a0bbp+0,	 0x1.5b80p-45,
//	0x1.4160a21f72e95p+0,	 0x1.ec00p-46,
//	0x1.423fb27094646p+0,	-0x1.3600p-46,
//	0x1.431f5d950a920p+0,	 0x1.3980p-45,
//	0x1.43ffa3f84b9ebp+0,	 0x1.a000p-48,
//	0x1.44e0860618919p+0,	-0x1.6c00p-48,
//	0x1.45c2042a7d201p+0,	-0x1.bc00p-47,
//	0x1.46a41ed1d0016p+0,	-0x1.2800p-46,
//	0x1.4786d668b3326p+0,	 0x1.0e00p-44,
//	0x1.486a2b5c13c00p+0,	-0x1.d400p-45,
//	0x1.494e1e192af04p+0,	 0x1.c200p-47,
//	0x1.4a32af0d7d372p+0,	-0x1.e500p-46,
//	0x1.4b17dea6db801p+0,	 0x1.7800p-47,
//	0x1.4bfdad53629e1p+0,	-0x1.3800p-46,
//	0x1.4ce41b817c132p+0,	 0x1.0800p-47,
//	0x1.4dcb299fddddbp+0,	 0x1.c700p-45,
//	0x1.4eb2d81d8ab96p+0,	-0x1.ce00p-46,
//	0x1.4f9b2769d2d02p+0,	 0x1.9200p-46,
//	0x1.508417f4531c1p+0,	-0x1.8c00p-47,
//	0x1.516daa2cf662ap+0,	-0x1.a000p-48,
//	0x1.5257de83f51eap+0,	 0x1.a080p-43,
//	0x1.5342b569d4edap+0,	-0x1.6d80p-45,
//	0x1.542e2f4f6ac1ap+0,	-0x1.2440p-44,
//	0x1.551a4ca5d94dbp+0,	 0x1.83c0p-43,
//	0x1.56070dde9116bp+0,	 0x1.4b00p-45,
//	0x1.56f4736b529dep+0,	 0x1.15a0p-43,
//	0x1.57e27dbe2c40ep+0,	-0x1.9e00p-45,
//	0x1.58d12d497c76fp+0,	-0x1.3080p-45,
//	0x1.59c0827ff0b4cp+0,	 0x1.dec0p-43,
//	0x1.5ab07dd485427p+0,	-0x1.4000p-51,
//	0x1.5ba11fba87af4p+0,	 0x1.0080p-44,
//	0x1.5c9268a59460bp+0,	-0x1.6c80p-45,
//	0x1.5d84590998e3fp+0,	 0x1.69a0p-43,
//	0x1.5e76f15ad20e1p+0,	-0x1.b400p-46,
//	0x1.5f6a320dcebcap+0,	 0x1.7700p-46,
//	0x1.605e1b976dcb8p+0,	 0x1.6f80p-45,
//	0x1.6152ae6cdf715p+0,	 0x1.1000p-47,
//	0x1.6247eb03a5531p+0,	-0x1.5d00p-46,
//	0x1.633dd1d1929b5p+0,	-0x1.2d00p-46,
//	0x1.6434634ccc313p+0,	-0x1.a800p-49,
//	0x1.652b9febc8efap+0,	-0x1.8600p-45,
//	0x1.6623882553397p+0,	 0x1.1fe0p-40,
//	0x1.671c1c708328ep+0,	-0x1.7200p-44,
//	0x1.68155d44ca97ep+0,	 0x1.6800p-49,
//	0x1.690f4b19e9471p+0,	-0x1.9780p-45,
static const double
	huge     = 1.0715086071862673209484250490600018105614048117055E+301 ,
	redux    = 6755399441055744 / TBLSIZE,
	P1	     = 0.69314718055994528622676398299518041312694549560547,
	P2		 = 0.24022650695910000018251650999445701017975807189941,
	P3		 = 0.055504108664821402707723052571964217349886894226074,
	P4		 = 0.0096181298421260663644716260023415088653564453125,
	P5		 = 0.0013333559164630222684810867406213219510391354560852;
static volatile double twom1000 = 9.332636e-302;
static const double tbl[TBLSIZE * 2] = {
	0.70710678118659198165829593563103117048740386962891, 	     9.070522111187528935261070728302001953125E-14, 	
	0.70902394216020825368218538642395287752151489257812, 	        1.332267629550187848508358001708984375E-15, 	
	0.71094630108456136063921348977601155638694763183594, 	   -4.3465231414074878557585179805755615234375E-14, 	
	0.71287387205276064872094821112114004790782928466797, 	      2.73114864057788508944213390350341796875E-14, 	
	0.71480666919598434549953935857047326862812042236328, 	       -1.332267629550187848508358001708984375E-15, 	
	0.71674470668389422822741607888019643723964691162109, 	     -3.88578058618804789148271083831787109375E-16, 	
	0.71868799872446298415695764560950919985771179199219, 	   -5.6565863104651725734584033489227294921875E-14, 	
	0.72063655956428751547804267829633317887783050537109, 	   -5.0681681074138396070338785648345947265625E-14, 	
	0.72259040348853209589918833444244228303432464599609, 	      1.75415237890774733386933803558349609375E-14, 	
	0.72454954482097433388076979099423624575138092041016, 	     -8.59312621059871162287890911102294921875E-14, 	
	0.72651399792452253656449556729057803750038146972656, 	     -7.43849426498854882083833217620849609375E-15, 	
	0.72848377720075019325918219692539423704147338867188, 	    5.6010751592339147464372217655181884765625E-14, 	
	0.73045889709032796321963587615755386650562286376953, 	     8.826273045769994496367871761322021484375E-15, 	
	0.73243937207318143833845169865526258945465087890625, 	    -4.229949723821846419014036655426025390625E-14, 	
	0.73442521666849014394529149285517632961273193359375, 	    -1.609823385706476983614265918731689453125E-15, 	
	0.736416445434684874271624721586704254150390625, 	          2.10942374678779742680490016937255859375E-15, 	
	0.73841307296974800777888958691619336605072021484375, 	     -3.21964677141295396722853183746337890625E-15, 	
	0.740415113911250699629817972891032695770263671875, 	       2.8865798640254070051014423370361328125E-14, 	
	0.74242258293637630739425503634265623986721038818359, 	       1.1102230246251565404236316680908203125E-16, 	
	0.74443549476217785176856978068826720118522644042969, 	    -4.007905118896815110929310321807861328125E-14, 	
	0.74645386414562808763406565049081109464168548583984, 	    -8.382183835919931880198419094085693359375E-15, 	
	0.74847770588359896493102496606297791004180908203125, 	   -3.6137759451548845390789210796356201171875E-14, 	
	0.75050703481324787524897601542761549353599548339844, 	          6.7501559897209517657756805419921875E-14, 	
	0.75254186581171045311577927350299432873725891113281, 	       1.3766765505351941101253032684326171875E-14, 	
	0.75458221379669487838270924839889630675315856933594, 	      -3.1530333899354445748031139373779296875E-14, 	
	0.7566280937263289985139635973609983921051025390625, 	     4.585221091701896511949598789215087890625E-14, 	
	0.75867952059919352425509941895143128931522369384766, 	      1.63868918434673105366528034210205078125E-13, 	
	0.76073650945442450321820615499746054410934448242188, 	      3.26405569239796022884547710418701171875E-14, 	
	0.76279907537223390345815232649329118430614471435547, 	   -6.6668892628740650252439081668853759765625E-14, 	
	0.76486723347362561842288641855702735483646392822266, 	        -3.37507799486047588288784027099609375E-14, 	
	0.76694099892045297650611246353946626186370849609375, 	       -4.707345624410663731396198272705078125E-14, 	
	0.769020386915826748008839786052703857421875, 	             -3.21964677141295396722853183746337890625E-15, 	
	0.77110541270400678737217958769178949296474456787109, 	     6.805667140952209592796862125396728515625E-14, 	
	0.77319609157058200032963668490992859005928039550781, 	    1.3289369604763123788870871067047119140625E-13, 	
	0.77529243884247056595171443404979072511196136474609, 	    -5.473399511402021744288504123687744140625E-14, 	
	0.77739446988852867193031670467462390661239624023438, 	    -2.897682094271658570505678653717041015625E-14, 	
	0.77950220011894166827204344372148625552654266357422, 	    4.2910119901762300287373363971710205078125E-14, 	
	0.78161564498566504788357178767910227179527282714844, 	   -2.5479618415147342602722346782684326171875E-14, 	
	0.78373481998277116922224649897543713450431823730469, 	    -9.714451465470119728706777095794677734375E-15, 	
	0.78585974064617325485215815206174738705158233642578, 	     4.718447854656915296800434589385986328125E-15, 	
	0.78799042255395446154864202981116250157356262207031, 	     2.053912595556539599783718585968017578125E-14, 	
	0.79012688132640618299262769141932949423789978027344, 	      -1.1102230246251565404236316680908203125E-14, 	
	0.79226913262626774692165554370149038732051849365234, 	    3.8025138593411611509509384632110595703125E-14, 	
	0.79441719215853734414878317693364806473255157470703, 	     -8.10462807976364274509251117706298828125E-14, 	
	0.79657107567112928059316345752449706196784973144531, 	       -7.549516567451064474880695343017578125E-15, 	
	0.79873079895434206942894661551690660417079925537109, 	         5.15143483426072634756565093994140625E-14, 	
	0.80089637784129807940303180657792836427688598632812, 	   -8.7541085491693593212403357028961181640625E-14, 	
	0.80306782820842770309610614276607520878314971923828, 	    7.5883743733129449537955224514007568359375E-14, 	
	0.80524516597464967926356393945752643048763275146484, 	    4.0356606945124440244399011135101318359375E-14, 	
	0.80742840710242858026646217695088125765323638916016, 	       -3.108624468950438313186168670654296875E-15, 	
	0.80961756759744374356557727878680452704429626464844, 	    2.1149748619109232095070183277130126953125E-14, 	
	0.81181266350867553605041848641121760010719299316406, 	      1.97619698383277864195406436920166015625E-14, 	
	0.81401371092867125245362558416672982275485992431641, 	      -4.6629367034256574697792530059814453125E-15, 	
	0.81622072599364403622246300074039027094841003417969, 	    1.1490808304870370193384587764739990234375E-14, 	
	0.81843372488350929483402751429821364581584930419922, 	    4.7684078907650473411194980144500732421875E-14, 	
	0.82065272382198950484877286726259626448154449462891, 	   -2.3925306180672123446129262447357177734375E-14, 	
	0.82287773907698935627053060670732520520687103271484, 	    1.2156942119645464117638766765594482421875E-14, 	
	0.82510878696035871993075261343619786202907562255859, 	     8.715250743307478842325508594512939453125E-14, 	
	0.82734588382810592133154159455443732440471649169922, 	     1.521005543736464460380375385284423828125E-14, 	
	0.82958904608081385223528059214004315435886383056641, 	     1.010302952408892451785504817962646484375E-14, 	
	0.83183829016334187578252112871268764138221740722656, 	   -4.5685677463325191638432443141937255859375E-14, 	
	0.83409363256531943164873155183158814907073974609375, 	     4.873879078104437212459743022918701171875E-14, 	
	0.83635508982079909134910167267662473022937774658203, 	     1.387778780781445675529539585113525390625E-15, 	
	0.8386226785089405666440143249928951263427734375, 	            2.220446049250313080847263336181640625E-15, 	
	0.84089641525368497010362034416175447404384613037109, 	    -5.073719222536965389735996723175048828125E-14, 	
	0.84317631672420823019109548113192431628704071044922, 	    1.9817480989559044246561825275421142578125E-14, 	
	0.8454623996346857239814198692329227924346923828125, 	   5.65381075290360968210734426975250244140625E-14, 	
	0.84775468074467597023868847827543504536151885986328, 	    1.6375789613221058971248567104339599609375E-14, 	
	0.85005317685938430738445958922966383397579193115234, 	  2.080280392391387067618779838085174560546875E-13, 	
	0.85235790482897477726709212220157496631145477294922, 	    -8.604228440844963188283145427703857421875E-14, 	
	0.85466888155023146289579472067998722195625305175781, 	      8.32667268468867405317723751068115234375E-17, 	
	0.85698612396497009235929454007418826222419738769531, 	   1.19071419391048038960434496402740478515625E-14, 	
	0.8593096490612399662722964421845972537994384765625, 	    1.6930901125533637241460382938385009765625E-15, 	
	0.86163947387313144510301299305865541100502014160156, 	     -9.21485110438879928551614284515380859375E-15, 	
	0.86397561548091095229295888202614150941371917724609, 	  -1.30728761149612182634882628917694091796875E-14, 	
	0.86631809101116341587101032928330823779106140136719, 	   1.31283872661924760905094444751739501953125E-14, 	
	0.86866691763685810467876535767572931945323944091797, 	     8.271161533457416226156055927276611328125E-15, 	
	0.87102211257756134710206197269144468009471893310547, 	  -2.79498646449383159051649272441864013671875E-14, 	
	0.87338369309957553099366123205982148647308349609375, 	    -1.476596622751458198763430118560791015625E-14, 	
	0.87575167651592977779984039443661458790302276611328, 	     -1.53210777398271602578461170196533203125E-14, 	
	0.878126080186657276271944283507764339447021484375, 	    1.2378986724570495425723493099212646484375E-14, 	
	0.88050692151878506841455873654922470450401306152344, 	    -1.121325254871408105827867984771728515625E-14, 	
	0.88289421796662803654243134587886743247509002685547, 	  -1.36834987785050543607212603092193603515625E-14, 	
	0.88528798703183275708994415253982879221439361572266, 	   9.02333763264095978229306638240814208984375E-14, 	
	0.88768824626324638327190541531308554112911224365234, 	   -2.3148150063434513867832720279693603515625E-14, 	
	0.89009501325749940114917535538552328944206237792969, 	 -3.449185381754205081961117684841156005859375E-13, 	
	0.89250830565945304950759009443572722375392913818359, 	  -2.33424390927439162624068558216094970703125E-14, 	
	0.89492814116070096286392754336702637374401092529297, 	     7.494005416219806647859513759613037109375E-16, 	
	0.89735453750155835805912829528097063302993774414062, 	      7.66053886991358012892305850982666015625E-15, 	
	0.89978751247026977910792311377008445560932159423828, 	    3.5804692544161298428662121295928955078125E-15, 	
	0.90222708390331463057520977599779143929481506347656, 	    4.3021142204224815941415727138519287109375E-15, 	
	0.90467326968550965116122597464709542691707611083984, 	  -1.00197627972420377773232758045196533203125E-14, 	
	0.90712608775020653339993259578477591276168823242188, 	    1.1379786002407854539342224597930908203125E-14, 	
	0.90958555607929203468131618137704208493232727050781, 	    -1.942890293094023945741355419158935546875E-14, 	
	0.91205169270354302657466405435116030275821685791016, 	   2.58959520493817763053812086582183837890625E-14, 	
	0.91452451570245363310363018172211013734340667724609, 	     7.827072323607353609986603260040283203125E-15, 	
	0.91700404320467232555103009872254915535449981689453, 	     1.720845688168992637656629085540771484375E-15, 	
	0.91949029338794130428169637525570578873157501220703, 	    -8.715250743307478842325508594512939453125E-15, 	
	0.92198328447930477658189829526236280798912048339844, 	 -1.280919814661274358513765037059783935546875E-14, 	
	0.9244830347552284166567915235646069049835205078125, 	     4.607425552194399642758071422576904296875E-15, 	
	0.92698956254169728730119004467269405722618103027344, 	   7.00828284294630066142417490482330322265625E-15, 	
	0.92950288621441201630801742794574238359928131103516, 	     2.831068712794149178080260753631591796875E-15, 	
	0.93202302419889149209808465457172133028507232666016, 	   -4.6906922790412863832898437976837158203125E-15, 	
	0.93454999497060231572476141082006506621837615966797, 	   -2.6145752229922436526976525783538818359375E-14, 	
	0.93708381705513721371403335069771856069564819335938, 	 -1.960931417244182739523239433765411376953125E-14, 	
	0.93962450902828797971721996873384341597557067871094, 	  1.211530875622202074737288057804107666015625E-14, 	
	0.94217208951624520363310466564144007861614227294922, 	   1.19404486298435585922561585903167724609375E-13, 	
	0.94472657719547781240976291883271187543869018554688, 	  1.261490911730334119056351482868194580078125E-14, 	
	0.94728799079347547618112912459764629602432250976562, 	  -1.11854969730984521447680890560150146484375E-14, 	
	0.94985634908827609734771613148041069507598876953125, 	     -2.33146835171282873488962650299072265625E-15, 	
	0.95243167090883007475099475414026528596878051757812, 	 -1.064426324859368833131156861782073974609375E-14, 	
	0.95501397513519203918974653788609430193901062011719, 	  -4.31599200823029605089686810970306396484375E-15, 	
	0.95760328069857525434827039134688675403594970703125, 	  2.421673972463622703799046576023101806640625E-15, 	
	0.96019960658153680199689006258267909288406372070312, 	 1.9630130854153549080365337431430816650390625E-14, 	
	0.96280297181806562267780691399821080267429351806641, 	   4.73232564246472975355572998523712158203125E-15, 	
	0.96541339549381399720573426748160272836685180664062, 	   6.17561557447743325610645115375518798828125E-16, 	
	0.96803089674614495319104889858863316476345062255859, 	    -3.386180225106727448292076587677001953125E-15, 	
	0.97065549476431622899497142498148605227470397949219, 	 -5.891120924417236892622895538806915283203125E-15, 	
	0.97328720878958241424783182083046995103359222412109, 	    -5.073719222536965389735996723175048828125E-14, 	
	0.97592605811548926997289754581288434565067291259766, 	    1.8041124150158793781884014606475830078125E-16, 	
	0.97857206208769698108085322019178420305252075195312, 	  -4.64905891561784301302395761013031005859375E-15, 	
	0.98122524010446421360853719306760467588901519775391, 	    7.3552275381416620803065598011016845703125E-16, 	
	0.98388561161659193743389550945721566677093505859375, 	 5.9362237347926338770776055753231048583984375E-15, 	
	0.98655319612761638303766176250064745545387268066406, 	 -1.131039706336878225556574761867523193359375E-15, 	
	0.98922801319396724828436617826810106635093688964844, 	-1.2011225347663412321708165109157562255859375E-14, 	
	0.99191008242510936288027778573450632393360137939453, 	 -4.683753385137379154912196099758148193359375E-16, 	
	0.99459942348362284647578235308174043893814086914062, -1.498280666201168287443579174578189849853515625E-14, 	
	0.99729605608547244877115645067533478140830993652344, 3.3597256920980811401022947393357753753662109375E-15, 	
	1, 	                                                 0, 	
	1.0027112750502022997522999503416940569877624511719, 	 -2.671474153004282925394363701343536376953125E-16, 	
	1.0054299011127916241292723498190753161907196044922,   -1.60670088344971873084432445466518402099609375E-14, 	
	1.0081558981184177703482873766915872693061828613281, 	  3.642919299551294898265041410923004150390625E-16, 	
	1.0108892860517029177458425692748278379440307617188, 	 3.5076108684251039449009113013744354248046875E-15, 	
	1.0136300849514889854674493108177557587623596191406, 	  -6.45317133063372239121235907077789306640625E-16, 	
	1.0163783149109539838406135459081269800662994384766, 	 1.3426759704060486910748295485973358154296875E-15, 	
	1.0191339960777214823650638209073804318904876708984, 	-2.33112140701763337347074411809444427490234375E-14, 	
	1.0218971486541108539825017942348495125770568847656, 	 -8.222589276130065627512522041797637939453125E-15, 	
	1.0246677928971383852996268615243025124073028564453, 	    3.8580250105724189779721200466156005859375E-15, 	
	1.0274459491187770687758984422544017434120178222656, 	  1.877664690397295998991467058658599853515625E-14, 	
	1.0302316376860389812719631663640029728412628173828, 	  -2.84494650060196363483555614948272705078125E-15, 	
	1.033024879021230191256108810193836688995361328125, 	    2.4702462297909733024425804615020751953125E-15, 	
	1.0358256936019518690272889216430485248565673828125, 	  -7.31359417471821871004067361354827880859375E-15, 	
	1.0386341019613787306496988094295375049114227294922, 	     -8.32667268468867405317723751068115234375E-17, 	
	1.041450124688321210442154551856219768524169921875, 	    7.0221606307541151181794703006744384765625E-15, 	
	1.0442737824274095359555758477654308080673217773438, 	 -5.946632075648494719644077122211456298828125E-15, 	
	1.0471050958792909035821594443405047059059143066406, 	   1.42941214420488904579542577266693115234375E-15, 	
	1.0499440858006940935354123212164267897605895996094, 	     9.381384558082572766579687595367431640625E-15, 	
	1.0527907730046219825226216926239430904388427734375, 	  -5.95357096955240194802172482013702392578125E-15, 	
	1.0556451783605751426620145139168016612529754638672, 	  2.457756220763940291362814605236053466796875E-14, 	
	1.0585073227945058782495380000909790396690368652344, 	  -9.28424004342787156929261982440948486328125E-15, 	
	1.061377227289252545006092987023293972015380859375, 	  -1.29618538124987026094458997249603271484375E-14, 	
	1.0642549128844673855809332962962798774242401123047, 	   3.84414722276460452121682465076446533203125E-15, 	
	1.0671404006768259176141100397217087447643280029297, 	        3.108624468950438313186168670654296875E-15, 	
	1.0700337118202567499025690267444588243961334228516, 	  2.019218126037003457895480096340179443359375E-14, 	
	1.0729348675259775536261486195144243538379669189453, 	    2.6922908347160046105273067951202392578125E-15, 	
	1.0758438890627808337541182481800206005573272705078, 	  -1.36834987785050543607212603092193603515625E-14, 	
	1.0787607977571218587087287232861854135990142822266, 	   2.76167977375507689430378377437591552734375E-15, 	
	1.0816856149932174702144038747064769268035888671875, 	    3.0253577421035515726543962955474853515625E-15, 	
	1.0846183622133163115819343147450126707553863525391, 	    9.4091401336982016800902783870697021484375E-15, 	
	1.0875590609177760992309913490316830575466156005859, 	   8.53483950180589090450666844844818115234375E-15, 	
	1.0905077326652909963655702085816301405429840087891, 	   4.41036096532343435683287680149078369140625E-14, 	
	1.0934643990728785123422994729480706155300140380859, 	   -9.6866958898544908151961863040924072265625E-15, 	
	1.0964290818163575647048446626286022365093231201172, 	  -2.53408405370691980351693928241729736328125E-14, 	
	1.0994018026302341262123718479415401816368103027344, 	    1.5931700403370996355079114437103271484375E-14, 	
	1.1023825833078519931262917452841065824031829833984, 	   1.44606548957426639390178024768829345703125E-14, 	
	1.1053714457016148298151847484405152499675750732422, 	 -1.650068970349138908204622566699981689453125E-13, 	
	1.1083684117237071475869925052393227815628051757812, 	   3.71092045980958573636598885059356689453125E-14, 	
	1.1113735033448086664265019862796179950237274169922, 	   -1.1601830607332885847426950931549072265625E-14, 	
	1.1143867425958942085628677887143567204475402832031, 	     2.164934898019055253826081752777099609375E-15, 	
	1.1174081515673714992686882396810688078403472900391, 	    2.9698465908722937456332147121429443359375E-15, 	
	1.1204377524096127416441959212534129619598388671875, 	    7.7993167479917246964760124683380126953125E-15, 	
	1.1234755673330008018950820769532583653926849365234, 	  -2.43971509661378149758093059062957763671875E-14, 	
	1.1265216186082829263881421866244636476039886474609, 	   5.25413046403855332755483686923980712890625E-14, 	
	1.1295759285662891890922310267342254519462585449219, 	        1.332267629550187848508358001708984375E-15, 	
	1.1326385195987571652409542366513051092624664306641, 	   4.83224571468099384219385683536529541015625E-14, 	
	1.1357094141578236712319949219818226993083953857422, 	   2.30648833365876271273009479045867919921875E-14, 	
	1.1387886347566735789627045960514806210994720458984, 	  -2.28983498828938536462374031543731689453125E-14, 	
	1.1418762039695680154949286588816903531551361083984, 	    8.0768725041480138315819203853607177734375E-15, 	
	1.1449721444317906282606145396130159497261047363281, 	  -1.71251901548430396360345184803009033203125E-14, 	
	1.148076478840192038433087873272597789764404296875, 	    1.6375789613221058971248567104339599609375E-14, 	
	1.1511892299529953298531381733482703566551208496094, 	    1.5820678100908480701036751270294189453125E-14, 	
	1.1543104205902670056360648231930099427700042724609, 	   6.36990460378683565068058669567108154296875E-14, 	
	1.1574400736337362438632681005401536822319030761719, 	     -1.84297022087775985710322856903076171875E-14, 	
	1.160578212027484568125146324746310710906982421875, 	  -1.76247905159243600792251527309417724609375E-14, 	
	1.1637248587775863573057222311035729944705963134766, 	   1.09634523681734208366833627223968505859375E-14, 	
	1.1668800369524550131217210946488194167613983154297, 	  -3.28348459532890046830289065837860107421875E-14, 	
	1.1700437696832879375108404929051175713539123535156, 	   4.65461003074096879572607576847076416015625E-14, 	
	1.1732160801636253300017642686725594103336334228516, 	      -1.4654943925052066333591938018798828125E-14, 	
	1.1763969916502701185123669347376562654972076416016, 	  -1.36834987785050543607212603092193603515625E-14, 	
	1.1795865274628722918492940152646042406558990478516, 	   -4.4686476741162550752051174640655517578125E-15, 	
	1.1827847109843110384730380246764980256557464599609, 	   -3.6581848661398908006958663463592529296875E-14, 	
	1.1859915656609776313246129575418308377265930175781, 	   -1.9706458687096528592519462108612060546875E-14, 	
	1.1892071150026677361921656483900733292102813720703, 	  -6.46982467600309973931871354579925537109375E-14, 	
	1.1924313825823584789276310402783565223217010498047, 	   -9.5912167097367273527197539806365966796875E-13, 	
	1.1956643920398004610206044162623584270477294921875, 	   -3.2474023470285828807391226291656494140625E-14, 	
	1.1989061670743486054391269135521724820137023925781, 	   -3.8358205500799158471636474132537841796875E-14, 	
	1.2021567314527259462408892431994900107383728027344, 	    2.7366997557010108721442520618438720703125E-14, 	
	1.2054161090051225269093038150458596646785736083984, 	      -1.5543122344752191565930843353271484375E-15, 	
	1.2086843236265314427413386511034332215785980224609, 	    -5.984102102729593752883374691009521484375E-14, 	
	1.2119613992768292209945002468884922564029693603516, 	    3.3362201889985954039730131626129150390625E-14, 	
	1.2152473599804933801493689315975643694400787353516, 	      2.90878432451791013590991497039794921875E-14, 	
	1.2185422298273915764355024293763563036918640136719, 	    -1.987299214079030207358300685882568359375E-14, 	
	1.2218460329727474089622774044983088970184326171875, 	   -1.1934897514720432809554040431976318359375E-14, 	
	1.2251587936370220699444644196773879230022430419922, 	  -1.45272682772201733314432203769683837890625E-13, 	
	1.22848053610687912851062719710171222686767578125, 	        1.0713652187632760615088045597076416015625E-14, 	
	1.2318112847341684545909856751677580177783966064453, 	        1.083577672034152783453464508056640625E-13, 	
	1.2351510639369362998252199759008362889289855957031, 	     3.497202527569243102334439754486083984375E-15, 	
	1.2384998981997985545433493825839832425117492675781, 	    -2.098321516541545861400663852691650390625E-14, 	
	1.2418578120735179748379550801473669707775115966797, 	     3.941291737419305718503892421722412109375E-14, 	
	1.2452248301751067671716555196326225996017456054688, 	  -1.75137682134618444251827895641326904296875E-13, 	
	1.2486009771891160013979060749989002943038940429688, 	  -1.02529096324133206508122384548187255859375E-13, 	
	1.2519862778663497504538781868177466094493865966797, 	    3.8580250105724189779721200466156005859375E-14, 	
	1.2553807570247148550635074570891447365283966064453, 	      2.73114864057788508944213390350341796875E-14, 	
	1.2587844395497014282625514169922098517417907714844, 	    -1.720845688168992637656629085540771484375E-14, 	
	1.26219735039428115896953386254608631134033203125, 	        3.4805491821998657542280852794647216796875E-14, 	
	1.2656195145788113887164172410848550498485565185547, 	        5.773159728050814010202884674072265625E-15, 	
	1.2690509571917287789943884490639902651309967041016, 	    -5.051514762044462258927524089813232421875E-15, 	
	1.2724917033893918816289669848629273474216461181641, 	    -1.232347557333923759870231151580810546875E-14, 	
	1.2759417783963775683275798655813559889793395996094, 	      -1.6431300764452316798269748687744140625E-14, 	
	1.2794012075057223931651151360711082816123962402344, 	       5.9952043329758453182876110076904296875E-14, 	
	1.282870016078732078312896192073822021484375, 	              -5.1958437552457326091825962066650390625E-14, 	
	1.2863482295460366700012855289969593286514282226562, 	    1.2490009027033011079765856266021728515625E-14, 	
	1.2898358734066417419228400831343606114387512207031, 	   -2.6922908347160046105273067951202392578125E-14, 	
	1.2933329732290987923448710716911591589450836181641, 	      1.04360964314764714799821376800537109375E-14, 	
	1.2968395546509940974289065707125701010227203369141, 	      -1.7319479184152442030608654022216796875E-14, 	
	1.3003556433796572555650072899879887700080871582031, 	       7.3274719625260331667959690093994140625E-15, 	
	1.3038812651919815532863822227227501571178436279297, 	     5.051514762044462258927524089813232421875E-14, 	
	1.3074164459346540034800909779733046889305114746094, 	    -2.564615186884111608378589153289794921875E-14, 	
	1.3109612115247846197974013193743303418159484863281, 	     2.231548279496564646251499652862548828125E-14, 	
	1.3145155879493446438033288359292782843112945556641, 	    -1.099120794378904975019395351409912109375E-14, 	
	1.3180796012660587201992257178062573075294494628906, 	       -5.773159728050814010202884674072265625E-15, 	
	1.3216532776033269591664520703488960862159729003906, 	     1.849631559025510796345770359039306640625E-13, 	
	1.3252366431597040197232217906275764107704162597656, 	   -4.0578651550049471552483737468719482421875E-14, 	
	1.3288297242058946245890638238051906228065490722656, 	   -6.4892535789340399787761270999908447265625E-14, 	
	1.3324325470833204843046360110747627913951873779297, 	    1.7219559111936177941970527172088623046875E-13, 	
	1.3360451382041798051858449980500154197216033935547, 	     3.674838211509268148802220821380615234375E-14, 	
	1.3396675240534174911033460375620052218437194824219, 	   1.23290266884623633814044296741485595703125E-13, 	
	1.3432997311867924672412755171535536646842956542969, 	     -4.59632332194814807735383510589599609375E-14, 	
	1.3469417862329142732136233462370000779628753662109, 	   -3.3806291099836016655899584293365478515625E-14, 	
	1.3505937158922334262456388387363404035568237304688, 	    2.1260770921571747749112546443939208984375E-13, 	
	1.3542555469368922071993210920481942594051361083984, 	      -5.5511151231257827021181583404541015625E-16, 	
	1.3579273062129546545406810764688998460769653320312, 	     5.695444116327053052373230457305908203125E-14, 	
	1.3616090206381865623797011721762828528881072998047, 	   -4.0467629247586955898441374301910400390625E-14, 	
	1.3653007172041637939940983414999209344387054443359, 	   1.60593760512028893572278320789337158203125E-13, 	
	1.3690024229745676453973146635689772665500640869141, 	     -2.42028619368284125812351703643798828125E-14, 	
	1.3727141650876881762144421372795477509498596191406, 	    2.0816681711721685132943093776702880859375E-14, 	
	1.3764359707545690270080740447156131267547607421875, 	    4.0800696154974502860568463802337646484375E-14, 	
	1.3801678672602453179507620006916113197803497314453, 	        7.549516567451064474880695343017578125E-15, 	
	1.3839098819638133708309624125831760466098785400391, 	   -1.9373391779708981630392372608184814453125E-14, 	
	1.3876620422985130876014636669424362480640411376953, 	   -1.6708856520608605933375656604766845703125E-14, 	
	1.3914243757719233496317201570491306483745574951172, 	    -2.942091015256664832122623920440673828125E-15, 	
	1.3951969099661583051386060105869546532630920410156, 	     -4.32986979603811050765216350555419921875E-14, 	
	1.3989796725393028875572554170503281056880950927734, 	     1.022737450284694205038249492645263671875E-12, 	
	1.4027726912201248232747730071423575282096862792969, 	      -8.2156503822261583991348743438720703125E-14, 	
	1.4065759938190178779393590957624837756156921386719, 	     2.498001805406602215953171253204345703125E-15, 	
	1.4103896082172264758725077626877464354038238525391, 	   -4.5241588253475129022262990474700927734375E-14, 
};

/*
 * exp2(x): compute the base 2 exponential of x
 *
 * Accuracy: Peak error < 0.503 ulp for normalized results.
 *
 * Method: (accurate tables)
 *
 *   Reduce x:
 *     x = 2**k + y, for integer k and |y| <= 1/2.
 *     Thus we have exp2(x) = 2**k * exp2(y).
 *
 *   Reduce y:
 *     y = i/TBLSIZE + z - eps[i] for integer i near y * TBLSIZE.
 *     Thus we have exp2(y) = exp2(i/TBLSIZE) * exp2(z - eps[i]),
 *     with |z - eps[i]| <= 2**-9 + 2**-39 for the table used.
 *
 *   We compute exp2(i/TBLSIZE) via table lookup and exp2(z - eps[i]) via
 *   a degree-5 minimax polynomial with maximum error under 1.3 * 2**-61.
 *   The values in exp2t[] and eps[] are chosen such that
 *   exp2t[i] = exp2(i/TBLSIZE + eps[i]), and eps[i] is a small offset such
 *   that exp2t[i] is accurate to 2**-64.
 *
 *   Note that the range of i is +-TBLSIZE/2, so we actually index the tables
 *   by i0 = i + TBLSIZE/2.  For cache efficiency, exp2t[] and eps[] are
 *   virtual tables, interleaved in the real table tbl[].
 *
 *   This method is due to Gal, with many details due to Gal and Bachelis:
 *
 *	Gal, S. and Bachelis, B.  An Accurate Elementary Mathematical Library
 *	for the IEEE Floating Point Standard.  TOMS 17(1), 26-46 (1991).
 */
double
exp2(double x)
{
	double r, t, twopk, twopkp1000, z;
	uint32_t hx, ix, lx, i0;
	int k;

	/* Filter out exceptional cases. */
	GET_HIGH_WORD(hx,x);
	ix = hx & 0x7fffffff;		/* high word of |x| */
	if(ix >= 0x40900000) {			/* |x| >= 1024 */
		if(ix >= 0x7ff00000) {
			GET_LOW_WORD(lx,x);
			if(((ix & 0xfffff) | lx) != 0 || (hx & 0x80000000) == 0)
				return (x + x);	/* x is NaN or +Inf */
			else 
				return (0.0);	/* x is -Inf */
		}
		if(x >=  1024)  //x >= 0x1.0p10
			return (huge * huge); /* overflow */
		if(x <= -1075)	//x<=  -0x1.0ccp10
			return (twom1000 * twom1000); /* underflow */
	} else if (ix < 0x3c900000) {		/* |x| < 0x1p-54 */
		return (1.0 + x);
	}

	/* Reduce x, computing z, i0, and k. */
	STRICT_ASSIGN(double, t, x + redux);
	GET_LOW_WORD(i0, t);
	i0 += TBLSIZE / 2;
	k = (i0 >> TBLBITS) << 20;
	i0 = (i0 & (TBLSIZE - 1)) << 1;
	t -= redux;
	z = x - t;

	/* Compute r = exp2(y) = exp2t[i0] * p(z - eps[i]). */
	t = tbl[i0];		/* exp2t[i0] */
	z -= tbl[i0 + 1];	/* eps[i0]   */
	if (k >= -(1021 << 20))
		INSERT_WORDS(twopk, 0x3ff00000 + k, 0);
	else
		INSERT_WORDS(twopkp1000, 0x3ff00000 + k + (1000 << 20), 0);
	r = t + t * z * (P1 + z * (P2 + z * (P3 + z * (P4 + z * P5))));

	/* Scale by 2**(k>>20). */
	if(k >= -(1021 << 20)) {
		if (k == 1024 << 20)
			return (r * 2.0 * ( 8.9884656743115795386E+307));	 //r*2.0*0x1p1023 
		return (r * twopk);
	} else {
		return (r * twopkp1000 * twom1000);
	}
}
