/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.tapestry5.commons.util.TimeInterval;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestFilter;
import org.apache.tapestry5.http.services.RequestHandler;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.ConcurrentBarrier;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;

public class CheckForUpdatesFilter
implements RequestFilter {
    private final long checkInterval;
    private final long updateTimeout;
    private final UpdateListenerHub updateListenerHub;
    private final ConcurrentBarrier barrier = new ConcurrentBarrier();
    private final Runnable checker = new Runnable(){

        @Override
        public void run() {
            if (System.currentTimeMillis() - CheckForUpdatesFilter.this.lastCheck >= CheckForUpdatesFilter.this.checkInterval) {
                CheckForUpdatesFilter.this.updateListenerHub.fireCheckForUpdates();
                CheckForUpdatesFilter.this.lastCheck = System.currentTimeMillis();
            }
        }
    };
    private long lastCheck = 0L;

    public CheckForUpdatesFilter(UpdateListenerHub updateListenerHub, @Symbol(value="tapestry.file-check-interval") @IntermediateType(value=TimeInterval.class) long checkInterval, @Symbol(value="tapestry.file-check-update-timeout") @IntermediateType(value=TimeInterval.class) long updateTimeout) {
        this.updateListenerHub = updateListenerHub;
        this.checkInterval = checkInterval;
        this.updateTimeout = updateTimeout;
    }

    public boolean service(final Request request, final Response response, final RequestHandler handler) throws IOException {
        final Holder exceptionHolder = new Holder();
        Invokable<Boolean> invokable = new Invokable<Boolean>(){

            public Boolean invoke() {
                if (System.currentTimeMillis() - CheckForUpdatesFilter.this.lastCheck >= CheckForUpdatesFilter.this.checkInterval) {
                    CheckForUpdatesFilter.this.barrier.tryWithWrite(CheckForUpdatesFilter.this.checker, CheckForUpdatesFilter.this.updateTimeout, TimeUnit.MILLISECONDS);
                }
                try {
                    return handler.service(request, response);
                }
                catch (IOException ex) {
                    exceptionHolder.put(ex);
                    return false;
                }
            }
        };
        boolean result = (Boolean)this.barrier.withRead((Invokable)invokable);
        if (exceptionHolder.hasValue()) {
            throw (IOException)exceptionHolder.get();
        }
        return result;
    }
}

