/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.messages;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.util.VirtualResource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ClientLocalizationMessageResource
extends VirtualResource {
    private final Locale locale;

    public ClientLocalizationMessageResource() {
        this(null);
    }

    ClientLocalizationMessageResource(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Resource withExtension(String extension) {
        return this;
    }

    @Override
    public String getPath() {
        return String.format("<Client localization symbols for locale %s>", this.locale == null ? "(none)" : this.locale);
    }

    @Override
    public String getFile() {
        return null;
    }

    @Override
    public URL toURL() {
        return null;
    }

    @Override
    public Resource forLocale(Locale locale) {
        return new ClientLocalizationMessageResource(locale);
    }

    public InputStream openStream() throws IOException {
        DecimalFormatSymbols decimalSymbols = DecimalFormatSymbols.getInstance(this.locale);
        Map symbols = CollectionFactory.newMap();
        symbols.put("decimal-symbols.group", Character.valueOf(decimalSymbols.getGroupingSeparator()));
        symbols.put("decimal-symbols.minus", Character.valueOf(decimalSymbols.getMinusSign()));
        symbols.put("decimal-symbols.decimal", Character.valueOf(decimalSymbols.getDecimalSeparator()));
        DateFormatSymbols dateSymbols = new DateFormatSymbols(this.locale);
        List<String> months = Arrays.asList(dateSymbols.getMonths()).subList(0, 12);
        symbols.put("date-symbols.months", InternalUtils.join(months, (String)","));
        List<String> days = Arrays.asList(dateSymbols.getWeekdays()).subList(1, 8);
        symbols.put("date-symbols.days", InternalUtils.join(days, (String)","));
        Calendar c = Calendar.getInstance(this.locale);
        symbols.put("date-symbols.first-day", c.getFirstDayOfWeek() - 1);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : symbols.entrySet()) {
            this.write(builder, (String)entry.getKey(), entry.getValue());
        }
        return this.toInputStream(builder.toString());
    }

    private void write(StringBuilder builder, String name, Object value) {
        builder.append(name).append('=').append(value).append('\n');
    }
}

