/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.test.ErrorReporter;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.testng.ITestContext;

public class ErrorReporterImpl
implements ErrorReporter {
    private final WebDriver webdriver;
    private final ITestContext testContext;
    private int uid = 0;
    private final Set<String> previousNames = new HashSet<String>();
    private final List<File> outputPaths = new ArrayList<File>();

    public ErrorReporterImpl(WebDriver webdriver, ITestContext testContext) {
        this.webdriver = webdriver;
        this.testContext = testContext;
    }

    public void writeOutputPaths() {
        if (this.outputPaths.isEmpty()) {
            return;
        }
        System.err.println("Page captures written to:");
        for (File file : this.outputPaths) {
            try {
                System.err.println("  " + file.getCanonicalPath());
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void writeErrorReport(String reportText) {
        String baseFileName;
        String htmlSource = this.webdriver.getPageSource();
        File dir = new File(this.testContext.getOutputDirectory());
        dir.mkdirs();
        Method testMethod = (Method)this.testContext.getAttribute("tapestry.current-test-method");
        String string = baseFileName = testMethod == null ? "Unknown-test" : testMethod.getDeclaringClass().getSimpleName() + "." + testMethod.getName();
        if (this.previousNames.contains(baseFileName)) {
            baseFileName = baseFileName + "-" + this.uid++;
        } else {
            this.previousNames.add(baseFileName);
        }
        File report = new File(dir, baseFileName + ".txt");
        System.err.println("Writing failure report to: " + report);
        this.writeContent(report, reportText);
        File capturedSource = new File(dir, baseFileName + ".html");
        System.err.println("Writing current page's HTML source to: " + capturedSource);
        this.writeContent(capturedSource, htmlSource);
        File capture = new File(dir, baseFileName + ".png");
        System.err.println("Writing current page screenshot to: " + capture);
        try {
            byte[] screenshotBytes = (byte[])((TakesScreenshot)this.webdriver).getScreenshotAs(OutputType.BYTES);
            Files.write(capture.toPath(), screenshotBytes, new OpenOption[0]);
            this.outputPaths.add(capture);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void writeContent(File file, String content) {
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(content);
            this.outputPaths.add(file);
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

