/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class InjectPageWorker
implements ComponentClassTransformWorker2 {
    private final ComponentSource componentSource;
    private final ComponentClassResolver resolver;
    private final PerthreadManager perThreadManager;

    public InjectPageWorker(ComponentSource componentSource, ComponentClassResolver resolver, PerthreadManager perThreadManager) {
        this.componentSource = componentSource;
        this.resolver = resolver;
        this.perThreadManager = perThreadManager;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(InjectPage.class)) {
            this.addInjectedPage(field);
        }
    }

    private void addInjectedPage(PlasticField field) {
        InjectPage annotation = (InjectPage)field.getAnnotation(InjectPage.class);
        field.claim((Object)annotation);
        String pageName = annotation.value();
        String fieldName = field.getName();
        String injectedPageName = InternalUtils.isBlank((String)pageName) ? this.resolver.resolvePageClassNameToPageName(field.getTypeName()) : pageName;
        field.setConduit((FieldConduit)new InjectedPageConduit(field.getPlasticClass().getClassName(), fieldName, injectedPageName));
    }

    private final class InjectedPageConduit
    extends ReadOnlyComponentFieldConduit {
        private final String injectedPageName;
        private final ObjectCreator<Object> pageValue;

        private InjectedPageConduit(String className, String fieldName, String injectedPageName) {
            super(className, fieldName);
            this.pageValue = InjectPageWorker.this.perThreadManager.createValue((ObjectCreator)new ObjectCreator<Object>(){

                public Object createObject() {
                    return InjectPageWorker.this.componentSource.getPage(InjectedPageConduit.this.injectedPageName);
                }
            });
            this.injectedPageName = injectedPageName;
        }

        public Object get(Object instance, InstanceContext context) {
            return this.pageValue.createObject();
        }
    }
}

