/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tapestry5.internal.services.SessionLock;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Session;

public class SessionImpl
implements Session {
    private final HttpServletRequest request;
    private final HttpSession session;
    private boolean invalidated = false;
    private final SessionLock lock;

    public SessionImpl(HttpServletRequest request, HttpSession session, SessionLock lock) {
        this.request = request;
        this.session = session;
        this.lock = lock;
    }

    @Override
    public Object getAttribute(String name) {
        this.lock.acquireWriteLock();
        return this.session.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        this.lock.acquireReadLock();
        return InternalUtils.toList((Enumeration)this.session.getAttributeNames());
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.lock.acquireWriteLock();
        this.session.setAttribute(name, value);
    }

    @Override
    public List<String> getAttributeNames(String prefix) {
        this.lock.acquireReadLock();
        List result = CollectionFactory.newList();
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        this.session.invalidate();
    }

    @Override
    public boolean isInvalidated() {
        if (this.invalidated) {
            return true;
        }
        this.invalidated = this.request.getSession(false) != this.session;
        return this.invalidated;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this.session.setMaxInactiveInterval(seconds);
    }

    @Override
    public void restoreDirtyObjects() {
    }
}

