/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.alerts;

import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.alerts.AlertStorage;
import org.apache.tapestry5.alerts.Duration;
import org.apache.tapestry5.alerts.Severity;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.ajax.JavaScriptCallback;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class AlertManagerImpl
implements AlertManager {
    private final ApplicationStateManager asm;
    private final Request request;
    private final AjaxResponseRenderer ajaxResponseRenderer;
    private final PerThreadValue<Boolean> needAlertStorageCleanup;

    public AlertManagerImpl(ApplicationStateManager asm, Request request, AjaxResponseRenderer ajaxResponseRenderer, PerthreadManager perThreadManager) {
        this.asm = asm;
        this.request = request;
        this.ajaxResponseRenderer = ajaxResponseRenderer;
        this.needAlertStorageCleanup = perThreadManager.createValue();
    }

    @Override
    public void success(String message) {
        this.alert(Duration.SINGLE, Severity.SUCCESS, message);
    }

    @Override
    public void info(String message) {
        this.alert(Duration.SINGLE, Severity.INFO, message);
    }

    @Override
    public void warn(String message) {
        this.alert(Duration.SINGLE, Severity.WARN, message);
    }

    @Override
    public void error(String message) {
        this.alert(Duration.SINGLE, Severity.ERROR, message);
    }

    @Override
    public void alert(Duration duration, Severity severity, String message) {
        this.alert(duration, severity, message, false);
    }

    @Override
    public void alert(Duration duration, Severity severity, String message, boolean markup) {
        Alert alert = new Alert(duration, severity, message, markup);
        if (this.request.isXHR()) {
            this.addCallbackForAlert(alert);
        }
        this.getAlertStorage().add(alert);
    }

    private void addCallbackForAlert(final Alert alert) {
        this.ajaxResponseRenderer.addCallback(new JavaScriptCallback(){

            @Override
            public void run(JavaScriptSupport javascriptSupport) {
                javascriptSupport.require("t5/core/alert").with(alert.toJSON());
            }
        });
        this.addAlertStorageCleanupCallback();
    }

    private void addAlertStorageCleanupCallback() {
        if (((Boolean)this.needAlertStorageCleanup.get((Object)true)).booleanValue()) {
            this.ajaxResponseRenderer.addCallback(new JavaScriptCallback(){

                @Override
                public void run(JavaScriptSupport javascriptSupport) {
                    AlertManagerImpl.this.getAlertStorage().dismissNonPersistent();
                }
            });
            this.needAlertStorageCleanup.set((Object)false);
        }
    }

    private AlertStorage getAlertStorage() {
        return this.asm.get(AlertStorage.class);
    }
}

