/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.columns.IHashArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class HashIntegerArray
extends Array<Object>
implements IHashArray {
    private int[] _data;

    private HashIntegerArray(int nRow) {
        this(new int[nRow]);
    }

    public HashIntegerArray(int[] data) {
        super(data.length);
        this._data = data;
    }

    public HashIntegerArray(String[] data) {
        super(data.length);
        this._data = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            this._data[i] = HashIntegerArray.parseHashInt(data[i]);
        }
    }

    @Override
    public Object get() {
        throw new NotImplementedException("Invalid to get underlying array in Hash");
    }

    @Override
    public Object get(int index) {
        return Integer.toHexString(this._data[index]);
    }

    @Override
    public Object getInternal(int index) {
        return this._data[index];
    }

    @Override
    public long getLong(int index) {
        return this._data[index];
    }

    @Override
    public int getInt(int index) {
        return this._data[index];
    }

    protected int[] getInts() {
        return this._data;
    }

    @Override
    public void set(int index, Object value) {
        if (value instanceof String) {
            this._data[index] = HashIntegerArray.parseHashInt((String)value);
        } else if (value instanceof Integer) {
            this._data[index] = (Integer)value;
        } else if (value == null) {
            this._data[index] = 0;
        } else {
            throw new NotImplementedException("not supported : " + value);
        }
    }

    @Override
    public void set(int index, String value) {
        this._data[index] = HashIntegerArray.parseHashInt(value);
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (int)value;
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = HashIntegerArray.parseHashInt(value.get(i));
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Object> value) {
        if (value instanceof HashIntegerArray) {
            int[] thatVals = ((HashIntegerArray)value)._data;
            for (int i = rl; i <= ru; ++i) {
                if (thatVals[i] == 0) continue;
                this._data[i] = thatVals[i];
            }
        } else {
            throw new NotImplementedException("Not supported type of array: " + value.getClass().getSimpleName());
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        if (value instanceof HashIntegerArray) {
            this.setNz(rl, ru, (HashIntegerArray)value);
        } else if (value instanceof StringArray) {
            StringArray st = (StringArray)value;
            for (int i = rl; i <= ru; ++i) {
                if (st.get(i) == null) continue;
                this._data[i] = HashIntegerArray.parseHashInt(st.get(i));
            }
        } else {
            Types.ValueType vt = value.getValueType();
            for (int i = rl; i <= ru; ++i) {
                Object v = value.get(i);
                if (v == null) continue;
                this._data[i] = UtilFunctions.objectToInteger(vt, v);
            }
        }
    }

    @Override
    public void append(Object value) {
        this.append(HashIntegerArray.parseHashInt(value));
    }

    @Override
    public void append(String value) {
        this.append(HashIntegerArray.parseHashInt(value));
    }

    @Override
    public void append(int value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value;
    }

    @Override
    public Array<Object> append(Array<Object> other) {
        if (other instanceof HashIntegerArray) {
            int endSize = this._size + other.size();
            int[] ret = new int[endSize];
            System.arraycopy(this._data, 0, ret, 0, this._size);
            System.arraycopy(((HashIntegerArray)other)._data, 0, ret, this._size, other.size());
            return new HashIntegerArray(ret);
        }
        if (other instanceof OptionalArray) {
            OptionalArray ot = (OptionalArray)other;
            if (ot._a instanceof HashIntegerArray) {
                Array<Object> a = this.append(ot._a);
                return OptionalArray.appendOther(ot, a);
            }
        }
        throw new NotImplementedException(other.getClass().getSimpleName() + " not append supported in hashColumn");
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.HASH32.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readInt();
        }
    }

    protected static HashIntegerArray read(DataInput in, int nRow) throws IOException {
        HashIntegerArray arr = new HashIntegerArray(nRow);
        arr.readFields(in);
        return arr;
    }

    @Override
    public Array<Object> clone() {
        return new HashIntegerArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Object> slice(int rl, int ru) {
        return new HashIntegerArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new int[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        throw new NotImplementedException("Unclear how this byte array should look like for Hash");
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.HASH32;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.HASH32, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.HASH32;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 4 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet(Array<Boolean> ret, int l, int u) {
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0 && this._data[i] != 1) {
                throw new DMLRuntimeException("Unable to change to Boolean from Hash array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0);
        }
        return ret;
    }

    @Override
    protected Array<Boolean> changeTypeBoolean(Array<Boolean> retA, int l, int u) {
        boolean[] ret = (boolean[])retA.get();
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0 && this._data[i] != 1) {
                throw new DMLRuntimeException("Unable to change to Boolean from Hash array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0;
        }
        return retA;
    }

    @Override
    protected Array<Double> changeTypeDouble(Array<Double> retA, int l, int u) {
        double[] ret = (double[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Float> changeTypeFloat(Array<Float> retA, int l, int u) {
        float[] ret = (float[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Integer> changeTypeInteger(Array<Integer> retA, int l, int u) {
        int[] ret = (int[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Long> changeTypeLong(Array<Long> retA, int l, int u) {
        long[] ret = (long[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash64(Array<Object> retA, int l, int u) {
        long[] ret = ((HashLongArray)retA).getLongs();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash32(Array<Object> retA, int l, int u) {
        int[] ret = ((HashIntegerArray)retA).getInts();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<String> changeTypeString(Array<String> retA, int l, int u) {
        String[] ret = (String[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this.get(i).toString();
        }
        return retA;
    }

    @Override
    public Array<Character> changeTypeCharacter(Array<Character> retA, int l, int u) {
        char[] ret = (char[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this.get(i).toString().charAt(0);
        }
        return retA;
    }

    @Override
    public void fill(String value) {
        this.fill(HashIntegerArray.parseHashInt(value));
    }

    @Override
    public void fill(Object value) {
        this.fill(HashIntegerArray.parseHashInt(value));
    }

    @Override
    private void fill(int value) {
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static int parseHashInt(Object s) {
        if (s == null) {
            return 0;
        }
        if (s instanceof String) {
            return HashIntegerArray.parseHashInt((String)s);
        }
        if (s instanceof Long) {
            return ((Long)s).intValue();
        }
        if (s instanceof Integer) {
            return (Integer)s;
        }
        throw new NotImplementedException("not supported parsing: " + s + " of class: " + s.getClass().getSimpleName());
    }

    public static int parseHashInt(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return (int)Long.parseUnsignedLong(s, 16);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if ((long)this._data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Object> select(int[] indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new HashIntegerArray(ret);
    }

    @Override
    public Array<Object> select(boolean[] select, int nTrue) {
        int[] ret = new int[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new HashIntegerArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0;
    }

    @Override
    public double hashDouble(int idx) {
        return Long.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Object> other) {
        if (other instanceof HashIntegerArray) {
            return Arrays.equals(this._data, ((HashIntegerArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return false;
    }

    @Override
    protected int addValRecodeMap(HashMapToInt<Object> map, int id, int i) {
        Integer val = this.getInt(i);
        Integer v = map.putIfAbsent((Object)val, id);
        if (v == null) {
            ++id;
        }
        return id;
    }

    @Override
    public void setM(HashMapToInt<Object> map, AMapToData m, int i) {
        m.set(i, map.get(this.getInt(i)) - 1);
    }

    @Override
    public void setM(HashMapToInt<Object> map, int si, AMapToData m, int i) {
        Integer v = this.getInt(i);
        m.set(i, map.get(v) - 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

