/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.context;

import java.util.concurrent.Future;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.UnifiedMemoryManager;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.stats.SparkStatistics;

public class MatrixObjectFuture
extends MatrixObject {
    private static final long serialVersionUID = 8016955240352642173L;
    protected Future<MatrixBlock> _futureData;

    public MatrixObjectFuture(Types.ValueType vt, String file, Future<MatrixBlock> fmb) {
        super(vt, file, null);
        this._futureData = fmb;
    }

    public MatrixObjectFuture(MatrixObject mo, Future<MatrixBlock> fmb) {
        super(mo.getValueType(), mo.getFileName(), mo.getMetaData());
        this._futureData = fmb;
    }

    MatrixBlock getMatrixBlock() {
        try {
            return this._futureData.get();
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    @Override
    public MatrixBlock acquireRead() {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock ret = this.acquireReadIntern();
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
            SparkStatistics.incAsyncSparkOpCount(1L);
        }
        return ret;
    }

    private synchronized MatrixBlock acquireReadIntern() {
        try {
            if (!this.isAvailableToRead()) {
                throw new DMLRuntimeException("MatrixObject not available to read.");
            }
            if (this._futureData == null) {
                return (MatrixBlock)super.acquireRead();
            }
            if (OptimizerUtils.isUMMEnabled()) {
                UnifiedMemoryManager.pin(this);
            }
            MatrixBlock out = null;
            long t1 = System.nanoTime();
            out = this._futureData.get();
            if (this.hasValidLineage()) {
                LineageCache.putValueAsyncOp(this.getCacheLineage(), this, out, t1);
            }
            return this.acquireModify(out);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    @Override
    public synchronized void clearData(long tid) {
        this._data = null;
        this._futureData = null;
        this.clearCache();
        this.setCacheLineage(null);
        this.setDirty(false);
        this.setEmpty();
    }
}

