/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public final class CLALibCBind {
    private static final Log LOG = LogFactory.getLog((String)CLALibCBind.class.getName());

    private CLALibCBind() {
    }

    public static MatrixBlock cbind(MatrixBlock left, MatrixBlock[] right, int k) {
        try {
            if (right.length == 1) {
                return CLALibCBind.cbind(left, right[0], k);
            }
            boolean allCompressed = true;
            for (int i = 0; i < right.length && allCompressed; ++i) {
                allCompressed = right[i] instanceof CompressedMatrixBlock;
            }
            if (allCompressed) {
                return CLALibCBind.cbindAllCompressed((CompressedMatrixBlock)left, right, k);
            }
            return CLALibCBind.cbindAllNormalCompressed(left, right, k);
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed to Cbind with compressed input", e);
        }
    }

    private static MatrixBlock cbindAllNormalCompressed(MatrixBlock left, MatrixBlock[] right, int k) {
        for (int i = 0; i < right.length; ++i) {
            left = CLALibCBind.cbind(left, right[i], k);
        }
        return left;
    }

    public static MatrixBlock cbind(MatrixBlock left, MatrixBlock right, int k) {
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        if (left.isEmpty() && right instanceof CompressedMatrixBlock) {
            return CLALibCBind.appendLeftEmpty(left, (CompressedMatrixBlock)right, m, n);
        }
        if (right.isEmpty() && left instanceof CompressedMatrixBlock) {
            return CLALibCBind.appendRightEmpty((CompressedMatrixBlock)left, right, m, n);
        }
        if (!(left instanceof CompressedMatrixBlock) && left.getInMemorySize() < 1000L) {
            LOG.info((Object)"Trying to compress left side of append");
            left = (MatrixBlock)CompressedMatrixBlockFactory.compress(left, k).getLeft();
        }
        if (!(right instanceof CompressedMatrixBlock) && left.getInMemorySize() < 1000L) {
            LOG.info((Object)"Trying to compress right side of append");
            right = (MatrixBlock)CompressedMatrixBlockFactory.compress(right, k).getLeft();
        }
        if (!(left instanceof CompressedMatrixBlock) || !(right instanceof CompressedMatrixBlock)) {
            double estSizeCompressed;
            double spar = (double)(left.getNonZeros() + right.getNonZeros()) / ((double)m * (double)n);
            double estSizeUncompressed = MatrixBlock.estimateSizeInMemory((long)m, (long)n, spar);
            if (estSizeUncompressed < (estSizeCompressed = (double)(left.getInMemorySize() + right.getInMemorySize()))) {
                return CLALibCBind.uc(left).append(CLALibCBind.uc(right), null);
            }
            if (left instanceof CompressedMatrixBlock) {
                return CLALibCBind.appendRightUncompressed((CompressedMatrixBlock)left, right, m, n);
            }
            return CLALibCBind.appendLeftUncompressed(left, (CompressedMatrixBlock)right, m, n);
        }
        if (CLALibCBind.isAligned((CompressedMatrixBlock)left, (CompressedMatrixBlock)right)) {
            return CLALibCBind.combineCompressed((CompressedMatrixBlock)left, (CompressedMatrixBlock)right);
        }
        return CLALibCBind.append((CompressedMatrixBlock)left, (CompressedMatrixBlock)right, m, n);
    }

    private static MatrixBlock cbindAllCompressed(CompressedMatrixBlock left, MatrixBlock[] right, int k) throws InterruptedException, ExecutionException {
        int nCol = left.getNumColumns();
        for (int i = 0; i < right.length; ++i) {
            CompressedMatrixBlock rightCM = (CompressedMatrixBlock)right[i];
            if (nCol == right[i].getNumColumns() && CLALibCBind.isAligned(left, rightCM)) continue;
            return CLALibCBind.cbindAllNormalCompressed(left, right, k);
        }
        return CLALibCBind.cbindAllCompressedAligned(left, right, k);
    }

    private static boolean isAligned(CompressedMatrixBlock left, CompressedMatrixBlock right) {
        List<AColGroup> gl = left.getColGroups();
        for (int j = 0; j < gl.size(); ++j) {
            int aColumnInGroup;
            AColGroup grj;
            AColGroup glj = gl.get(j);
            if (glj.sameIndexStructure(grj = right.getColGroupForColumn(aColumnInGroup = glj.getColIndices().get(0))) && glj.getNumCols() == grj.getNumCols()) continue;
            return false;
        }
        return true;
    }

    private static CompressedMatrixBlock combineCompressed(CompressedMatrixBlock left, CompressedMatrixBlock right) {
        List<AColGroup> gl = left.getColGroups();
        ArrayList<AColGroup> retCG = new ArrayList<AColGroup>(gl.size());
        for (int j = 0; j < gl.size(); ++j) {
            AColGroup glj = gl.get(j);
            int aColumnInGroup = glj.getColIndices().get(0);
            AColGroup grj = right.getColGroupForColumn(aColumnInGroup);
            retCG.add(glj.combineWithSameIndex(left.getNumRows(), left.getNumColumns(), grj));
        }
        return new CompressedMatrixBlock(left.getNumRows(), left.getNumColumns() + right.getNumColumns(), left.getNonZeros() + right.getNonZeros(), false, retCG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompressedMatrixBlock cbindAllCompressedAligned(CompressedMatrixBlock left, MatrixBlock[] right, int k) throws InterruptedException, ExecutionException {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            List<AColGroup> gl = left.getColGroups();
            ArrayList<Future<AColGroup>> tasks = new ArrayList<Future<AColGroup>>();
            int nCol = left.getNumColumns();
            int nRow = left.getNumRows();
            for (int i = 0; i < gl.size(); ++i) {
                AColGroup gli = gl.get(i);
                tasks.add(pool.submit(() -> {
                    ArrayList<AColGroup> combines = new ArrayList<AColGroup>();
                    int cId = gli.getColIndices().get(0);
                    for (int j = 0; j < right.length; ++j) {
                        combines.add(((CompressedMatrixBlock)right[j]).getColGroupForColumn(cId));
                    }
                    return gli.combineWithSameIndex(nRow, nCol, combines);
                }));
            }
            ArrayList<AColGroup> retCG = new ArrayList<AColGroup>(gl.size());
            for (Future compressedMatrixBlock : tasks) {
                retCG.add((AColGroup)compressedMatrixBlock.get());
            }
            int totalCol = nCol + right.length * nCol;
            CompressedMatrixBlock compressedMatrixBlock = new CompressedMatrixBlock(left.getNumRows(), totalCol, -1L, false, retCG);
            return compressedMatrixBlock;
        }
        finally {
            pool.shutdown();
        }
    }

    private static MatrixBlock appendLeftUncompressed(MatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        List<AColGroup> prev = right.getColGroups();
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(prev.size() + 1);
        int nColL = left.getNumColumns();
        IColIndex colIdx = ColIndexFactory.create(nColL);
        AColGroup g = ColGroupUncompressed.create(colIdx, left, false);
        newGroup.add(g);
        for (AColGroup group : prev) {
            newGroup.add(group.shiftColIndices(nColL));
        }
        ret.allocateColGroupList(newGroup);
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        return ret;
    }

    private static MatrixBlock appendRightUncompressed(CompressedMatrixBlock left, MatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        List<AColGroup> prev = left.getColGroups();
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(prev.size() + 1);
        newGroup.addAll(prev);
        int cLenL = left.getNumColumns();
        int cLenR = right.getNumColumns();
        IColIndex colIdx = ColIndexFactory.create(cLenL, cLenR + cLenL);
        AColGroup g = ColGroupUncompressed.create(colIdx, right, false);
        newGroup.add(g);
        ret.allocateColGroupList(newGroup);
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        return ret;
    }

    private static MatrixBlock append(CompressedMatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        CLALibCBind.appendColGroups(ret, left.getColGroups(), right.getColGroups(), left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(left.isOverlapping() || right.isOverlapping());
        return ret;
    }

    private static MatrixBlock appendRightEmpty(CompressedMatrixBlock left, MatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.create(right.getNumColumns()));
        CLALibCBind.appendColGroups(ret, left.getColGroups(), newGroup, left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(left.isOverlapping());
        return ret;
    }

    private static MatrixBlock appendLeftEmpty(MatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.create(left.getNumColumns()));
        CLALibCBind.appendColGroups(ret, newGroup, right.getColGroups(), left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(right.isOverlapping());
        return ret;
    }

    private static void appendColGroups(CompressedMatrixBlock ret, List<AColGroup> left, List<AColGroup> right, int leftNumCols) {
        ret.allocateColGroupList(new ArrayList<AColGroup>(left.size() + right.size()));
        for (AColGroup group : left) {
            ret.getColGroups().add(group);
        }
        for (AColGroup group : right) {
            ret.getColGroups().add(group.shiftColIndices(leftNumCols));
        }
        CLALibUtils.combineConstColumns(ret);
    }

    private static MatrixBlock uc(MatrixBlock mb) {
        return CompressedMatrixBlock.getUncompressed(mb, "append");
    }
}

