/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.jboss.netty.handler.codec.compression.CompressionException;

public class ColGroupDDC
extends APreAgg
implements IMapToDataGroup {
    private static final long serialVersionUID = -5769772089913918987L;
    protected final AMapToData _data;

    private ColGroupDDC(IColIndex colIndexes, IDictionary dict, AMapToData data, int[] cachedCounts) {
        super(colIndexes, dict, cachedCounts);
        this._data = data;
        if (CompressedMatrixBlock.debug) {
            if (this.getNumValues() == 0) {
                throw new DMLCompressionException("Invalid construction with empty dictionary");
            }
            if (data.size() == 0) {
                throw new DMLCompressionException("Invalid length of the data. is zero");
            }
            if (data.getUnique() != dict.getNumberOfValues(colIndexes.size())) {
                throw new DMLCompressionException("Invalid map to dict Map has:" + data.getUnique() + " while dict has " + dict.getNumberOfValues(colIndexes.size()));
            }
            int[] c = this.getCounts();
            if (c.length != dict.getNumberOfValues(colIndexes.size())) {
                throw new DMLCompressionException("Invalid DDC Construction");
            }
            data.verify();
        }
    }

    public static AColGroup create(IColIndex colIndexes, IDictionary dict, AMapToData data, int[] cachedCounts) {
        if (data.getUnique() == 1) {
            return ColGroupConst.create(colIndexes, dict);
        }
        if (dict == null) {
            return new ColGroupEmpty(colIndexes);
        }
        return new ColGroupDDC(colIndexes, dict, data, cachedCounts);
    }

    public AColGroup sparsifyFOR() {
        return ColGroupDDCFOR.sparsifyFOR(this);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.DDC;
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int r = rl;
        int offT = rl + offR;
        while (r < ru) {
            int vr = this._data.getIndex(r);
            if (!sb.isEmpty(vr)) {
                double[] c = db.values(offT);
                int off = db.pos(offT) + offC;
                this._colIndexes.decompressToDenseFromSparse(sb, vr, off, c);
            }
            ++r;
            ++offT;
        }
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        int idxSize = this._colIndexes.size();
        if (db.isContiguous()) {
            int nColOut = db.getDim(1);
            if (idxSize == 1 && nColOut == 1) {
                this.decompressToDenseBlockDenseDictSingleColOutContiguous(db, rl, ru, offR, offC, values);
            } else if (idxSize == 1) {
                this.decompressToDenseBlockDenseDictSingleColContiguous(db, rl, ru, offR, offC, values);
            } else if (idxSize == nColOut) {
                this.decompressToDenseBlockDenseDictAllColumnsContiguous(db, rl, ru, offR, values, idxSize);
            } else if (offC == 0 && offR == 0) {
                this.decompressToDenseBlockDenseDictNoOff(db, rl, ru, values);
            } else if (offC == 0) {
                this.decompressToDenseBlockDenseDictNoColOffset(db, rl, ru, offR, values, idxSize, nColOut);
            } else {
                this.decompressToDenseBlockDenseDictGeneric(db, rl, ru, offR, offC, values, idxSize);
            }
        } else {
            this.decompressToDenseBlockDenseDictGeneric(db, rl, ru, offR, offC, values, idxSize);
        }
    }

    private final void decompressToDenseBlockDenseDictSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        double[] c = db.values(0);
        int nCols = db.getDim(1);
        int colOff = this._colIndexes.get(0) + offC;
        int i = rl;
        int offT = (rl + offR) * nCols + colOff;
        while (i < ru) {
            int n = offT;
            c[n] = c[n] + values[this._data.getIndex(i)];
            ++i;
            offT += nCols;
        }
    }

    @Override
    public AMapToData getMapToData() {
        return this._data;
    }

    private final void decompressToDenseBlockDenseDictSingleColOutContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        double[] c = db.values(0);
        ColGroupDDC.decompressToDenseBlockDenseDictSingleColOutContiguous(c, rl, ru, offR + this._colIndexes.get(0), values, this._data);
    }

    private static final void decompressToDenseBlockDenseDictSingleColOutContiguous(double[] c, int rl, int ru, int offR, double[] values, AMapToData data) {
        data.decompressToRange(c, rl, ru, offR, values);
    }

    private final void decompressToDenseBlockDenseDictAllColumnsContiguous(DenseBlock db, int rl, int ru, int offR, double[] values, int nCol) {
        double[] c = db.values(0);
        for (int r = rl; r < ru; ++r) {
            int start = this._data.getIndex(r) * nCol;
            int offStart = (offR + r) * nCol;
            LibMatrixMult.vectAdd(values, c, start, offStart, nCol);
        }
    }

    private final void decompressToDenseBlockDenseDictNoColOffset(DenseBlock db, int rl, int ru, int offR, double[] values, int nCol, int colOut) {
        int off = (rl + offR) * colOut;
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            double[] c = db.values(offT);
            int rowIndex = this._data.getIndex(i) * nCol;
            this._colIndexes.decompressVec(nCol, c, off, values, rowIndex);
            ++i;
            off += colOut;
        }
    }

    private final void decompressToDenseBlockDenseDictNoOff(DenseBlock db, int rl, int ru, double[] values) {
        int nCol = this._colIndexes.size();
        int nColU = db.getDim(1);
        double[] c = db.values(0);
        for (int i = rl; i < ru; ++i) {
            int off = i * nColU;
            int rowIndex = this._data.getIndex(i) * nCol;
            this._colIndexes.decompressVec(nCol, c, off, values, rowIndex);
        }
    }

    private final void decompressToDenseBlockDenseDictGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, int nCol) {
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            double[] c = db.values(offT);
            int off = db.pos(offT) + offC;
            int rowIndex = this._data.getIndex(i) * nCol;
            this._colIndexes.decompressVec(nCol, c, off, values, rowIndex);
            ++i;
            ++offT;
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int r = rl;
        int offT = rl + offR;
        while (r < ru) {
            int vr = this._data.getIndex(r);
            if (!sb.isEmpty(vr)) {
                int apos = sb.pos(vr);
                int alen = sb.size(vr) + apos;
                int[] aix = sb.indexes(vr);
                double[] aval = sb.values(vr);
                for (int j = apos; j < alen; ++j) {
                    ret.append(offT, offC + this._colIndexes.get(aix[j]), aval[j]);
                }
            }
            ++r;
            ++offT;
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        this.decompressToSparseBlockDenseDictionary(ret, rl, ru, offR, offC, values, this._colIndexes.size());
    }

    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values, int nCol) {
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                ret.append(offT, this._colIndexes.get(j) + offC, values[rowIndex + j]);
            }
            ++i;
            ++offT;
        }
    }

    @Override
    protected void decompressToDenseBlockTransposedSparseDictionary(DenseBlock db, int rl, int ru, SparseBlock sb) {
        for (int i = rl; i < ru; ++i) {
            int vr = this._data.getIndex(i);
            if (sb.isEmpty(vr)) continue;
            int apos = sb.pos(vr);
            int alen = sb.size(vr) + apos;
            int[] aix = sb.indexes(vr);
            double[] aval = sb.values(vr);
            for (int j = apos; j < alen; ++j) {
                int rowOut = this._colIndexes.get(aix[j]);
                double[] c = db.values(rowOut);
                int off = db.pos(rowOut);
                int n = off + i;
                c[n] = c[n] + aval[j];
            }
        }
    }

    @Override
    protected void decompressToDenseBlockTransposedDenseDictionary(DenseBlock db, int rl, int ru, double[] dict) {
        int nCol = this._colIndexes.size();
        for (int j = 0; j < nCol; ++j) {
            int rowOut = this._colIndexes.get(j);
            double[] c = db.values(rowOut);
            int off = db.pos(rowOut);
            for (int i = rl; i < ru; ++i) {
                double v = dict[this._data.getIndex(i) * nCol + j];
                int n = off + i;
                c[n] = c[n] + v;
            }
        }
    }

    @Override
    protected void decompressToSparseBlockTransposedSparseDictionary(SparseBlockMCSR sbr, SparseBlock sb, int nColOut) {
        int[] colCounts = this._dict.countNNZZeroColumns(this.getCounts());
        for (int j = 0; j < this._colIndexes.size(); ++j) {
            sbr.allocate(this._colIndexes.get(j), colCounts[j]);
        }
        for (int i = 0; i < this._data.size(); ++i) {
            int di = this._data.getIndex(i);
            if (sb.isEmpty(di)) continue;
            int apos = sb.pos(di);
            int alen = sb.size(di) + apos;
            int[] aix = sb.indexes(di);
            double[] aval = sb.values(di);
            for (int j = apos; j < alen; ++j) {
                sbr.append(this._colIndexes.get(aix[j]), i, aval[apos]);
            }
        }
    }

    @Override
    protected void decompressToSparseBlockTransposedDenseDictionary(SparseBlockMCSR sbr, double[] dict, int nColOut) {
        int[] colCounts = this._dict.countNNZZeroColumns(this.getCounts());
        for (int j = 0; j < this._colIndexes.size(); ++j) {
            sbr.allocate(this._colIndexes.get(j), colCounts[j]);
        }
        int nCol = this._colIndexes.size();
        for (int j = 0; j < nCol; ++j) {
            int rowOut = this._colIndexes.get(j);
            SparseRow r = sbr.get(rowOut);
            for (int i = 0; i < this._data.size(); ++i) {
                double v = dict[this._data.getIndex(i) * nCol + j];
                r = r.append(i, v);
            }
            sbr.set(rowOut, r, false);
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        return this._dict.getValue(this._data.getIndex(r), colIdx, this._colIndexes.size());
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        for (int rix = rl; rix < ru; ++rix) {
            int n = rix;
            c[n] = c[n] + preAgg[this._data.getIndex(rix)];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        for (int i = rl; i < ru; ++i) {
            c[i] = builtin.execute(c[i], preAgg[this._data.getIndex(i)]);
        }
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        for (int rix = rl; rix < ru; ++rix) {
            int n = rix;
            c[n] = c[n] * preAgg[this._data.getIndex(rix)];
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (this._colIndexes.size() == 1) {
            this.leftMultByMatrixNoPreAggSingleCol(matrix, result, rl, ru, cl, cu);
        } else {
            this.lmMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        }
    }

    private void leftMultByMatrixNoPreAggSingleCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        DenseBlock retV = result.getDenseBlock();
        int nColM = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] dictVals = this._dict.getValues();
        if (matrix.isEmpty()) {
            return;
        }
        if (matrix.isInSparseFormat()) {
            if (cl != 0 || cu != this._data.size()) {
                this.lmSparseMatrixNoPreAggSingleCol(matrix.getSparseBlock(), nColM, retV, nColRet, dictVals, rl, ru, cl, cu);
            } else {
                this.lmSparseMatrixNoPreAggSingleCol(matrix.getSparseBlock(), nColM, retV, nColRet, dictVals, rl, ru);
            }
        } else if (!matrix.getDenseBlock().isContiguous()) {
            this.lmDenseMatrixNoPreAggSingleColNonContiguous(matrix.getDenseBlock(), nColM, retV, nColRet, dictVals, rl, ru, cl, cu);
        } else {
            this.lmDenseMatrixNoPreAggSingleCol(matrix.getDenseBlockValues(), nColM, retV, nColRet, dictVals, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggSingleCol(SparseBlock sb, int nColM, DenseBlock retV, int nColRet, double[] vals, int rl, int ru) {
        if (retV.isContiguous()) {
            this.lmSparseMatrixNoPreAggSingleColContiguous(sb, nColM, retV.valuesAt(0), nColRet, vals, rl, ru);
        } else {
            this.lmSparseMatrixNoPreAggSingleColGeneric(sb, nColM, retV, nColRet, vals, rl, ru);
        }
    }

    private void lmSparseMatrixNoPreAggSingleColGeneric(SparseBlock sb, int nColM, DenseBlock ret, int nColRet, double[] vals, int rl, int ru) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            double[] aval = sb.values(r);
            int offR = ret.pos(r);
            double[] retV = ret.values(r);
            for (int i = apos; i < alen; ++i) {
                int n = offR + colOut;
                retV[n] = retV[n] + aval[i] * vals[this._data.getIndex(aix[i])];
            }
        }
    }

    private void lmSparseMatrixNoPreAggSingleColContiguous(SparseBlock sb, int nColM, double[] retV, int nColRet, double[] vals, int rl, int ru) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            double[] aval = sb.values(r);
            int offR = r * nColRet;
            for (int i = apos; i < alen; ++i) {
                int n = offR + colOut;
                retV[n] = retV[n] + aval[i] * vals[this._data.getIndex(aix[i])];
            }
        }
    }

    private void lmSparseMatrixNoPreAggSingleCol(SparseBlock sb, int nColM, DenseBlock retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        if (retV.isContiguous()) {
            this.lmSparseMatrixNoPreAggSingleColContiguous(sb, nColM, retV.valuesAt(0), nColRet, vals, rl, ru, cl, cu);
        } else {
            this.lmSparseMatrixNoPreAggSingleColGeneric(sb, nColM, retV, nColRet, vals, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggSingleColGeneric(SparseBlock sb, int nColM, DenseBlock ret, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int aposSkip = sb.posFIndexGTE(r, cl);
            int[] aix = sb.indexes(r);
            if (aposSkip <= -1 || aix[apos + aposSkip] >= cu) continue;
            int alen = sb.size(r) + apos;
            double[] aval = sb.values(r);
            int offR = ret.pos(r);
            double[] retV = ret.values(r);
            for (int i = apos + aposSkip; i < alen && aix[i] < cu; ++i) {
                int n = offR + colOut;
                retV[n] = retV[n] + aval[i] * vals[this._data.getIndex(aix[i])];
            }
        }
    }

    private void lmSparseMatrixNoPreAggSingleColContiguous(SparseBlock sb, int nColM, double[] retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int aposSkip = sb.posFIndexGTE(r, cl);
            int[] aix = sb.indexes(r);
            if (aposSkip <= -1 || aix[apos + aposSkip] >= cu) continue;
            int alen = sb.size(r) + apos;
            double[] aval = sb.values(r);
            int offR = r * nColRet;
            for (int i = apos + aposSkip; i < alen && aix[i] < cu; ++i) {
                int n = offR + colOut;
                retV[n] = retV[n] + aval[i] * vals[this._data.getIndex(aix[i])];
            }
        }
    }

    private void lmDenseMatrixNoPreAggSingleColNonContiguous(DenseBlock db, int nColM, DenseBlock retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        this.lmDenseMatrixNoPreAggSingleColNonContiguousInGeneric(db, nColM, retV, nColRet, vals, rl, ru, cl, cu);
    }

    private void lmDenseMatrixNoPreAggSingleCol(double[] mV, int nColM, DenseBlock retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        if (retV.isContiguous()) {
            this.lmDenseMatrixNoPreAggSingleColContiguous(mV, nColM, retV.valuesAt(0), nColRet, vals, rl, ru, cl, cu);
        } else {
            this.lmDenseMatrixNoPreAggSingleColGeneric(mV, nColM, retV, nColRet, vals, rl, ru, cl, cu);
        }
    }

    private void lmDenseMatrixNoPreAggSingleColNonContiguousInGeneric(DenseBlock db, int nColM, DenseBlock ret, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            int offL = db.pos(r);
            double[] mV = db.values(r);
            int offR = ret.pos(r);
            double[] retV = ret.values(r);
            for (int c = cl; c < cu; ++c) {
                int n = offR + colOut;
                retV[n] = retV[n] + mV[offL + c] * vals[this._data.getIndex(c)];
            }
        }
    }

    private void lmDenseMatrixNoPreAggSingleColGeneric(double[] mV, int nColM, DenseBlock ret, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = ret.pos(r);
            double[] retV = ret.values(r);
            for (int c = cl; c < cu; ++c) {
                int n = offR + colOut;
                retV[n] = retV[n] + mV[offL + c] * vals[this._data.getIndex(c)];
            }
        }
    }

    private void lmDenseMatrixNoPreAggSingleColContiguous(double[] mV, int nColM, double[] retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = r * nColRet;
            for (int c = cl; c < cu; ++c) {
                int n = offR + colOut;
                retV[n] = retV[n] + mV[offL + c] * vals[this._data.getIndex(c)];
            }
        }
    }

    private void lmMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (matrix.isInSparseFormat()) {
            this.lmSparseMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        } else {
            this.lmDenseMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        DenseBlock db = result.getDenseBlock();
        SparseBlock sb = matrix.getSparseBlock();
        if (cl != 0 || cu != this._data.size()) {
            for (int r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                double[] retV = db.values(r);
                int pos = db.pos(r);
                this.lmSparseMatrixRowColRange(sb, r, pos, retV, cl, cu);
            }
        } else {
            for (int r = rl; r < ru; ++r) {
                this._data.lmSparseMatrixRow(sb, r, db, this._colIndexes, this._dict);
            }
        }
    }

    private final void lmSparseMatrixRowColRange(SparseBlock sb, int r, int offR, double[] retV, int cl, int cu) {
        int apos = sb.pos(r);
        int aposSkip = sb.posFIndexGTE(r, cl);
        int[] aix = sb.indexes(r);
        if (aposSkip <= -1 || aix[apos + aposSkip] >= cu) {
            return;
        }
        int alen = sb.size(r) + apos;
        double[] aval = sb.values(r);
        for (int i = apos + aposSkip; i < alen && aix[i] < cu; ++i) {
            this._dict.multiplyScalar(aval[i], retV, offR, this._data.getIndex(aix[i]), this._colIndexes);
        }
    }

    private void lmDenseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (matrix.getDenseBlock().isContiguous()) {
            this.lmDenseMatrixNoPreAggMultiColContiguous(matrix, result, rl, ru, cl, cu);
        } else {
            this.lmDenseMatrixNoPreAggMultiColNonContiguous(matrix.getDenseBlock(), result, rl, ru, cl, cu);
        }
    }

    private void lmDenseMatrixNoPreAggMultiColContiguous(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        double[] retV = result.getDenseBlockValues();
        int nColM = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] mV = matrix.getDenseBlockValues();
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = r * nColRet;
            for (int c = cl; c < cu; ++c) {
                this._dict.multiplyScalar(mV[offL + c], retV, offR, this._data.getIndex(c), this._colIndexes);
            }
        }
    }

    private void lmDenseMatrixNoPreAggMultiColNonContiguous(DenseBlock db, MatrixBlock result, int rl, int ru, int cl, int cu) {
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        for (int r = rl; r < ru; ++r) {
            int offL = db.pos(r);
            double[] mV = db.values(r);
            int offR = r * nColRet;
            for (int c = cl; c < cu; ++c) {
                this._dict.multiplyScalar(mV[offL + c], retV, offR, this._data.getIndex(c), this._colIndexes);
            }
        }
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        this._data.preAggregateDense(m, preAgg, rl, ru, cl, cu);
    }

    @Override
    public void leftMMIdentityPreAggregateDense(MatrixBlock that, MatrixBlock ret, int rl, int ru, int cl, int cu) {
        DenseBlock db = that.getDenseBlock();
        DenseBlock retDB = ret.getDenseBlock();
        for (int i = rl; i < ru; ++i) {
            this.leftMMIdentityPreAggregateDenseSingleRow(db.values(i), db.pos(i), retDB.values(i), retDB.pos(i), cl, cu);
        }
    }

    @Override
    public void rightDecompressingMult(MatrixBlock right, MatrixBlock ret, int rl, int ru, int nRows, int crl, int cru) {
        if (this._dict instanceof IdentityDictionary) {
            this.identityRightDecompressingMult(right, ret, rl, ru, crl, cru);
        } else {
            this.defaultRightDecompressingMult(right, ret, rl, ru, crl, cru);
        }
    }

    private void identityRightDecompressingMult(MatrixBlock right, MatrixBlock ret, int rl, int ru, int crl, int cru) {
        double[] b = right.getDenseBlockValues();
        double[] c = ret.getDenseBlockValues();
        int jd = right.getNumColumns();
        int vLen = 8;
        int lenJ = cru - crl;
        int end = cru - lenJ % 8;
        for (int i = rl; i < ru; ++i) {
            int k = this._data.getIndex(i);
            int offOut = i * jd + crl;
            double aa = 1.0;
            int k_right = this._colIndexes.get(k);
            this.vectMM(1.0, b, c, end, jd, crl, cru, offOut, k_right, 8);
        }
    }

    private void defaultRightDecompressingMult(MatrixBlock right, MatrixBlock ret, int rl, int ru, int crl, int cru) {
        double[] a = this._dict.getValues();
        double[] b = right.getDenseBlockValues();
        double[] c = ret.getDenseBlockValues();
        int kd = this._colIndexes.size();
        int jd = right.getNumColumns();
        int vLen = 8;
        int blkzI = 32;
        int blkzK = 24;
        int lenJ = cru - crl;
        int end = cru - lenJ % 8;
        for (int bi = rl; bi < ru; bi += 32) {
            int bie = Math.min(ru, bi + 32);
            for (int bk = 0; bk < kd; bk += 24) {
                int bke = Math.min(kd, bk + 24);
                for (int i = bi; i < bie; ++i) {
                    int offi = this._data.getIndex(i) * kd;
                    int offOut = i * jd + crl;
                    for (int k = bk; k < bke; ++k) {
                        double aa = a[offi + k];
                        int k_right = this._colIndexes.get(k);
                        this.vectMM(aa, b, c, end, jd, crl, cru, offOut, k_right, 8);
                    }
                }
            }
        }
    }

    final void vectMM(double aa, double[] b, double[] c, int endT, int jd, int crl, int cru, int offOut, int k, int vLen) {
        int offj = k * jd;
        int end = endT + offj;
        int j = offj + crl;
        while (j < end) {
            int n = offOut;
            c[n] = c[n] + aa * b[j];
            int n2 = offOut + 1;
            c[n2] = c[n2] + aa * b[j + 1];
            int n3 = offOut + 2;
            c[n3] = c[n3] + aa * b[j + 2];
            int n4 = offOut + 3;
            c[n4] = c[n4] + aa * b[j + 3];
            int n5 = offOut + 4;
            c[n5] = c[n5] + aa * b[j + 4];
            int n6 = offOut + 5;
            c[n6] = c[n6] + aa * b[j + 5];
            int n7 = offOut + 6;
            c[n7] = c[n7] + aa * b[j + 6];
            int n8 = offOut + 7;
            c[n8] = c[n8] + aa * b[j + 7];
            j += vLen;
            offOut += vLen;
        }
        for (j = end; j < cru + offj; ++j) {
            double bb = b[j];
            int n = offOut++;
            c[n] = c[n] + bb * aa;
        }
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru, int cl, int cu) {
        if (cl != 0 || cu != this._data.size()) {
            throw new NotImplementedException();
        }
        this._data.preAggregateSparse(sb, preAgg, rl, ru);
    }

    @Override
    public void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        try {
            this._data.preAggregateDDC_DDC(that._data, that._dict, ret, that._colIndexes.size());
        }
        catch (Exception e) {
            throw new CompressionException(that.toString(), (Throwable)e);
        }
    }

    @Override
    public void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        this._data.preAggregateDDC_SDCZ(that._data, that._dict, that._indexes, ret, that._colIndexes.size());
    }

    @Override
    public void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AOffsetIterator itThat = that._indexes.getOffsetIterator();
        int nCol = that._colIndexes.size();
        int finalOff = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        while (true) {
            int to = this._data.getIndex(itThat.value());
            that._dict.addToEntry(v, 0, to, nCol);
            if (itThat.value() == finalOff) break;
            itThat.next();
        }
    }

    @Override
    protected void preAggregateThatRLEStructure(ColGroupRLE that, Dictionary ret) {
        this._data.preAggregateDDC_RLE(that._ptr, that._data, that._dict, ret, that._colIndexes.size());
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        return that instanceof ColGroupDDC && ((ColGroupDDC)that)._data == this._data;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.DDC;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        if (op.fn instanceof Plus || op.fn instanceof Minus) {
            double v0 = op.executeScalar(0.0);
            if (v0 == 0.0) {
                return this;
            }
            double[] reference = ColGroupUtils.createReference(this._colIndexes.size(), v0);
            return ColGroupDDCFOR.create(this._colIndexes, this._dict, this._data, this.getCachedCounts(), reference);
        }
        return ColGroupDDC.create(this._colIndexes, this._dict.applyScalarOp(op), this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        return ColGroupDDC.create(this._colIndexes, this._dict.applyUnaryOp(op), this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        IDictionary ret = this._dict.binOpLeft(op, v, this._colIndexes);
        return ColGroupDDC.create(this._colIndexes, ret, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if ((op.fn instanceof Plus || op.fn instanceof Minus) && this._dict instanceof MatrixBlockDictionary && ((MatrixBlockDictionary)this._dict).getMatrixBlock().isInSparseFormat()) {
            double[] reference = ColGroupUtils.binaryDefRowRight(op, v, this._colIndexes);
            return ColGroupDDCFOR.create(this._colIndexes, this._dict, this._data, this.getCachedCounts(), reference);
        }
        IDictionary ret = this._colIndexes.size() == 1 ? this._dict.applyScalarOp(new RightScalarOperator(op.fn, v[this._colIndexes.get(0)])) : this._dict.binOpRight(op, v, this._colIndexes);
        return ColGroupDDC.create(this._colIndexes, ret, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._data.write(out);
    }

    public static ColGroupDDC read(DataInput in) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        AMapToData data = MapToFactory.readIn(in);
        return new ColGroupDDC(cols, dict, data, null);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._data.getExactSizeOnDisk();
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        return e.getCost(nRows, nRows, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected int numRowsToMultiply() {
        return this._data.size();
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        return this._dict.aggregate(c, builtin);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateCols(c, builtin, this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._dict.containsValue(pattern);
    }

    @Override
    protected AColGroup allocateRightMultiplication(MatrixBlock right, IColIndex colIndexes, IDictionary preAgg) {
        if (preAgg != null) {
            return ColGroupDDC.create(colIndexes, preAgg, this._data, this.getCachedCounts());
        }
        return null;
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        try {
            return ColGroupDDC.create(this._colIndexes, this._dict, this._data.slice(rl, ru), null);
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed to slice out sub part DDC: " + rl + " " + ru, e);
        }
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupDDC.create(colIndexes, newDictionary, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        if (g instanceof ColGroupDDC) {
            if (g.getColIndices().equals(this._colIndexes)) {
                ColGroupDDC gDDC = (ColGroupDDC)g;
                if (gDDC._dict.equals(this._dict)) {
                    AMapToData nd = this._data.append(gDDC._data);
                    return ColGroupDDC.create(this._colIndexes, this._dict, nd, null);
                }
                LOG.warn((Object)("Not same Dictionaries therefore not appending DDC\n" + this._dict + "\n\n" + gDDC._dict));
            } else {
                LOG.warn((Object)("Not same columns therefore not appending DDC\n" + this._colIndexes + "\n\n" + g.getColIndices()));
            }
        } else {
            LOG.warn((Object)("Not DDC but " + g.getClass().getSimpleName() + ", therefore not appending DDC"));
        }
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        for (int i = 1; i < g.length; ++i) {
            if (!this._colIndexes.equals(g[i]._colIndexes)) {
                LOG.warn((Object)("Not same columns therefore not appending DDC\n" + this._colIndexes + "\n\n" + g[i]._colIndexes));
                return null;
            }
            if (!(g[i] instanceof ColGroupDDC)) {
                LOG.warn((Object)("Not DDC but " + g[i].getClass().getSimpleName() + ", therefore not appending DDC"));
                return null;
            }
            ColGroupDDC gDDC = (ColGroupDDC)g[i];
            if (gDDC._dict.equals(this._dict)) continue;
            LOG.warn((Object)("Not same Dictionaries therefore not appending DDC\n" + this._dict + "\n\n" + gDDC._dict));
            return null;
        }
        AMapToData nd = this._data.appendN((IMapToDataGroup[])Arrays.copyOf(g, g.length, IMapToDataGroup[].class));
        return ColGroupDDC.create(this._colIndexes, this._dict, nd, null);
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return DDCScheme.create(this);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        try {
            IEncode enc = this.getEncoding();
            EstimationFactors ef = new EstimationFactors(this._data.getUnique(), this._data.size(), this._data.size(), this._dict.getSparsity());
            return new CompressedSizeInfoColGroup(this._colIndexes, ef, this.estimateInMemorySize(), this.getCompType(), enc);
        }
        catch (Exception e) {
            throw new DMLCompressionException(this.toString(), e);
        }
    }

    @Override
    public IEncode getEncoding() {
        return EncodingFactory.create(this._data);
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        return ColGroupDDC.create(newColIndex, this._dict.reorder(reordering), this._data, this.getCachedCounts());
    }

    @Override
    public void sparseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        SparseBlock sb = selection.getSparseBlock();
        SparseBlock retB = ret.getSparseBlock();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int sPos = sb.pos(r);
            int rowCompressed = sb.indexes(r)[sPos];
            this.decompressToSparseBlock(retB, rowCompressed, rowCompressed + 1, r - rowCompressed, 0);
        }
    }

    @Override
    protected void denseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        SparseBlock sb = selection.getSparseBlock();
        DenseBlock retB = ret.getDenseBlock();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int sPos = sb.pos(r);
            int rowCompressed = sb.indexes(r)[sPos];
            this.decompressToDenseBlock(retB, rowCompressed, rowCompressed + 1, r - rowCompressed, 0);
        }
    }

    private void leftMMIdentityPreAggregateDenseSingleRow(double[] values, int pos, double[] values2, int pos2, int cl, int cu) {
        IdentityDictionary a = (IdentityDictionary)this._dict;
        if (this._colIndexes instanceof RangeIndex) {
            this.leftMMIdentityPreAggregateDenseSingleRowRangeIndex(values, pos, values2, pos2, cl, cu);
        } else {
            pos += cl;
            if (a.withEmpty()) {
                int nVal = this._dict.getNumberOfValues(this._colIndexes.size()) - 1;
                int rc = cl;
                while (rc < cu) {
                    int idx = this._data.getIndex(rc);
                    if (idx != nVal) {
                        int n = pos2 + this._colIndexes.get(idx);
                        values2[n] = values2[n] + values[pos];
                    }
                    ++rc;
                    ++pos;
                }
            } else {
                int rc = cl;
                while (rc < cu) {
                    int n = pos2 + this._colIndexes.get(this._data.getIndex(rc));
                    values2[n] = values2[n] + values[pos];
                    ++rc;
                    ++pos;
                }
            }
        }
    }

    private void leftMMIdentityPreAggregateDenseSingleRowRangeIndex(double[] values, int pos, double[] values2, int pos2, int cl, int cu) {
        IdentityDictionary a = (IdentityDictionary)this._dict;
        int firstCol = pos2 + this._colIndexes.get(0);
        pos += cl;
        if (a.withEmpty()) {
            int nVal = this._dict.getNumberOfValues(this._colIndexes.size()) - 1;
            int rc = cl;
            while (rc < cu) {
                int idx = this._data.getIndex(rc);
                if (idx != nVal) {
                    int n = firstCol + idx;
                    values2[n] = values2[n] + values[pos];
                }
                ++rc;
                ++pos;
            }
        } else {
            int rc = cl;
            while (rc < cu) {
                int n = firstCol + this._data.getIndex(rc);
                values2[n] = values2[n] + values[pos];
                ++rc;
                ++pos;
            }
        }
    }

    @Override
    public AColGroup morph(AColGroup.CompressionType ct, int nRow) {
        if (ct == this.getCompType()) {
            return this;
        }
        if (ct == AColGroup.CompressionType.SDC) {
            int[] counts = this.getCounts();
            int maxId = ColGroupDDC.maxIndex(counts);
            double[] def = this._dict.getRow(maxId, this._colIndexes.size());
            int offsetSize = nRow - counts[maxId];
            int[] offsets = new int[offsetSize];
            AMapToData reducedData = MapToFactory.create(offsetSize, this._data.getUnique());
            int o = 0;
            for (int i = 0; i < nRow; ++i) {
                int v = this._data.getIndex(i);
                if (v == maxId) continue;
                offsets[o] = i;
                reducedData.set(o, v);
                ++o;
            }
            return ColGroupSDC.create(this._colIndexes, this._data.size(), this._dict, def, OffsetFactory.createOffset(offsets), reducedData, null);
        }
        if (ct == AColGroup.CompressionType.CONST) {
            Object thisS = this.toString();
            if (((String)thisS).length() > 10000) {
                thisS = ((String)thisS).substring(0, 10000) + "...";
            }
            LOG.warn((Object)("Tried to morph to const from DDC but impossible: " + (String)thisS));
            return this;
        }
        if (ct == AColGroup.CompressionType.DDCFOR) {
            return this;
        }
        return super.morph(ct, nRow);
    }

    private static int maxIndex(int[] counts) {
        int id = 0;
        for (int i = 1; i < counts.length; ++i) {
            if (counts[i] <= counts[id]) continue;
            id = i;
        }
        return id;
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, List<AColGroup> right) {
        IDictionary combined = this.combineDictionaries(nCol, right);
        IColIndex combinedColIndex = this.combineColIndexes(nCol, right);
        return new ColGroupDDC(combinedColIndex, combined, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, AColGroup right) {
        IDictionary b = ((ColGroupDDC)right).getDictionary();
        IDictionary combined = DictionaryFactory.cBindDictionaries(this._dict, b, this.getNumCols(), right.getNumCols());
        IColIndex combinedColIndex = this._colIndexes.combine(right.getColIndices().shift(nCol));
        return new ColGroupDDC(combinedColIndex, combined, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup[] splitReshape(int multiplier, int nRow, int nColOrg) {
        AMapToData[] maps = this._data.splitReshapeDDC(multiplier);
        AColGroup[] res = new AColGroup[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            IColIndex ci = i == 0 ? this._colIndexes : this._colIndexes.shift(i * nColOrg);
            res[i] = ColGroupDDC.create(ci, this._dict, maps[i], null);
        }
        return res;
    }

    @Override
    public AColGroup[] splitReshapePushDown(int multiplier, int nRow, int nColOrg, ExecutorService pool) throws Exception {
        AMapToData[] maps = this._data.splitReshapeDDCPushDown(multiplier, pool);
        AColGroup[] res = new AColGroup[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            IColIndex ci = i == 0 ? this._colIndexes : this._colIndexes.shift(i * nColOrg);
            res[i] = ColGroupDDC.create(ci, this._dict, maps[i], null);
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }

    @Override
    protected boolean allowShallowIdentityRightMult() {
        return true;
    }
}

