/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.lib.FrameLibApplySchema;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;

public class BinaryFrameFrameCPInstruction
extends BinaryCPInstruction {
    protected BinaryFrameFrameCPInstruction(MultiThreadedOperator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameBlock inBlock1 = ec.getFrameInput(this.input1.getName());
        FrameBlock inBlock2 = ec.getFrameInput(this.input2.getName());
        if (this.getOpcode().equals(Opcodes.DROPINVALIDTYPE.toString())) {
            FrameBlock retBlock = inBlock1.dropInvalidType(inBlock2);
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else if (this.getOpcode().equals(Opcodes.VALUESWAP.toString())) {
            FrameBlock retBlock = inBlock1.valueSwap(inBlock2);
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else if (this.getOpcode().equals(Opcodes.FREPLICATE.toString())) {
            FrameBlock retBlock = inBlock1.frameRowReplication(inBlock2);
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else if (this.getOpcode().equals(Opcodes.APPLYSCHEMA.toString())) {
            int k = ((MultiThreadedOperator)this._optr).getNumThreads();
            FrameBlock out = FrameLibApplySchema.applySchema(inBlock1, inBlock2, k);
            ec.setFrameOutput(this.output.getName(), out);
        } else {
            BinaryOperator dop = (BinaryOperator)this._optr;
            FrameBlock outBlock = inBlock1.binaryOperations(dop, inBlock2, null);
            ec.setFrameOutput(this.output.getName(), outBlock);
        }
        ec.releaseFrameInput(this.input1.getName());
        ec.releaseFrameInput(this.input2.getName());
    }
}

