/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.EmptyScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.UncompressedScheme;

public class SchemeFactory {
    public static ICLAScheme create(IColIndex columns, AColGroup.CompressionType type) {
        switch (type) {
            case DDC: {
                return DDCScheme.create(columns);
            }
            case DDCFOR: {
                break;
            }
            case DeltaDDC: {
                break;
            }
            case CONST: 
            case EMPTY: {
                return new EmptyScheme(columns);
            }
            case LinearFunctional: {
                break;
            }
            case OLE: {
                break;
            }
            case RLE: {
                break;
            }
            case SDC: {
                break;
            }
            case SDCFOR: {
                break;
            }
            case UNCOMPRESSED: {
                return new UncompressedScheme(columns);
            }
        }
        throw new NotImplementedException("Not Implemented scheme for plan of type: " + type);
    }
}

