/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CoCodePriorityQue
extends AColumnCoCoder {
    private static final int COL_COMBINE_THRESHOLD = 1024;
    private final int lastCombineThreshold;

    protected CoCodePriorityQue(AComEst sizeEstimator, ACostEstimate costEstimator, CompressionSettings cs, int lastCombineThreshold) {
        super(sizeEstimator, costEstimator, cs);
        this.lastCombineThreshold = lastCombineThreshold;
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        colInfos.setInfo(this.join(colInfos.getInfo(), 1, k));
        return colInfos;
    }

    protected List<CompressedSizeInfoColGroup> join(List<CompressedSizeInfoColGroup> groups, int minNumGroups, int k) {
        if (groups.size() > 1024 && k > 1) {
            return this.combineMultiThreaded(groups, this._sest, this._cest, minNumGroups, k);
        }
        return this.combineSingleThreaded(groups, this._sest, this._cest, minNumGroups);
    }

    private List<CompressedSizeInfoColGroup> combineMultiThreaded(List<CompressedSizeInfoColGroup> groups, AComEst sEst, ACostEstimate cEst, int minNumGroups, int k) {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList<PQTask> tasks = new ArrayList<PQTask>();
            int blkSize = Math.max(groups.size() / k, 500);
            for (int i = 0; i < groups.size(); i += blkSize) {
                tasks.add(new PQTask(groups, i, Math.min(i + blkSize, groups.size()), sEst, cEst, minNumGroups));
            }
            List ret = null;
            for (Future t : pool.invokeAll(tasks)) {
                List p = (List)t.get();
                if (ret == null) {
                    ret = p;
                    continue;
                }
                ret.addAll(p);
            }
            Iterator iterator = ret;
            return iterator;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed parallel priority que cocoding", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private List<CompressedSizeInfoColGroup> combineSingleThreaded(List<CompressedSizeInfoColGroup> groups, AComEst sEst, ACostEstimate cEst, int minNumGroups) {
        return this.combineBlock(groups, 0, groups.size(), sEst, cEst, minNumGroups);
    }

    private List<CompressedSizeInfoColGroup> combineBlock(List<CompressedSizeInfoColGroup> groups, int start, int end, AComEst sEst, ACostEstimate cEst, int minNumGroups) {
        Queue<CompressedSizeInfoColGroup> que = CoCodePriorityQue.getQue(end - start, cEst);
        for (int i = start; i < end; ++i) {
            CompressedSizeInfoColGroup g = groups.get(i);
            if (g == null) continue;
            que.add(g);
        }
        return this.combineBlock(que, sEst, cEst, minNumGroups);
    }

    private List<CompressedSizeInfoColGroup> combineBlock(Queue<CompressedSizeInfoColGroup> que, AComEst sEst, ACostEstimate cEst, int minNumGroups) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        CompressedSizeInfoColGroup l = null;
        l = que.poll();
        int groupNr = ret.size() + que.size();
        int lastCombine = 0;
        while (que.peek() != null && groupNr >= minNumGroups && lastCombine < 5) {
            CompressedSizeInfoColGroup r = que.peek();
            CompressedSizeInfoColGroup g = sEst.combine(l, r);
            if (g != null) {
                double costIndividual;
                double costOfJoin = cEst.getCost(g);
                if (costOfJoin < (costIndividual = cEst.getCost(l) + cEst.getCost(r))) {
                    que.poll();
                    int numColumns = g.getColumns().size();
                    if (numColumns > this.lastCombineThreshold) {
                        ++lastCombine;
                        ret.add(g);
                    } else {
                        lastCombine = 0;
                        que.add(g);
                    }
                } else {
                    ++lastCombine;
                    ret.add(l);
                }
            } else {
                ++lastCombine;
                ret.add(l);
            }
            l = que.poll();
            groupNr = ret.size() + que.size();
        }
        while (que.peek() != null) {
            ret.add(l);
            l = que.poll();
        }
        if (l != null) {
            ret.add(l);
        }
        for (CompressedSizeInfoColGroup g : que) {
            ret.add(g);
        }
        return ret;
    }

    private static Queue<CompressedSizeInfoColGroup> getQue(int size, ACostEstimate cEst) {
        Comparator<CompressedSizeInfoColGroup> comp = Comparator.comparing(x -> CoCodePriorityQue.getCost(x, cEst));
        PriorityQueue<CompressedSizeInfoColGroup> que = new PriorityQueue<CompressedSizeInfoColGroup>(size, comp);
        return que;
    }

    private static double getCost(CompressedSizeInfoColGroup x, ACostEstimate cEst) {
        return cEst.getCost(x) + x.getColumns().avgOfIndex() / 100000.0;
    }

    protected class PQTask
    implements Callable<List<CompressedSizeInfoColGroup>> {
        private final List<CompressedSizeInfoColGroup> _groups;
        private final int _start;
        private final int _end;
        private final AComEst _sEst;
        private final ACostEstimate _cEst;
        private final int _minNumGroups;

        protected PQTask(List<CompressedSizeInfoColGroup> groups, int start, int end, AComEst sEst, ACostEstimate cEst, int minNumGroups) {
            this._groups = groups;
            this._start = start;
            this._end = end;
            this._sEst = sEst;
            this._cEst = cEst;
            this._minNumGroups = minNumGroups;
        }

        @Override
        public List<CompressedSizeInfoColGroup> call() {
            try {
                return CoCodePriorityQue.this.combineBlock(this._groups, this._start, this._end, this._sEst, this._cEst, this._minNumGroups);
            }
            catch (Exception e) {
                throw new DMLCompressionException("Falied PQTask ", e);
            }
        }
    }
}

