/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressedArray;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ACompressedArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderComposite;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderFeatureHash;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.Timing;

public class CompressedEncode {
    protected static final Log LOG = LogFactory.getLog((String)CompressedEncode.class.getName());
    public static int ROW_PARALLELIZATION_THRESHOLD = 10000;
    private final MultiColumnEncoder enc;
    private final FrameBlock in;
    private final int k;
    private final ExecutorService pool;
    private final boolean inputContainsCompressed;
    private final AtomicLong nnz = new AtomicLong();
    private static final IColIndex SINGLE_COL_TMP_INDEX = ColIndexFactory.create(1);

    private CompressedEncode(MultiColumnEncoder enc, FrameBlock in, int k) {
        this.enc = enc;
        this.in = in;
        this.k = k;
        this.pool = k > 1 && CommonThreadPool.useParallelismOnThread() ? CommonThreadPool.get(k) : null;
        this.inputContainsCompressed = this.containsCompressed(in);
    }

    private boolean containsCompressed(FrameBlock in) {
        for (Array<?> c : in.getColumns()) {
            if (!(c instanceof ACompressedArray)) continue;
            return true;
        }
        return false;
    }

    public static MatrixBlock encode(MultiColumnEncoder enc, FrameBlock in, int k) throws Exception {
        return new CompressedEncode(enc, in, k).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixBlock apply() throws Exception {
        try {
            List<ColumnEncoderComposite> encoders = this.enc.getColumnEncoders();
            List<AColGroup> groups = this.isParallel() ? this.multiThread(encoders) : this.singleThread(encoders);
            int cols = this.shiftGroups(groups);
            CompressedMatrixBlock mb = new CompressedMatrixBlock(this.in.getNumRows(), cols, -1L, false, groups);
            mb.setNonZeros(this.nnz.get());
            this.logging(mb);
            CompressedMatrixBlock compressedMatrixBlock = mb;
            return compressedMatrixBlock;
        }
        finally {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    private boolean isParallel() {
        return this.pool != null;
    }

    private List<AColGroup> singleThread(List<ColumnEncoderComposite> encoders) throws Exception {
        ArrayList<AColGroup> groups = new ArrayList<AColGroup>(encoders.size());
        ArrayList<ColGroupUncompressedArray> ucg = new ArrayList<ColGroupUncompressedArray>();
        for (ColumnEncoderComposite c : encoders) {
            AColGroup g = this.encode(c);
            if (g instanceof ColGroupUncompressedArray) {
                ucg.add((ColGroupUncompressedArray)g);
                continue;
            }
            groups.add(g);
        }
        if (ucg.size() > 0) {
            groups.add(this.combine(ucg));
        }
        return groups;
    }

    private List<AColGroup> multiThread(List<ColumnEncoderComposite> encoders) throws Exception {
        ArrayList<Future<AColGroup>> tasks = new ArrayList<Future<AColGroup>>(encoders.size());
        ArrayList<Future<AColGroup>> ucgTasks = new ArrayList<Future<AColGroup>>();
        for (ColumnEncoderComposite c : encoders) {
            Array<?> array = this.in.getColumn(c._colID - 1);
            if (c.isPassThrough() && !(array instanceof ACompressedArray) && this.uncompressedPassThrough(array)) {
                ucgTasks.add(this.pool.submit(() -> this.encode(c)));
                continue;
            }
            tasks.add(this.pool.submit(() -> this.encode(c)));
        }
        ArrayList<AColGroup> groups = new ArrayList<AColGroup>(encoders.size());
        if (!ucgTasks.isEmpty()) {
            tasks.add(this.pool.submit(() -> this.combineFutures(ucgTasks)));
        }
        for (Future future : tasks) {
            groups.add((AColGroup)future.get());
        }
        return groups;
    }

    private int shiftGroups(List<AColGroup> groups) {
        int i;
        int curCols = 0;
        int curGroup = 0;
        List<ColumnEncoderComposite> encoders = this.enc.getColumnEncoders();
        IntArrayList ucCols = new IntArrayList();
        for (i = 0; i < encoders.size(); ++i) {
            ColumnEncoderComposite c = encoders.get(i);
            Array<?> a = this.in.getColumn(c._colID - 1);
            if (c.isPassThrough() && !(a instanceof ACompressedArray) && this.uncompressedPassThrough(a)) {
                ucCols.appendValue(curCols++);
                continue;
            }
            AColGroup g = groups.get(curGroup);
            groups.set(curGroup, g.shiftColIndices(curCols));
            curCols += g.getColIndices().size();
            ++curGroup;
        }
        if (ucCols.size() > 0) {
            i = groups.size() - 1;
            AColGroup g = groups.get(i);
            groups.set(i, g.copyAndSet(ColIndexFactory.create(ucCols)));
        }
        return curCols;
    }

    private AColGroup encode(ColumnEncoderComposite c) throws Exception {
        Timing t = new Timing();
        AColGroup g = this.executeEncode(c);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Encode: columns: %4d estimateDistinct: %6d distinct: %6d size: %6d time: %10f", c._colID, c._estNumDistincts, g.getNumValues(), g.estimateInMemorySize(), t.stop()));
        }
        return g;
    }

    private AColGroup executeEncode(ColumnEncoderComposite c) throws Exception {
        if (c.isRecodeToDummy()) {
            return this.recodeToDummy(c);
        }
        if (c.isRecode()) {
            return this.recode(c);
        }
        if (c.isPassThrough()) {
            return this.passThrough(c);
        }
        if (c.isBin()) {
            return this.bin(c);
        }
        if (c.isBinToDummy()) {
            return this.binToDummy(c);
        }
        if (c.isHash()) {
            return this.hash(c);
        }
        if (c.isHashToDummy()) {
            return this.hashToDummy(c);
        }
        throw new NotImplementedException("Not supporting : " + c);
    }

    private <T> AColGroup recodeToDummy(ColumnEncoderComposite c) throws Exception {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        boolean containsNull = a.containsNull();
        this.estimateRCDMapSize(c);
        HashMapToInt map = (HashMapToInt)a.getRecodeMap(c._estNumDistincts, this.pool, this.k / this.in.getNumColumns());
        List<ColumnEncoder> r = c.getEncoders();
        r.set(0, new ColumnEncoderRecode(colId, map));
        int domain = map.size();
        if (containsNull && domain == 0) {
            return new ColGroupEmpty(SINGLE_COL_TMP_INDEX);
        }
        IColIndex colIndexes = ColIndexFactory.create(0, domain);
        if (domain == 1 && !containsNull) {
            this.nnz.addAndGet(this.in.getNumRows());
            return ColGroupConst.create(colIndexes, new double[]{1.0});
        }
        IDictionary d = IdentityDictionary.create(colIndexes.size(), containsNull);
        AMapToData m = this.createMappingAMapToData(a, map, containsNull);
        AColGroup ret = ColGroupDDC.create(colIndexes, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private AColGroup bin(ColumnEncoderComposite c) throws InterruptedException, ExecutionException {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        List<ColumnEncoder> r = c.getEncoders();
        ColumnEncoderBin b = (ColumnEncoderBin)r.get(0);
        b.build(this.in);
        boolean containsNull = b.containsNull;
        MatrixBlockDictionary d = this.createIncrementingVector(b._numBin, containsNull);
        AMapToData m = this.binEncode(a, b, containsNull);
        AColGroup ret = ColGroupDDC.create(SINGLE_COL_TMP_INDEX, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private AMapToData binEncode(Array<?> a, ColumnEncoderBin b, boolean nulls) throws InterruptedException, ExecutionException {
        AMapToData m = MapToFactory.create(a.size(), b._numBin + (nulls ? 1 : 0));
        if (!nulls && b.getBinMethod() == ColumnEncoderBin.BinMethod.EQUI_WIDTH) {
            double min = b.getBinMins()[0];
            double max = b.getBinMaxs()[b.getNumBin() - 1];
            if (Util.eq(max, min)) {
                m.fill(0);
                return m;
            }
            if (b._numBin <= 0) {
                throw new RuntimeException("Invalid num bins");
            }
        }
        int rlen = a.size();
        if (this.k / this.in.getNumColumns() > 1 && rlen > ROW_PARALLELIZATION_THRESHOLD) {
            this.BinEncodeParallel(a, b, nulls, m, rlen);
        } else if (nulls) {
            this.binEncodeWithNulls(a, b, m, 0, a.size());
        } else {
            this.binEncodeNoNull(a, b, m, 0, a.size());
        }
        return m;
    }

    private void BinEncodeParallel(Array<?> a, ColumnEncoderBin b, boolean nulls, AMapToData m, int rlen) throws InterruptedException, ExecutionException {
        ArrayList tasks = new ArrayList();
        int tk = this.k / this.in.getNumColumns();
        int blockSize = Math.max(ROW_PARALLELIZATION_THRESHOLD / 2, rlen + tk / tk);
        for (int i = 0; i < rlen; i += blockSize) {
            int n = i;
            int end = Math.min(rlen, i + blockSize);
            tasks.add(this.pool.submit(() -> {
                if (nulls) {
                    this.binEncodeWithNulls(a, b, m, start, end);
                } else {
                    this.binEncodeNoNull(a, b, m, start, end);
                }
            }));
        }
        for (Future future : tasks) {
            future.get();
        }
    }

    private void binEncodeWithNulls(Array<?> a, ColumnEncoderBin b, AMapToData m, int l, int u) {
        for (int i = l; i < u; ++i) {
            double v = a.getAsNaNDouble(i);
            if (Double.isNaN(v)) {
                m.set(i, b._numBin);
                continue;
            }
            int idx = (int)b.getCodeIndex(v) - 1;
            if (idx < 0) {
                idx = 0;
            }
            m.set(i, idx);
        }
    }

    private final void binEncodeNoNull(Array<?> a, ColumnEncoderBin b, AMapToData m, int l, int u) {
        if (b.getBinMethod() == ColumnEncoderBin.BinMethod.EQUI_WIDTH) {
            this.binEncodeNoNullEqWidth(a, b, m, l, u);
        } else {
            this.binEncodeNoNullGeneric(a, b, m, l, u);
        }
    }

    private final void binEncodeNoNullEqWidth(Array<?> a, ColumnEncoderBin b, AMapToData m, int l, int u) {
        double min = b.getBinMins()[0];
        double max = b.getBinMaxs()[b.getNumBin() - 1];
        for (int i = l; i < u; ++i) {
            m.set(i, b.getEqWidthUnsafe(a.getAsDouble(i), min, max) - 1);
        }
    }

    private final void binEncodeNoNullGeneric(Array<?> a, ColumnEncoderBin b, AMapToData m, int l, int u) {
        double min = b.getBinMins()[0];
        double max = b.getBinMaxs()[b.getNumBin() - 1];
        for (int i = l; i < u; ++i) {
            m.set(i, (int)b.getCodeIndex(a.getAsDouble(i), min, max) - 1);
        }
    }

    private MatrixBlockDictionary createIncrementingVector(int nVals, boolean NaN) {
        MatrixBlock bins = new MatrixBlock(nVals + (NaN ? 1 : 0), 1, false);
        for (int i = 0; i < nVals; ++i) {
            bins.set(i, 0, i + 1);
        }
        if (NaN) {
            bins.set(nVals, 0, Double.NaN);
        }
        return MatrixBlockDictionary.create(bins);
    }

    private AColGroup binToDummy(ColumnEncoderComposite c) throws InterruptedException, ExecutionException {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        List<ColumnEncoder> r = c.getEncoders();
        ColumnEncoderBin b = (ColumnEncoderBin)r.get(0);
        b.build(this.in);
        boolean containsNull = b.containsNull;
        IColIndex colIndexes = ColIndexFactory.create(0, b._numBin);
        IDictionary d = IdentityDictionary.create(colIndexes.size(), containsNull);
        AMapToData m = this.binEncode(a, b, containsNull);
        AColGroup ret = ColGroupDDC.create(colIndexes, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private <T> AColGroup recode(ColumnEncoderComposite c) throws Exception {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        this.estimateRCDMapSize(c);
        HashMapToInt map = (HashMapToInt)a.getRecodeMap(c._estNumDistincts, this.pool, this.k / this.in.getNumColumns());
        boolean containsNull = a.containsNull();
        int domain = map.size();
        if (domain == 0 && containsNull) {
            return new ColGroupEmpty(SINGLE_COL_TMP_INDEX);
        }
        if (domain == 1 && !containsNull) {
            this.nnz.addAndGet(this.in.getNumRows());
            return ColGroupConst.create(SINGLE_COL_TMP_INDEX, new double[]{1.0});
        }
        ADictionary d = this.createRecodeDictionary(containsNull, domain);
        AMapToData m = this.createMappingAMapToData(a, map, containsNull);
        List<ColumnEncoder> r = c.getEncoders();
        r.set(0, new ColumnEncoderRecode(colId, map));
        AColGroup ret = ColGroupDDC.create(SINGLE_COL_TMP_INDEX, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private ADictionary createRecodeDictionary(boolean containsNull, int domain) {
        MatrixBlock incrementing = new MatrixBlock(domain + (containsNull ? 1 : 0), 1, false);
        for (int i = 0; i < domain; ++i) {
            incrementing.set(i, 0, i + 1);
        }
        if (containsNull) {
            incrementing.set(domain, 0, Double.NaN);
        }
        MatrixBlockDictionary d = MatrixBlockDictionary.create(incrementing);
        return d;
    }

    private <T> AColGroup passThrough(ColumnEncoderComposite c) throws Exception {
        int colId = c._colID - 1;
        Array<?> a = this.in.getColumn(colId);
        if (a instanceof ACompressedArray) {
            return this.passThroughCompressed(a);
        }
        if (this.uncompressedPassThrough(a)) {
            return new ColGroupUncompressedArray(a, colId, SINGLE_COL_TMP_INDEX);
        }
        return this.compressingPassThrough(c, a);
    }

    private <T> AColGroup compressingPassThrough(ColumnEncoderComposite c, Array<T> a) throws InterruptedException, ExecutionException, Exception {
        boolean containsNull = a.containsNull();
        this.estimateRCDMapSize(c);
        HashMapToInt map = (HashMapToInt)a.getRecodeMap(c._estNumDistincts, this.pool, this.k / this.in.getNumColumns());
        double[] vals = new double[map.size() + (containsNull ? 1 : 0)];
        if (containsNull) {
            vals[map.size()] = Double.NaN;
        }
        Types.ValueType t = a.getValueType();
        map.forEach((k, v) -> {
            vals[v.intValue() - 1] = UtilFunctions.objectToDouble(t, k);
        });
        Dictionary d = Dictionary.create(vals);
        AMapToData m = this.createMappingAMapToData(a, map, containsNull);
        AColGroup ret = ColGroupDDC.create(SINGLE_COL_TMP_INDEX, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private <T> boolean uncompressedPassThrough(Array<T> a) {
        if (a.getValueType() != Types.ValueType.BOOLEAN) {
            ArrayCompressionStatistics stats = !this.inputContainsCompressed ? a.statistics(Math.min(1000, a.size())) : null;
            return stats == null || !stats.shouldCompress || stats.valueType != a.getValueType();
        }
        return false;
    }

    private <T> AColGroup passThroughCompressed(Array<T> a) throws InterruptedException, ExecutionException {
        DDCArray aDDC = (DDCArray)a;
        Array dict = aDDC.getDict();
        int dSize = dict.size();
        double[] vals = this.passThroughCompressedCreateDict(a, dict, dSize);
        Dictionary d = Dictionary.create(vals);
        AColGroup ret = ColGroupDDC.create(SINGLE_COL_TMP_INDEX, d, aDDC.getMap(), null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private <T> double[] passThroughCompressedCreateDict(Array<T> a, Array<?> dict, int dSize) throws InterruptedException, ExecutionException {
        double[] vals;
        boolean nulls = a.containsNull();
        if (dict.getValueType() == Types.ValueType.FP64 && !nulls) {
            DoubleArray converted = (DoubleArray)dict;
            vals = converted.get();
        } else if (!nulls) {
            DoubleArray converted = ArrayFactory.create(new double[dSize]);
            this.passThroughTransferNoNulls(dict, dSize, converted);
            vals = converted.get();
        } else {
            vals = this.passThroughTransferNulls(dict, dSize);
        }
        return vals;
    }

    private double[] passThroughTransferNulls(Array<?> dict, int dSize) {
        double[] vals = new double[dSize];
        for (int i = 0; i < dSize; ++i) {
            vals[i] = dict.getAsNaNDouble(i);
        }
        return vals;
    }

    private void passThroughTransferNoNulls(Array<?> dict, int dSize, DoubleArray converted) throws InterruptedException, ExecutionException {
        if (this.isParallel() && dSize > 10000) {
            int blkz = Math.min(10000, (dSize + this.k) / this.k);
            ArrayList tasks = new ArrayList();
            for (int i = 0; i < dSize; i += blkz) {
                int n = i;
                int ei = Math.min(dSize, i + blkz);
                tasks.add(this.pool.submit(() -> dict.changeType(converted, si, ei)));
            }
            for (Future future : tasks) {
                future.get();
            }
        } else {
            dict.changeType(converted, 0, dSize);
        }
    }

    private <T> AMapToData createMappingAMapToData(Array<T> a, HashMapToInt<T> map, boolean containsNull) throws Exception {
        int si = map.size();
        int nRow = this.in.getNumRows();
        if (!containsNull && a instanceof DDCArray) {
            return ((DDCArray)a).getMap();
        }
        AMapToData m = MapToFactory.create(nRow, si + (containsNull ? 1 : 0));
        if (this.k / this.in.getNumColumns() > 1 && nRow > ROW_PARALLELIZATION_THRESHOLD) {
            return this.CreateMappingParallel(a, map, containsNull, si, nRow, m);
        }
        return this.createMappingSingleThread(a, map, containsNull, si, nRow, m);
    }

    private <T> AMapToData CreateMappingParallel(Array<T> a, HashMapToInt<T> map, boolean containsNull, int si, int nRow, AMapToData m) throws InterruptedException, ExecutionException {
        int tk = this.k / this.in.getNumColumns();
        int blkz = Math.max(ROW_PARALLELIZATION_THRESHOLD / 2, (nRow + tk) / tk);
        ArrayList<Future<AMapToData>> tasks = new ArrayList<Future<AMapToData>>();
        for (int i = 0; i < nRow; i += blkz) {
            int n = i;
            int end = Math.min(nRow, i + blkz);
            tasks.add(this.pool.submit(() -> {
                if (containsNull) {
                    return CompressedEncode.createMappingAMapToDataWithNull(a, map, si, m, start, end);
                }
                return CompressedEncode.createMappingAMapToDataNoNull(a, map, m, start, end);
            }));
        }
        for (Future future : tasks) {
            future.get();
        }
        return m;
    }

    private <T> AMapToData createMappingSingleThread(Array<T> a, HashMapToInt<T> map, boolean containsNull, int si, int nRow, AMapToData m) {
        if (containsNull) {
            return CompressedEncode.createMappingAMapToDataWithNull(a, map, si, m, 0, nRow);
        }
        return CompressedEncode.createMappingAMapToDataNoNull(a, map, m, 0, nRow);
    }

    private static <T> AMapToData createMappingAMapToDataNoNull(Array<T> a, HashMapToInt<T> map, AMapToData m, int start, int end) {
        for (int i = start; i < end; ++i) {
            a.setM(map, m, i);
        }
        return m;
    }

    private static <T> AMapToData createMappingAMapToDataWithNull(Array<T> a, HashMapToInt<T> map, int si, AMapToData m, int start, int end) {
        for (int i = start; i < end; ++i) {
            a.setM(map, si, m, i);
        }
        return m;
    }

    private AMapToData createHashMappingAMapToData(Array<?> a, int k, boolean nulls) {
        AMapToData m = MapToFactory.create(a.size(), k + (nulls ? 1 : 0));
        if (nulls) {
            for (int i = 0; i < a.size(); ++i) {
                double h = Math.abs(a.hashDouble(i)) % (double)k;
                if (Double.isNaN(h)) {
                    m.set(i, k);
                    continue;
                }
                m.set(i, (int)h);
            }
        } else {
            for (int i = 0; i < a.size(); ++i) {
                double h = Math.abs(a.hashDouble(i)) % (double)k;
                m.set(i, (int)h);
            }
        }
        return m;
    }

    private AColGroup hash(ColumnEncoderComposite c) {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        ColumnEncoderFeatureHash CEHash = (ColumnEncoderFeatureHash)c.getEncoders().get(0);
        int domain = (int)CEHash.getK();
        boolean nulls = a.containsNull();
        if (domain == 0 && nulls) {
            return new ColGroupEmpty(SINGLE_COL_TMP_INDEX);
        }
        if (domain == 1 && !nulls) {
            this.nnz.addAndGet(this.in.getNumRows());
            return ColGroupConst.create(SINGLE_COL_TMP_INDEX, new double[]{1.0});
        }
        MatrixBlock incrementing = new MatrixBlock(domain + (nulls ? 1 : 0), 1, false);
        for (int i = 0; i < domain; ++i) {
            incrementing.set(i, 0, i + 1);
        }
        if (nulls) {
            incrementing.set(domain, 0, Double.NaN);
        }
        MatrixBlockDictionary d = MatrixBlockDictionary.create(incrementing);
        AMapToData m = this.createHashMappingAMapToData(a, domain, nulls);
        AColGroup ret = ColGroupDDC.create(SINGLE_COL_TMP_INDEX, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private AColGroup hashToDummy(ColumnEncoderComposite c) {
        int colId = c._colID;
        Array<?> a = this.in.getColumn(colId - 1);
        ColumnEncoderFeatureHash CEHash = (ColumnEncoderFeatureHash)c.getEncoders().get(0);
        int domain = (int)CEHash.getK();
        boolean nulls = a.containsNull();
        IColIndex colIndexes = ColIndexFactory.create(0, domain);
        if (domain == 0 && nulls) {
            return new ColGroupEmpty(ColIndexFactory.create(1));
        }
        if (domain == 1 && !nulls) {
            this.nnz.addAndGet(this.in.getNumRows());
            return ColGroupConst.create(colIndexes, new double[]{1.0});
        }
        IDictionary d = IdentityDictionary.create(colIndexes.size(), nulls);
        AMapToData m = this.createHashMappingAMapToData(a, domain, nulls);
        AColGroup ret = ColGroupDDC.create(colIndexes, d, m, null);
        this.nnz.addAndGet(ret.getNumberNonZeros(this.in.getNumRows()));
        return ret;
    }

    private <T> void estimateRCDMapSize(ColumnEncoderComposite c) {
        int estDistCount;
        if (c._estNumDistincts != 0) {
            return;
        }
        Array<?> col = this.in.getColumn(c._colID - 1);
        if (col instanceof DDCArray) {
            DDCArray ddcCol = (DDCArray)col;
            c._estNumDistincts = ddcCol.getDict().size();
            return;
        }
        int nRow = this.in.getNumRows();
        if (nRow <= 1024) {
            c._estNumDistincts = 10;
            return;
        }
        int sampleSize = Math.max(Math.min(this.in.getNumRows() / 50, 8192), 1024);
        HashMap distinctFreq = new HashMap();
        for (int sind = 0; sind < sampleSize; ++sind) {
            Object key = col.getInternal(sind);
            if (distinctFreq.containsKey(key)) {
                distinctFreq.put(key, (Integer)distinctFreq.get(key) + 1);
                continue;
            }
            distinctFreq.put(key, 1);
        }
        int[] freq = distinctFreq.values().stream().mapToInt(v -> v).toArray();
        c._estNumDistincts = estDistCount = SampleEstimatorFactory.distinctCount(freq, nRow, sampleSize, SampleEstimatorFactory.EstimationType.HassAndStokes);
    }

    private AColGroup combineFutures(List<Future<AColGroup>> ucgTasks) throws InterruptedException, ExecutionException {
        ArrayList<ColGroupUncompressedArray> ucg = new ArrayList<ColGroupUncompressedArray>(ucgTasks.size());
        for (Future<AColGroup> g : ucgTasks) {
            ucg.add((ColGroupUncompressedArray)g.get());
        }
        return this.combine(ucg);
    }

    private AColGroup combine(List<ColGroupUncompressedArray> ucg) throws InterruptedException, ExecutionException {
        Timing t = new Timing();
        IColIndex combinedCols = ColIndexFactory.create(ucg.size());
        ucg.sort((a, b) -> Integer.compare(a.id, b.id));
        MatrixBlock ret = new MatrixBlock(this.in.getNumRows(), combinedCols.size(), false);
        ret.allocateDenseBlock();
        DenseBlock db = ret.getDenseBlock();
        int nrow = this.in.getNumRows();
        int ncol = combinedCols.size();
        long combinedNNZ = this.isParallel() && (long)nrow * (long)ncol > 10000L && nrow > 512 ? this.parallelPutInto(ucg, db, nrow, ncol) : this.putInto(ucg, db, 0, nrow, 0, ncol);
        this.nnz.addAndGet(combinedNNZ);
        ret.setNonZeros(combinedNNZ);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Combining of : " + ucg.size() + " uncompressed columns Time: " + t.stop()));
        }
        return ColGroupUncompressed.create(ret, combinedCols);
    }

    private long parallelPutInto(List<ColGroupUncompressedArray> ucg, DenseBlock db, int nrow, int ncol) throws InterruptedException, ExecutionException {
        ArrayList<Future<Long>> tasks = new ArrayList<Future<Long>>();
        int iblk = Math.max(512, nrow / this.k);
        int jblk = Math.min(128, ncol);
        for (int i = 0; i < nrow; i += iblk) {
            int si = i;
            int ei = Math.min(nrow, iblk + i);
            for (int j = 0; j < ncol; j += jblk) {
                int sj = j;
                int ej = Math.min(ncol, jblk + j);
                tasks.add(this.pool.submit(() -> this.putInto(ucg, db, si, ei, sj, ej)));
            }
        }
        long nnz = 0L;
        for (Future future : tasks) {
            nnz += ((Long)future.get()).longValue();
        }
        return nnz;
    }

    private final long putInto(List<ColGroupUncompressedArray> ucg, DenseBlock db, int il, int iu, int jl, int ju) {
        long nnz = 0L;
        for (int i = il; i < iu; ++i) {
            double[] rval = db.values(i);
            int off = db.pos(i);
            nnz = this.putIntoRowBlock(ucg, jl, ju, nnz, i, rval, off);
        }
        return nnz;
    }

    private final long putIntoRowBlock(List<ColGroupUncompressedArray> ucg, int jl, int ju, long nnz, int i, double[] rval, int off) {
        for (int j = jl; j < ju; ++j) {
            double d = ucg.get((int)j).array.getAsNaNDouble(i);
            rval[off + j] = d;
            nnz += d == 0.0 ? 0L : 1L;
        }
        return nnz;
    }

    private void logging(MatrixBlock mb) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Uncompressed transform encode Dense size:   %16d", mb.estimateSizeDenseInMemory()));
            LOG.debug((Object)String.format("Uncompressed transform encode Sparse size:  %16d", mb.estimateSizeSparseInMemory()));
            LOG.debug((Object)String.format("Compressed transform encode size:           %16d", mb.estimateSizeInMemory()));
            double ratio = Math.min(mb.estimateSizeDenseInMemory(), mb.estimateSizeSparseInMemory()) / mb.estimateSizeInMemory();
            double denseRatio = mb.estimateSizeDenseInMemory() / mb.estimateSizeInMemory();
            LOG.debug((Object)String.format("Compression ratio: %10.3f", ratio));
            LOG.debug((Object)String.format("Dense ratio:       %10.3f", denseRatio));
        }
    }
}

