/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.HashSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LibMatrixSketch {
    public static MatrixBlock getUniqueValues(MatrixBlock blkIn, Types.Direction dir) {
        int rlen = blkIn.getNumRows();
        int clen = blkIn.getNumColumns();
        MatrixBlock blkOut = null;
        switch (dir) {
            case RowCol: {
                HashSet<Double> hashSet = new HashSet<Double>();
                for (int i = 0; i < rlen; ++i) {
                    for (int j = 0; j < clen; ++j) {
                        hashSet.add(blkIn.get(i, j));
                    }
                }
                int rlen2 = hashSet.size();
                blkOut = new MatrixBlock(rlen2, 1, false).allocateBlock();
                int pos = 0;
                for (Double val : hashSet) {
                    blkOut.set(pos++, 0, val);
                }
                break;
            }
            case Row: {
                int j;
                int i;
                HashSet<Double> hashSet = new HashSet<Double>();
                int clen2 = 0;
                for (i = 0; i < rlen; ++i) {
                    hashSet.clear();
                    for (j = 0; j < clen; ++j) {
                        hashSet.add(blkIn.get(i, j));
                    }
                    clen2 = Math.max(clen2, hashSet.size());
                }
                blkOut = new MatrixBlock(rlen, clen2, false).allocateBlock();
                for (i = 0; i < rlen; ++i) {
                    hashSet.clear();
                    for (j = 0; j < clen; ++j) {
                        hashSet.add(blkIn.get(i, j));
                    }
                    int pos = 0;
                    for (Double val : hashSet) {
                        blkOut.set(i, pos++, val);
                    }
                }
                break;
            }
            case Col: {
                int i;
                int j;
                HashSet<Double> hashSet = new HashSet<Double>();
                int rlen2 = 0;
                for (j = 0; j < clen; ++j) {
                    hashSet.clear();
                    for (i = 0; i < rlen; ++i) {
                        hashSet.add(blkIn.get(i, j));
                    }
                    rlen2 = Math.max(rlen2, hashSet.size());
                }
                blkOut = new MatrixBlock(rlen2, clen, false).allocateBlock();
                for (j = 0; j < clen; ++j) {
                    hashSet.clear();
                    for (i = 0; i < rlen; ++i) {
                        hashSet.add(blkIn.get(i, j));
                    }
                    int pos = 0;
                    for (Double val : hashSet) {
                        blkOut.set(pos++, j, val);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized direction: " + dir);
            }
        }
        return blkOut;
    }
}

