/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

final class PackedRecordPointer {
    static final int MAXIMUM_PAGE_SIZE_BYTES = 0x8000000;
    static final int MAXIMUM_PARTITION_ID = 0xFFFFFF;
    static final int PARTITION_ID_START_BYTE_INDEX = 5;
    static final int PARTITION_ID_END_BYTE_INDEX = 7;
    private static final long MASK_LONG_LOWER_40_BITS = 0xFFFFFFFFFFL;
    private static final long MASK_LONG_UPPER_24_BITS = -1099511627776L;
    private static final long MASK_LONG_LOWER_27_BITS = 0x7FFFFFFL;
    private static final long MASK_LONG_LOWER_51_BITS = 0x7FFFFFFFFFFFFL;
    private static final long MASK_LONG_UPPER_13_BITS = -2251799813685248L;
    private long packedRecordPointer;

    PackedRecordPointer() {
    }

    public static long packPointer(long recordPointer, int partitionId) {
        assert (partitionId <= 0xFFFFFF);
        long pageNumber = (recordPointer & 0xFFF8000000000000L) >>> 24;
        long compressedAddress = pageNumber | recordPointer & 0x7FFFFFFL;
        return (long)partitionId << 40 | compressedAddress;
    }

    public void set(long packedRecordPointer) {
        this.packedRecordPointer = packedRecordPointer;
    }

    public int getPartitionId() {
        return (int)((this.packedRecordPointer & 0xFFFFFF0000000000L) >>> 40);
    }

    public long getRecordPointer() {
        long pageNumber = this.packedRecordPointer << 24 & 0xFFF8000000000000L;
        long offsetInPage = this.packedRecordPointer & 0x7FFFFFFL;
        return pageNumber | offsetInPage;
    }
}

