/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface SettingsChecker {
    public static final Log LOG = LogFactory.getLog((String)SettingsChecker.class.getName());

    public static void check() {
        if (LOG.isWarnEnabled()) {
            SettingsChecker.checkMemorySetting();
        }
    }

    public static void checkMemorySetting() {
        long JRE_Mem_Byte = Runtime.getRuntime().maxMemory();
        long Sys_Mem_Byte = SettingsChecker.maxMemMachine();
        long DefaultJava_500MB = 524288000L;
        long Logging_Limit = 0x280000000L;
        if (JRE_Mem_Byte <= 524288000L) {
            String st = SettingsChecker.byteMemoryToString(JRE_Mem_Byte);
            LOG.warn((Object)("Low memory budget set of: " + st + " this should most likely be increased"));
        } else if (JRE_Mem_Byte < 0x280000000L && JRE_Mem_Byte * 10L < Sys_Mem_Byte) {
            String st = SettingsChecker.byteMemoryToString(JRE_Mem_Byte);
            String sm = SettingsChecker.byteMemoryToString(Sys_Mem_Byte);
            LOG.warn((Object)("Low memory budget of total: " + sm + " set to: " + st));
        }
    }

    public static long maxMemMachine() {
        String sys = System.getProperty("os.name");
        if ("Linux".equals(sys)) {
            return SettingsChecker.maxMemMachineLinux() * 1024L;
        }
        if (sys.contains("Mac OS")) {
            return SettingsChecker.maxMemMachineOSX();
        }
        if (sys.startsWith("Windows")) {
            return SettingsChecker.maxMemMachineWin();
        }
        return -1L;
    }

    private static long maxMemMachineLinux() {
        long l;
        BufferedReader reader = new BufferedReader(new FileReader("/proc/meminfo"));
        try {
            String currentLine = reader.readLine();
            while (!currentLine.contains("MemTotal:")) {
                currentLine = reader.readLine();
            }
            l = Long.parseLong(currentLine.split(":")[1].split("kB")[0].strip());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }
        reader.close();
        return l;
    }

    private static long maxMemMachineOSX() {
        try {
            String command = "sysctl hw.memsize";
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            String memStr = new String(pr.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            return Long.parseLong(memStr.trim().substring(12, memStr.length() - 1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static long maxMemMachineWin() {
        try {
            String command = "wmic memorychip get capacity";
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            String[] memStr = new String(pr.getInputStream().readAllBytes(), StandardCharsets.UTF_8).split("\n");
            long capacity = 0L;
            for (int i = 1; i < memStr.length; ++i) {
                String tmp = memStr[i].trim();
                if (tmp.length() <= 0) continue;
                capacity += Long.parseLong(tmp);
            }
            return capacity;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteMemoryToString(long bytes) {
        if (bytes > 1000000000L) {
            return String.format("%6d GB", bytes / 1024L / 1024L / 1024L);
        }
        if (bytes > 1000000L) {
            return String.format("%6d MB", bytes / 1024L / 1024L);
        }
        if (bytes > 1000L) {
            return String.format("%6d KB", bytes / 1024L);
        }
        return String.format("%6d B", bytes);
    }
}

