/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.TensorWriterTextCell;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class TensorWriterTextCellParallel
extends TensorWriterTextCell {
    @Override
    protected void writeTextCellTensorToHDFS(Path path, FileSystem fs, TensorBlock src) throws IOException {
        int numPartFiles = (int)(OptimizerUtils.estimateSizeTextOutput(src.getDims(), src.getLength(), Types.FileFormat.TEXT) / InfrastructureAnalyzer.getHDFSBlockSize());
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeTextCellTensorToHDFS(path, fs, src);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<WriteTextTask> tasks = new ArrayList<WriteTextTask>();
            int rlen = src.getNumRows();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & i * blklen < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteTextTask(newPath, fs, src, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            for (Future task : pool.invokeAll(tasks)) {
                task.get();
            }
            if (fs instanceof LocalFileSystem) {
                i = 0;
                while (i < numThreads & i * blklen < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i)));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of text output.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private static class WriteTextTask
    implements Callable<Object> {
        private FileSystem _fs;
        private TensorBlock _src;
        private Path _path;
        private int _rl;
        private int _ru;

        public WriteTextTask(Path path, FileSystem fs, TensorBlock src, int rl, int ru) {
            this._path = path;
            this._fs = fs;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() throws Exception {
            TensorWriterTextCell.writeTextCellTensorToFile(this._path, this._fs, this._src, this._rl, this._ru);
            return null;
        }
    }
}

