/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;

public class UnaryFrameCPInstruction
extends UnaryCPInstruction {
    protected UnaryFrameCPInstruction(MultiThreadedOperator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(CPInstruction.CPType.Unary, op, in, out, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.getOpcode().equals(Opcodes.TYPEOF.toString())) {
            FrameBlock inBlock = ec.getFrameInput(this.input1.getName());
            FrameBlock retBlock = inBlock.getSchemaTypeOf();
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else if (this.getOpcode().equals(Opcodes.DETECTSCHEMA.toString())) {
            FrameBlock inBlock = ec.getFrameInput(this.input1.getName());
            FrameBlock retBlock = inBlock.detectSchema(((MultiThreadedOperator)this._optr).getNumThreads());
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else if (this.getOpcode().equals(Opcodes.COLNAMES.toString())) {
            FrameBlock inBlock = ec.getFrameInput(this.input1.getName());
            FrameBlock retBlock = inBlock.getColumnNamesAsFrame();
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), retBlock);
        } else {
            throw new DMLScriptException("Opcode '" + this.getOpcode() + "' is not a valid UnaryFrameCPInstruction");
        }
    }
}

