/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.sysds.runtime.util.UtilFunctions;

public class MatrixIndexes
implements WritableComparable<MatrixIndexes>,
RawComparator<MatrixIndexes>,
Externalizable {
    private static final long serialVersionUID = -1521166657518127789L;
    private long _row = -1L;
    private long _col = -1L;

    public MatrixIndexes() {
    }

    public MatrixIndexes(long r, long c) {
        this.setIndexes(r, c);
    }

    public MatrixIndexes(MatrixIndexes indexes) {
        this.setIndexes(indexes._row, indexes._col);
    }

    public long getRowIndex() {
        return this._row;
    }

    public long getColumnIndex() {
        return this._col;
    }

    public MatrixIndexes setIndexes(long r, long c) {
        this._row = r;
        this._col = c;
        return this;
    }

    public MatrixIndexes setIndexes(MatrixIndexes that) {
        this._row = that._row;
        this._col = that._col;
        return this;
    }

    public int compareTo(MatrixIndexes other) {
        if (this._row != other._row) {
            return this._row > other._row ? 1 : -1;
        }
        if (this._col != other._col) {
            return this._col > other._col ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MatrixIndexes)) {
            return false;
        }
        MatrixIndexes tother = (MatrixIndexes)other;
        return this._row == tother._row && this._col == tother._col;
    }

    public int hashCode() {
        return UtilFunctions.longHashCode(this._row, this._col);
    }

    public String toString() {
        return "(" + this._row + ", " + this._col + ")";
    }

    public void readFields(DataInput in) throws IOException {
        this._row = in.readLong();
        this._col = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this._row);
        out.writeLong(this._col);
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        long v2;
        long v1 = WritableComparator.readLong((byte[])b1, (int)s1);
        if (v1 != (v2 = WritableComparator.readLong((byte[])b2, (int)s2))) {
            return v1 < v2 ? -1 : 1;
        }
        v1 = WritableComparator.readLong((byte[])b1, (int)(s1 + 8));
        return v1 < (v2 = WritableComparator.readLong((byte[])b2, (int)(s2 + 8))) ? -1 : (v1 == v2 ? 0 : 1);
    }

    public int compare(MatrixIndexes m1, MatrixIndexes m2) {
        return m1.compareTo(m2);
    }
}

