/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToChar
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    private final char[] _data;

    protected MapToChar(int size) {
        this(65535, size);
    }

    public MapToChar(int unique, int size) {
        super(Math.min(unique, 65536));
        this._data = new char[size];
    }

    public MapToChar(int unique, char[] data) {
        super(unique);
        this._data = data;
        this.verify();
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (char)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToChar.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.charArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 2;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (char)v;
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (char)v;
        return this._data[n];
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void replace(int v, int r) {
        char cv = (char)v;
        char rv = (char)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.CHAR.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        int BS = 100;
        if (this._data.length > 100) {
            byte[] buff = new byte[200];
            int i = 0;
            while (i < this._data.length) {
                if (i + 100 <= this._data.length) {
                    for (int o = 0; o < 100; ++o) {
                        IOUtilFunctions.shortToBa(this._data[i++], buff, o * 2);
                    }
                    out.write(buff);
                    continue;
                }
                while (i < this._data.length) {
                    out.writeChar(this._data[i]);
                    ++i;
                }
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                out.writeChar(this._data[i]);
            }
        }
    }

    protected static MapToChar readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data = new char[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readChar();
        }
        return new MapToChar(unique, data);
    }

    protected char[] getChars() {
        return this._data;
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    protected void preAggregateDenseMultiRowContiguousBy8(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int h = (cu - cl) % 8;
        this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cl + h);
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl + h; c < cu; c += 8) {
            char id1 = this._data[c];
            char id2 = this._data[c + 1];
            char id3 = this._data[c + 2];
            char id4 = this._data[c + 3];
            char id5 = this._data[c + 4];
            char id6 = this._data[c + 5];
            char id7 = this._data[c + 6];
            char id8 = this._data[c + 7];
            int start = c + offR;
            int end = c + offE;
            int nValOff = 0;
            for (int off = start; off < end; off += nCol) {
                int n = id1 + nValOff;
                preAV[n] = preAV[n] + mV[off];
                int n2 = id2 + nValOff;
                preAV[n2] = preAV[n2] + mV[off + 1];
                int n3 = id3 + nValOff;
                preAV[n3] = preAV[n3] + mV[off + 2];
                int n4 = id4 + nValOff;
                preAV[n4] = preAV[n4] + mV[off + 3];
                int n5 = id5 + nValOff;
                preAV[n5] = preAV[n5] + mV[off + 4];
                int n6 = id6 + nValOff;
                preAV[n6] = preAV[n6] + mV[off + 5];
                int n7 = id7 + nValOff;
                preAV[n7] = preAV[n7] + mV[off + 6];
                int n8 = id8 + nValOff;
                preAV[n8] = preAV[n8] + mV[off + 7];
                nValOff += nVal;
            }
        }
    }

    @Override
    public int getUpperBoundValue() {
        return 65535;
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (char)d[i];
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data[i] = '\u0001';
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        for (int i = 0; i < this._data.length; ++i) {
            char c = this._data[i];
            ret[c] = ret[c] + 1;
        }
        return ret;
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ((AMapToData)ret).copy(this);
        return ret;
    }

    @Override
    public int countRuns() {
        int c = 1;
        char prev = this._data[0];
        for (int i = 1; i < this._data.length; ++i) {
            c += prev == this._data[i] ? 0 : 1;
            prev = this._data[i];
        }
        return c;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToChar(this.getUnique(), Arrays.copyOfRange(this._data, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToChar) {
            MapToChar tb = (MapToChar)t;
            char[] tbb = tb._data;
            int newSize = this._data.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            char[] ret = Arrays.copyOf(this._data, newSize);
            System.arraycopy(tbb, 0, ret, this._data.length, t.size());
            return new MapToChar(newDistinct, ret);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        char[] ret = new char[p];
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToChar mm = (MapToChar)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data, 0, ret, p, ms);
            p += ms;
        }
        return new MapToChar(this.getUnique(), ret);
    }

    @Override
    public int getMaxPossible() {
        return 65535;
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToChar && e.getUnique() == this.getUnique() && Arrays.equals(((MapToChar)e)._data, this._data);
    }

    @Override
    protected void preAggregateDDC_DDCSingleCol_vec(AMapToData tm, double[] td, double[] v, int r) {
        if (tm instanceof MapToChar) {
            this.preAggregateDDC_DDCSingleCol_vecChar((MapToChar)tm, td, v, r);
        } else {
            super.preAggregateDDC_DDCSingleCol_vec(tm, td, v, r);
        }
    }

    protected final void preAggregateDDC_DDCSingleCol_vecChar(MapToChar tm, double[] td, double[] v, int r) {
        int r2 = r + 1;
        int r3 = r + 2;
        int r4 = r + 3;
        int r5 = r + 4;
        int r6 = r + 5;
        int r7 = r + 6;
        int r8 = r + 7;
        int n = this.getIndex(r);
        v[n] = v[n] + td[tm.getIndex(r)];
        int n2 = this.getIndex(r2);
        v[n2] = v[n2] + td[tm.getIndex(r2)];
        int n3 = this.getIndex(r3);
        v[n3] = v[n3] + td[tm.getIndex(r3)];
        int n4 = this.getIndex(r4);
        v[n4] = v[n4] + td[tm.getIndex(r4)];
        int n5 = this.getIndex(r5);
        v[n5] = v[n5] + td[tm.getIndex(r5)];
        int n6 = this.getIndex(r6);
        v[n6] = v[n6] + td[tm.getIndex(r6)];
        int n7 = this.getIndex(r7);
        v[n7] = v[n7] + td[tm.getIndex(r7)];
        int n8 = this.getIndex(r8);
        v[n8] = v[n8] + td[tm.getIndex(r8)];
    }
}

