/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Host2NodesMap {
    private HashMap<String, String> mapHost = new HashMap();
    private final HashMap<String, DatanodeDescriptor[]> map = new HashMap();
    private final ReadWriteLock hostmapLock = new ReentrantReadWriteLock();

    Host2NodesMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        String ipAddr = node.getIpAddr();
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(ipAddr);
            if (nodes != null) {
                for (DatanodeDescriptor containedNode : nodes) {
                    if (node != containedNode) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DatanodeDescriptor node) {
        this.hostmapLock.writeLock().lock();
        try {
            DatanodeDescriptor[] newNodes;
            if (node == null || this.contains(node)) {
                boolean bl = false;
                return bl;
            }
            String ipAddr = node.getIpAddr();
            String hostname = node.getHostName();
            this.mapHost.put(hostname, ipAddr);
            DatanodeDescriptor[] nodes = this.map.get(ipAddr);
            if (nodes == null) {
                newNodes = new DatanodeDescriptor[]{node};
            } else {
                newNodes = new DatanodeDescriptor[nodes.length + 1];
                System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                newNodes[nodes.length] = node;
            }
            this.map.put(ipAddr, newNodes);
            boolean bl = true;
            return bl;
        }
        finally {
            this.hostmapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        String ipAddr = node.getIpAddr();
        String hostname = node.getHostName();
        this.hostmapLock.writeLock().lock();
        try {
            int i;
            DatanodeDescriptor[] nodes = this.map.get(ipAddr);
            if (nodes == null) {
                boolean bl = false;
                return bl;
            }
            if (nodes.length == 1) {
                if (nodes[0] == node) {
                    this.map.remove(ipAddr);
                    this.mapHost.remove(hostname);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < nodes.length && nodes[i] != node; ++i) {
            }
            if (i == nodes.length) {
                boolean bl = false;
                return bl;
            }
            DatanodeDescriptor[] newNodes = new DatanodeDescriptor[nodes.length - 1];
            System.arraycopy(nodes, 0, newNodes, 0, i);
            System.arraycopy(nodes, i + 1, newNodes, i, nodes.length - i - 1);
            this.map.put(ipAddr, newNodes);
            boolean bl = true;
            return bl;
        }
        finally {
            this.hostmapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeDescriptor getDatanodeByHost(String ipAddr) {
        if (ipAddr == null) {
            return null;
        }
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(ipAddr);
            if (nodes == null) {
                DatanodeDescriptor datanodeDescriptor = null;
                return datanodeDescriptor;
            }
            if (nodes.length == 1) {
                DatanodeDescriptor datanodeDescriptor = nodes[0];
                return datanodeDescriptor;
            }
            DatanodeDescriptor datanodeDescriptor = nodes[ThreadLocalRandom.current().nextInt(nodes.length)];
            return datanodeDescriptor;
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeDescriptor getDatanodeByXferAddr(String ipAddr, int xferPort) {
        if (ipAddr == null) {
            return null;
        }
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(ipAddr);
            if (nodes == null) {
                DatanodeDescriptor datanodeDescriptor = null;
                return datanodeDescriptor;
            }
            for (DatanodeDescriptor containedNode : nodes) {
                if (xferPort != containedNode.getXferPort()) continue;
                DatanodeDescriptor datanodeDescriptor = containedNode;
                return datanodeDescriptor;
            }
            DatanodeDescriptor[] datanodeDescriptorArray = null;
            return datanodeDescriptorArray;
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeDescriptor getDataNodeByHostName(String hostname) {
        if (hostname == null) {
            return null;
        }
        this.hostmapLock.readLock().lock();
        try {
            String ipAddr = this.mapHost.get(hostname);
            if (ipAddr == null) {
                DatanodeDescriptor datanodeDescriptor = null;
                return datanodeDescriptor;
            }
            DatanodeDescriptor datanodeDescriptor = this.getDatanodeByHost(ipAddr);
            return datanodeDescriptor;
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("[");
        for (Map.Entry<String, String> host : this.mapHost.entrySet()) {
            DatanodeDescriptor[] e = this.map.get(host.getValue());
            b.append("\n  " + host.getKey() + " => " + host.getValue() + " => " + Arrays.asList(e));
        }
        return b.append("\n]").toString();
    }
}

