/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparse
extends ReaderColumnSelection {
    private final SparseBlock a;
    private final DblArray empty;

    protected ReaderColumnSelectionSparse(MatrixBlock data, IColIndex colIndexes, int rl, int ru) {
        super(colIndexes, rl, Math.min(ru, data.getNumRows()) - 1);
        this.a = data.getSparseBlock();
        this.empty = new DblArray(new double[colIndexes.size()]);
    }

    @Override
    protected final DblArray getNextRow() {
        ++this._rl;
        if (this.a.isEmpty(this._rl)) {
            return this.empty;
        }
        boolean zeroResult = this.processInRange(this._rl);
        if (zeroResult) {
            return this.empty;
        }
        return this.reusableReturn;
    }

    final boolean processInRange(int r) {
        boolean zeroResult = true;
        int apos = this.a.pos(r);
        int alen = this.a.size(r) + apos;
        int[] aix = this.a.indexes(r);
        double[] avals = this.a.values(r);
        int skip = 0;
        int j = Arrays.binarySearch(aix, apos, alen, this._colIndexes.get(0));
        if (j < 0) {
            j = Math.abs(j + 1);
        }
        while (skip < this._colIndexes.size() && j < alen) {
            if (this._colIndexes.get(skip) == aix[j]) {
                this.reusableArr[skip] = avals[j];
                zeroResult = false;
                ++skip;
                ++j;
                continue;
            }
            if (this._colIndexes.get(skip) > aix[j]) {
                ++j;
                continue;
            }
            this.reusableArr[skip++] = 0.0;
        }
        if (zeroResult) {
            return true;
        }
        while (skip < this._colIndexes.size()) {
            this.reusableArr[skip++] = 0.0;
        }
        return false;
    }
}

