/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform;

import java.io.Serializable;

public class TfUtils
implements Serializable {
    private static final long serialVersionUID = 526252850872633125L;
    public static final String TXMTD_MVPREFIX = "#Meta\u00b7MV";
    public static final String TXMTD_NDPREFIX = "#Meta\u00b7ND";
    public static final String TXMTD_SEP = ",";
    public static final String TXMTD_COLNAMES = "column.names";
    public static final String TXMTD_RCD_MAP_SUFFIX = ".map";
    public static final String TXMTD_RCD_DISTINCT_SUFFIX = ".ndistinct";
    public static final String TXMTD_BIN_FILE_SUFFIX = ".bin";
    public static final String TXMTD_MV_FILE_SUFFIX = ".impute";
    public static final String JSON_ATTRS = "attributes";
    public static final String JSON_MTHD = "methods";
    public static final String JSON_CONSTS = "constants";
    public static final String JSON_NBINS = "numbins";
    public static final String EXT_SPACE = "\u00b7\u2021\u00b7";
    private String[] _NAstrings = null;

    public String[] getNAStrings() {
        return this._NAstrings;
    }

    public static boolean isNA(String[] NAstrings, String w) {
        if (NAstrings == null) {
            return false;
        }
        for (String na : NAstrings) {
            if (!w.equals(na)) continue;
            return true;
        }
        return false;
    }

    public static String sanitizeSpaces(String token) {
        return token != null && token.contains(" ") ? token.replaceAll(" ", EXT_SPACE) : token;
    }

    public static String desanitizeSpaces(String token) {
        return token != null && token.contains(EXT_SPACE) ? token.replaceAll(EXT_SPACE, " ") : token;
    }

    public static enum TfMethod {
        IMPUTE,
        RECODE,
        HASH,
        BIN,
        DUMMYCODE,
        UDF,
        OMIT,
        WORD_EMBEDDING;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    protected static enum ColumnTypes {
        SCALE,
        NOMINAL,
        ORDINAL,
        DUMMYCODED;


        protected byte toID() {
            switch (this) {
                case SCALE: {
                    return 1;
                }
                case NOMINAL: {
                    return 2;
                }
                case ORDINAL: {
                    return 3;
                }
                case DUMMYCODED: {
                    return 1;
                }
            }
            throw new RuntimeException("Invalid Column Type: " + this);
        }
    }
}

