/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.context;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.package$;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SizeEstimator;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.mlcontext.MLContext;
import org.apache.sysds.api.mlcontext.MLContextUtil;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.Checkpoint;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.io.ReaderSparkCompressed;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.MatrixObjectFuture;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.data.TensorIndexes;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.spark.DeCompressionSPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.BroadcastObject;
import org.apache.sysds.runtime.instructions.spark.data.LineageObject;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.instructions.spark.functions.ComputeBinaryBlockNnzFunction;
import org.apache.sysds.runtime.instructions.spark.functions.CopyFrameBlockPairFunction;
import org.apache.sysds.runtime.instructions.spark.functions.CopyTextInputFunction;
import org.apache.sysds.runtime.instructions.spark.functions.CreateSparseBlockFunction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.InputOutputInfo;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MLContextProxy;
import org.apache.sysds.utils.Statistics;
import org.apache.sysds.utils.stats.SparkStatistics;
import scala.Tuple2;

public class SparkExecutionContext
extends ExecutionContext {
    private static final boolean LAZY_SPARKCTX_CREATION = true;
    private static final boolean ASYNCHRONOUS_VAR_DESTROY = true;
    public static final boolean FAIR_SCHEDULER_MODE = true;
    private static SparkClusterConfig _sconf = null;
    private static JavaSparkContext _spctx = null;
    private static final MemoryManagerParRDDs _parRDDs = new MemoryManagerParRDDs(0.1);
    private static boolean[] _poolBuff = new boolean[InfrastructureAnalyzer.getLocalParallelism()];
    private static boolean localSparkWarning = false;

    protected SparkExecutionContext(boolean allocateVars, boolean allocateLineage, Program prog) {
        super(allocateVars, allocateLineage, prog);
        if (DMLScript.getGlobalExecMode() == Types.ExecMode.SPARK) {
            SparkExecutionContext.initSparkContext();
        }
    }

    public JavaSparkContext getSparkContext() {
        SparkExecutionContext.initSparkContext();
        return _spctx;
    }

    public static synchronized JavaSparkContext getSparkContextStatic() {
        SparkExecutionContext.initSparkContext();
        if (_spctx.sc().isStopped()) {
            _spctx = null;
            SparkExecutionContext.initSparkContext();
        }
        return _spctx;
    }

    public static synchronized boolean isSparkContextCreated() {
        return _spctx != null;
    }

    public static void resetSparkContextStatic() {
        _spctx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<SparkExecutionContext> clazz = SparkExecutionContext.class;
        synchronized (SparkExecutionContext.class) {
            if (_spctx != null) {
                Logger spL = Logger.getLogger((String)"org.apache.spark.network.client.TransportResponseHandler");
                spL.setLevel(Level.FATAL);
                OutputStream buff = new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                };
                PrintStream old = System.err;
                System.setErr(new PrintStream(buff));
                _spctx.stop();
                _spctx = null;
                System.setErr(old);
                spL.setLevel(Level.ERROR);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isLazySparkContextCreation() {
        return true;
    }

    public static void handleIllegalReflectiveAccessSpark() {
        Module pf = Platform.class.getModule();
        Target.class.getModule().addOpens("java.nio", pf);
        Target.class.getModule().addOpens("java.io", pf);
        Module se = SizeEstimator.class.getModule();
        Target.class.getModule().addOpens("java.util", se);
        Target.class.getModule().addOpens("java.lang", se);
        Target.class.getModule().addOpens("java.lang.ref", se);
        Target.class.getModule().addOpens("java.util.concurrent", se);
    }

    private static synchronized void initSparkContext() {
        if (_spctx != null) {
            return;
        }
        SparkExecutionContext.handleIllegalReflectiveAccessSpark();
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MLContext mlCtxObj = MLContextProxy.getActiveMLContext();
        if (mlCtxObj != null) {
            _spctx = MLContextUtil.getJavaSparkContext(mlCtxObj);
        } else {
            SparkConf conf = SparkExecutionContext.createSystemDSSparkConf();
            if (DMLScript.USE_LOCAL_SPARK_CONFIG) {
                SparkExecutionContext.setLocalConfSettings(conf);
            }
            _spctx = SparkExecutionContext.createContext(conf);
            if (DMLScript.USE_LOCAL_SPARK_CONFIG) {
                _spctx.setCheckpointDir("/tmp/systemds_spark_cache_" + DMLScript.getUUID());
            }
            _parRDDs.clear();
        }
        String strDriverMaxResSize = _spctx.getConf().get("spark.driver.maxResultSize", "1g");
        long driverMaxResSize = UtilFunctions.parseMemorySize(strDriverMaxResSize);
        if (driverMaxResSize != 0L && (double)driverMaxResSize < OptimizerUtils.getLocalMemBudget() && !DMLScript.USE_LOCAL_SPARK_CONFIG) {
            LOG.warn((Object)("Configuration parameter spark.driver.maxResultSize set to " + UtilFunctions.formatMemorySize(driverMaxResSize) + ". You can set it through Spark default configuration setting either to 0 (unlimited) or to available memory budget of size " + UtilFunctions.formatMemorySize((long)OptimizerUtils.getLocalMemBudget()) + "."));
        }
        HDFSTool.addBinaryBlockSerializationFramework(_spctx.hadoopConfiguration());
        if (DMLScript.STATISTICS) {
            SparkStatistics.setCtxCreateTime(System.nanoTime() - t0);
        }
    }

    private static JavaSparkContext createContext(SparkConf conf) {
        try {
            return new JavaSparkContext(conf);
        }
        catch (Exception e) {
            if (e.getMessage().contains("A master URL must be set in your configuration")) {
                if (!localSparkWarning) {
                    LOG.warn((Object)"Error constructing Spark Context, falling back to local Spark context creation");
                    localSparkWarning = true;
                }
                SparkExecutionContext.setLocalConfSettings(conf);
                return SparkExecutionContext.createContext(conf);
            }
            throw new DMLException("Error while creating Spark context", e);
        }
    }

    private static void setLocalConfSettings(SparkConf conf) {
        String threads = ConfigurationManager.getDMLConfig().getTextValue("sysds.local.spark.number.threads");
        conf.setMaster("local[" + threads + "]");
        conf.setAppName("LocalSparkContextApp");
        conf.set("spark.ui.showConsoleProgress", "false");
        conf.set("spark.ui.enabled", "false");
    }

    public static SparkConf createSystemDSSparkConf() {
        String sparkVersion;
        String msgSizeConf;
        SparkConf conf = new SparkConf();
        conf.set("spark.driver.maxResultSize", "0");
        conf.set("spark.scheduler.mode", "FAIR");
        if (!conf.contains("spark.locality.wait")) {
            conf.set("spark.locality.wait", "5s");
        }
        String string = msgSizeConf = UtilFunctions.compareVersion(sparkVersion = package$.MODULE$.SPARK_VERSION(), "2.0.0") < 0 ? "spark.akka.frameSize" : "spark.rpc.message.maxSize";
        if (!conf.contains(msgSizeConf)) {
            conf.set(msgSizeConf, "512");
        }
        return conf;
    }

    public static boolean isLocalMaster() {
        return SparkExecutionContext.getSparkContextStatic().isLocal();
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryMatrixBlockRDDHandleForVariable(String varname) {
        MatrixObject mo = this.getMatrixObject(varname);
        return this.getRDDHandleForMatrixObject(mo, Types.FileFormat.BINARY, -1, true);
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryMatrixBlockRDDHandleForVariable(String varname, int numParts, boolean inclEmpty) {
        MatrixObject mo = this.getMatrixObject(varname);
        return this.getRDDHandleForMatrixObject(mo, Types.FileFormat.BINARY, numParts, inclEmpty);
    }

    public JavaPairRDD<TensorIndexes, TensorBlock> getBinaryTensorBlockRDDHandleForVariable(String varname) {
        TensorObject to = this.getTensorObject(varname);
        return this.getRDDHandleForTensorObject(to, Types.FileFormat.BINARY, -1, true);
    }

    public JavaPairRDD<TensorIndexes, TensorBlock> getBinaryTensorBlockRDDHandleForVariable(String varname, int numParts, boolean inclEmpty) {
        TensorObject to = this.getTensorObject(varname);
        return this.getRDDHandleForTensorObject(to, Types.FileFormat.BINARY, numParts, inclEmpty);
    }

    public JavaPairRDD<Long, FrameBlock> getFrameBinaryBlockRDDHandleForVariable(String varname) {
        FrameObject fo = this.getFrameObject(varname);
        JavaPairRDD<Long, FrameBlock> out = this.getRDDHandleForFrameObject(fo, Types.FileFormat.BINARY);
        return out;
    }

    public JavaPairRDD<?, ?> getRDDHandleForVariable(String varname, Types.FileFormat fmt, int numParts, boolean inclEmpty) {
        Data dat = this.getVariable(varname);
        if (dat instanceof MatrixObject) {
            MatrixObject mo = this.getMatrixObject(varname);
            return this.getRDDHandleForMatrixObject(mo, fmt, numParts, inclEmpty);
        }
        if (dat instanceof FrameObject) {
            FrameObject fo = this.getFrameObject(varname);
            return this.getRDDHandleForFrameObject(fo, fmt);
        }
        throw new DMLRuntimeException("Failed to obtain RDD for data type other than matrix or frame.");
    }

    public JavaPairRDD<?, ?> getRDDHandleForMatrixObject(MatrixObject mo, Types.FileFormat fmt) {
        return this.getRDDHandleForMatrixObject(mo, fmt, -1, true);
    }

    public JavaPairRDD<?, ?> getRDDHandleForMatrixObject(MatrixObject mo, Types.FileFormat fmt, int numParts, boolean inclEmpty) {
        JavaSparkContext sc = this.getSparkContext();
        JavaPairRDD<Object, Object> rdd = null;
        InputOutputInfo inputInfo = InputOutputInfo.get(Types.DataType.MATRIX, fmt);
        if (mo.getRDDHandle() != null && (mo.getRDDHandle().isCheckpointRDD() || !mo.isCached(false))) {
            rdd = mo.getRDDHandle().getRDD();
        } else if (mo.isDirty() || mo.isCached(false) || mo.isFederated() || mo instanceof MatrixObjectFuture) {
            DataCharacteristics dc = mo.getDataCharacteristics();
            boolean fromFile = false;
            if (!(mo.isFederated() || mo instanceof MatrixObjectFuture || OptimizerUtils.checkSparkCollectMemoryBudget(dc, 0L) && _parRDDs.reserve(OptimizerUtils.estimatePartitionedSizeExactSparsity(dc)))) {
                if (mo.isDirty() || !mo.isHDFSFileExists()) {
                    mo.exportData();
                }
                rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.keyClass, inputInfo.valueClass);
                rdd = SparkUtils.copyBinaryBlockMatrix(rdd);
                fromFile = true;
            } else {
                MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                rdd = SparkExecutionContext.toMatrixJavaPairRDD(sc, mb, mo.getBlocksize(), numParts, inclEmpty);
                mo.release();
                _parRDDs.registerRDD(rdd.id(), OptimizerUtils.estimatePartitionedSizeExactSparsity(dc), true);
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(fromFile);
            rddhandle.setParallelizedRDD(!fromFile);
            mo.setRDDHandle(rddhandle);
        } else {
            rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.keyClass, inputInfo.valueClass);
            if (fmt == Types.FileFormat.BINARY) {
                rdd = SparkUtils.copyBinaryBlockMatrix(rdd);
            } else if (fmt == Types.FileFormat.COMPRESSED) {
                rdd = ReaderSparkCompressed.getRDD(sc, mo.getFileName());
            } else if (fmt.isTextFormat()) {
                JavaPairRDD<LongWritable, Text> textRDD = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, LongWritable.class, Text.class);
                rdd = textRDD.mapToPair(new CopyTextInputFunction());
            } else {
                throw new DMLRuntimeException("Incorrect input format in getRDDHandleForVariable");
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(true);
            mo.setRDDHandle(rddhandle);
        }
        return rdd;
    }

    public JavaPairRDD<?, ?> getRDDHandleForTensorObject(TensorObject to, Types.FileFormat fmt, int numParts, boolean inclEmpty) {
        JavaPairRDD<Object, Object> rdd;
        JavaSparkContext sc = this.getSparkContext();
        if (to.getRDDHandle() != null && (to.getRDDHandle().isCheckpointRDD() || !to.isCached(false))) {
            rdd = to.getRDDHandle().getRDD();
        } else if (to.isDirty() || to.isCached(false)) {
            DataCharacteristics dc = to.getDataCharacteristics();
            if (!OptimizerUtils.checkSparkCollectMemoryBudget(dc, 0L) || !_parRDDs.reserve(OptimizerUtils.estimatePartitionedSizeExactSparsity(dc))) {
                if (to.isDirty() || !to.isHDFSFileExists()) {
                    to.exportData();
                }
                throw new DMLRuntimeException("Tensor can not yet be written or read to hadoopFile");
            }
            TensorBlock tb = (TensorBlock)to.acquireRead();
            int blen = dc.getBlocksize();
            rdd = SparkExecutionContext.toTensorJavaPairRDD(sc, tb, blen, numParts, inclEmpty);
            to.release();
            _parRDDs.registerRDD(rdd.id(), OptimizerUtils.estimatePartitionedSizeExactSparsity(dc), true);
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(false);
            rddhandle.setParallelizedRDD(true);
            to.setRDDHandle(rddhandle);
        } else {
            if (fmt == Types.FileFormat.BINARY) {
                throw new DMLRuntimeException("Tensor can not yet be written or read to hadoopFile");
            }
            throw new DMLRuntimeException("Incorrect input format in getRDDHandleForVariable");
        }
        return rdd;
    }

    public JavaPairRDD<?, ?> getRDDHandleForFrameObject(FrameObject fo, Types.FileFormat fmt) {
        InputOutputInfo inputInfo2 = InputOutputInfo.get(Types.DataType.FRAME, fmt);
        JavaSparkContext sc = this.getSparkContext();
        JavaPairRDD<Object, Object> rdd = null;
        if (fo.getRDDHandle() != null && (fo.getRDDHandle().isCheckpointRDD() || !fo.isCached(false))) {
            rdd = fo.getRDDHandle().getRDD();
        } else if (fo.isDirty() || fo.isCached(false)) {
            DataCharacteristics dc = fo.getDataCharacteristics();
            boolean fromFile = false;
            if (!OptimizerUtils.checkSparkCollectMemoryBudget(dc, 0L) || !_parRDDs.reserve(OptimizerUtils.estimatePartitionedSizeExactSparsity(dc))) {
                if (fo.isDirty()) {
                    fo.exportData();
                }
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.keyClass, inputInfo2.valueClass);
                rdd = rdd.mapToPair(new CopyFrameBlockPairFunction());
                fromFile = true;
            } else {
                FrameBlock fb = (FrameBlock)fo.acquireRead();
                rdd = SparkExecutionContext.toFrameJavaPairRDD(sc, fb);
                fo.release();
                _parRDDs.registerRDD(rdd.id(), OptimizerUtils.estimatePartitionedSizeExactSparsity(dc), true);
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(fromFile);
            fo.setRDDHandle(rddhandle);
        } else {
            if (fmt == Types.FileFormat.BINARY) {
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.keyClass, inputInfo2.valueClass);
                rdd = rdd.mapToPair(new CopyFrameBlockPairFunction());
            } else if (fmt.isTextFormat()) {
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.keyClass, inputInfo2.valueClass);
                rdd = rdd.mapToPair(new CopyTextInputFunction());
            } else {
                throw new DMLRuntimeException("Incorrect input format in getRDDHandleForVariable");
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(true);
            fo.setRDDHandle(rddhandle);
        }
        return rdd;
    }

    public Broadcast<CacheBlock<?>> broadcastVariable(CacheableData<CacheBlock<?>> cd) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        Broadcast<CacheBlock<?>> brBlock = null;
        if (cd.getBroadcastHandle() != null && cd.getBroadcastHandle().isNonPartitionedBroadcastValid()) {
            brBlock = cd.getBroadcastHandle().getNonPartitionedBroadcast();
        }
        if (brBlock == null) {
            if (cd.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-cd.getBroadcastHandle().getSize());
            }
            CacheBlock<?> cb = cd.acquireRead();
            cd.release();
            if (cb.getExactSerializedSize() > 0L && cb.getExactSerializedSize() <= Integer.MAX_VALUE) {
                brBlock = this.getSparkContext().broadcast(cb);
                if (cd.getBroadcastHandle() == null) {
                    cd.setBroadcastHandle(new BroadcastObject());
                }
                cd.getBroadcastHandle().setNonPartitionedBroadcast(brBlock, OptimizerUtils.estimateSize(cd.getDataCharacteristics()));
                CacheableData.addBroadcastSize(cd.getBroadcastHandle().getSize());
                if (DMLScript.STATISTICS) {
                    SparkStatistics.accBroadCastTime(System.nanoTime() - t0);
                    SparkStatistics.incBroadcastCount(1L);
                }
            }
        }
        return brBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionedBroadcast<MatrixBlock> getBroadcastForMatrixObject(MatrixObject mo) {
        PartitionedBroadcast bret = null;
        MatrixObject matrixObject = mo;
        synchronized (matrixObject) {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (mo.getBroadcastHandle() != null && mo.getBroadcastHandle().isPartitionedBroadcastValid()) {
                bret = mo.getBroadcastHandle().getPartitionedBroadcast();
            }
            if (bret == null) {
                if (mo.getBroadcastHandle() != null) {
                    CacheableData.addBroadcastSize(-mo.getBroadcastHandle().getSize());
                }
                int blen = mo.getBlocksize();
                MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                PartitionedBlock<MatrixBlock> pmb = new PartitionedBlock<MatrixBlock>(mb, blen);
                mo.release();
                int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(mo.getNumRows(), mo.getNumColumns(), blen);
                int numParts = (int)Math.ceil((double)pmb.getNumRowBlocks() * (double)pmb.getNumColumnBlocks() / (double)numPerPart);
                Broadcast[] ret = new Broadcast[numParts];
                if (numParts > 1) {
                    Arrays.parallelSetAll(ret, i -> this.createPartitionedBroadcast(pmb, numPerPart, i));
                } else {
                    ret[0] = this.getSparkContext().broadcast(pmb);
                    if (!SparkExecutionContext.isLocalMaster()) {
                        pmb.clearBlocks();
                    }
                }
                bret = new PartitionedBroadcast(ret, mo.getDataCharacteristics());
                if (mo.getBroadcastHandle() == null) {
                    mo.setBroadcastHandle(new BroadcastObject());
                }
                mo.getBroadcastHandle().setPartitionedBroadcast(bret, OptimizerUtils.estimatePartitionedSizeExactSparsity(mo.getDataCharacteristics()));
                CacheableData.addBroadcastSize(mo.getBroadcastHandle().getSize());
            }
            if (DMLScript.STATISTICS) {
                SparkStatistics.accBroadCastTime(System.nanoTime() - t0);
                SparkStatistics.incBroadcastCount(1L);
            }
        }
        return bret;
    }

    public void setBroadcastHandle(MatrixObject mo) {
        this.getBroadcastForMatrixObject(mo);
    }

    public PartitionedBroadcast<TensorBlock> getBroadcastForTensorObject(TensorObject to) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        PartitionedBroadcast bret = null;
        if (to.getBroadcastHandle() != null && to.getBroadcastHandle().isPartitionedBroadcastValid()) {
            bret = to.getBroadcastHandle().getPartitionedBroadcast();
        }
        if (bret == null) {
            if (to.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-to.getBroadcastHandle().getSize());
            }
            DataCharacteristics dc = to.getDataCharacteristics();
            long[] dims = dc.getDims();
            int blen = dc.getBlocksize();
            PartitionedBlock<TensorBlock> pmb = new PartitionedBlock<TensorBlock>((TensorBlock)to.acquireReadAndRelease(), dims, blen);
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(dims, blen);
            int numParts = (int)Math.ceil((double)pmb.getNumRowBlocks() * (double)pmb.getNumColumnBlocks() / (double)numPerPart);
            Broadcast[] ret = new Broadcast[numParts];
            if (numParts > 1) {
                Arrays.parallelSetAll(ret, i -> this.createPartitionedBroadcast(pmb, numPerPart, i));
            } else {
                ret[0] = this.getSparkContext().broadcast(pmb);
                if (!SparkExecutionContext.isLocalMaster()) {
                    pmb.clearBlocks();
                }
            }
            bret = new PartitionedBroadcast(ret, to.getDataCharacteristics());
            if (to.getBroadcastHandle() == null) {
                to.setBroadcastHandle(new BroadcastObject());
            }
            to.getBroadcastHandle().setPartitionedBroadcast(bret, OptimizerUtils.estimatePartitionedSizeExactSparsity(to.getDataCharacteristics()));
            CacheableData.addBroadcastSize(to.getBroadcastHandle().getSize());
            if (DMLScript.STATISTICS) {
                SparkStatistics.accBroadCastTime(System.nanoTime() - t0);
                SparkStatistics.incBroadcastCount(1L);
            }
        }
        return bret;
    }

    public PartitionedBroadcast<MatrixBlock> getBroadcastForVariable(String varname) {
        return this.getBroadcastForMatrixObject(this.getMatrixObject(varname));
    }

    public PartitionedBroadcast<TensorBlock> getBroadcastForTensorVariable(String varname) {
        return this.getBroadcastForTensorObject(this.getTensorObject(varname));
    }

    public PartitionedBroadcast<FrameBlock> getBroadcastForFrameVariable(String varname) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        FrameObject fo = this.getFrameObject(varname);
        PartitionedBroadcast bret = null;
        if (fo.getBroadcastHandle() != null && fo.getBroadcastHandle().isPartitionedBroadcastValid()) {
            bret = fo.getBroadcastHandle().getPartitionedBroadcast();
        }
        if (bret == null) {
            if (fo.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-fo.getBroadcastHandle().getSize());
            }
            int blen = OptimizerUtils.getDefaultFrameSize();
            FrameBlock mb = (FrameBlock)fo.acquireRead();
            PartitionedBlock<FrameBlock> pmb = new PartitionedBlock<FrameBlock>(mb, blen);
            fo.release();
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(fo.getNumRows(), fo.getNumColumns(), blen);
            int numParts = (int)Math.ceil((double)pmb.getNumRowBlocks() * (double)pmb.getNumColumnBlocks() / (double)numPerPart);
            Broadcast[] ret = new Broadcast[numParts];
            if (numParts > 1) {
                Arrays.parallelSetAll(ret, i -> this.createPartitionedBroadcast(pmb, numPerPart, i));
            } else {
                ret[0] = this.getSparkContext().broadcast(pmb);
                if (!SparkExecutionContext.isLocalMaster()) {
                    pmb.clearBlocks();
                }
            }
            bret = new PartitionedBroadcast(ret, new MatrixCharacteristics(fo.getDataCharacteristics()).setBlocksize(blen));
            if (fo.getBroadcastHandle() == null) {
                fo.setBroadcastHandle(new BroadcastObject());
            }
            fo.getBroadcastHandle().setPartitionedBroadcast(bret, OptimizerUtils.estimatePartitionedSizeExactSparsity(fo.getDataCharacteristics()));
            CacheableData.addBroadcastSize(fo.getBroadcastHandle().getSize());
            if (DMLScript.STATISTICS) {
                SparkStatistics.accBroadCastTime(System.nanoTime() - t0);
                SparkStatistics.incBroadcastCount(1L);
            }
        }
        return bret;
    }

    private Broadcast<PartitionedBlock<? extends CacheBlock<?>>> createPartitionedBroadcast(PartitionedBlock<? extends CacheBlock<?>> pmb, int numPerPart, int pos) {
        int offset = pos * numPerPart;
        int numBlks = Math.min(numPerPart, pmb.getNumRowBlocks() * pmb.getNumColumnBlocks() - offset);
        PartitionedBlock<CacheBlock<?>> tmp = pmb.createPartition(offset, numBlks);
        Broadcast<PartitionedBlock<? extends CacheBlock<?>>> ret = this.getSparkContext().broadcast(tmp);
        if (!SparkExecutionContext.isLocalMaster()) {
            tmp.clearBlocks();
        }
        return ret;
    }

    public void setRDDHandleForVariable(String varname, JavaPairRDD<?, ?> rdd) {
        CacheableData<?> obj = this.getCacheableData(varname);
        RDDObject rddhandle = new RDDObject(rdd);
        obj.setRDDHandle(rddhandle);
    }

    public void setRDDHandleForVariable(String varname, RDDObject rddhandle) {
        CacheableData<?> obj = this.getCacheableData(varname);
        obj.setRDDHandle(rddhandle);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> toMatrixJavaPairRDD(JavaSparkContext sc, MatrixBlock src, int blen) {
        return SparkExecutionContext.toMatrixJavaPairRDD(sc, src, blen, -1, true);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> toMatrixJavaPairRDD(JavaSparkContext sc, MatrixBlock src, int blen, int numParts, boolean inclEmpty) {
        JavaPairRDD<MatrixIndexes, MatrixBlock> result;
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        List<Object> list = null;
        if (src.getNumRows() <= blen && src.getNumColumns() <= blen) {
            list = Arrays.asList(new Tuple2((Object)new MatrixIndexes(1L, 1L), (Object)src));
        } else {
            MatrixCharacteristics mc = new MatrixCharacteristics(src.getNumRows(), src.getNumColumns(), blen, src.getNonZeros());
            list = LongStream.range(0L, mc.getNumBlocks()).parallel().mapToObj(i -> SparkExecutionContext.createIndexedMatrixBlock(src, mc, i)).filter(kv -> inclEmpty || !((MatrixBlock)kv._2).isEmptyBlock(false)).collect(Collectors.toList());
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> javaPairRDD = result = numParts > 1 ? sc.parallelizePairs(list, numParts) : sc.parallelizePairs(list);
        if (DMLScript.STATISTICS) {
            SparkStatistics.accParallelizeTime(System.nanoTime() - t0);
            SparkStatistics.incParallelizeCount(1L);
        }
        return result;
    }

    public static JavaPairRDD<TensorIndexes, TensorBlock> toTensorJavaPairRDD(JavaSparkContext sc, TensorBlock src, int blen) {
        return SparkExecutionContext.toTensorJavaPairRDD(sc, src, blen, -1, true);
    }

    public static JavaPairRDD<TensorIndexes, TensorBlock> toTensorJavaPairRDD(JavaSparkContext sc, TensorBlock src, int blen, int numParts, boolean inclEmpty) {
        JavaPairRDD<TensorIndexes, TensorBlock> result;
        List list;
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        int numDims = src.getNumDims();
        boolean singleBlock = true;
        for (int i2 = 0; i2 < numDims; ++i2) {
            if (blen <= src.getDim(i2)) continue;
            singleBlock = false;
            break;
        }
        if (singleBlock) {
            long[] ix = new long[numDims];
            Arrays.fill(ix, 1L);
            list = Arrays.asList(new Tuple2((Object)new TensorIndexes(ix), (Object)src));
        } else {
            long[] dims = src.getLongDims();
            TensorCharacteristics mc = new TensorCharacteristics(dims, src.getNonZeros());
            list = LongStream.range(0L, mc.getNumBlocks()).parallel().mapToObj(i -> SparkExecutionContext.createIndexedTensorBlock(src, mc, i)).filter(kv -> inclEmpty || !((TensorBlock)kv._2).isEmpty(false)).collect(Collectors.toList());
        }
        JavaPairRDD<TensorIndexes, TensorBlock> javaPairRDD = result = numParts > 1 ? sc.parallelizePairs(list, numParts) : sc.parallelizePairs(list);
        if (DMLScript.STATISTICS) {
            SparkStatistics.accParallelizeTime(System.nanoTime() - t0);
            SparkStatistics.incParallelizeCount(1L);
        }
        return result;
    }

    private static Tuple2<MatrixIndexes, MatrixBlock> createIndexedMatrixBlock(MatrixBlock mb, MatrixCharacteristics mc, long ix) {
        try {
            long blockRow = ix / mc.getNumColBlocks();
            long blockCol = ix % mc.getNumColBlocks();
            int maxRow = UtilFunctions.computeBlockSize(mc.getRows(), blockRow + 1L, mc.getBlocksize());
            int maxCol = UtilFunctions.computeBlockSize(mc.getCols(), blockCol + 1L, mc.getBlocksize());
            MatrixBlock block = new MatrixBlock(maxRow, maxCol, mb.isInSparseFormat());
            int row_offset = (int)blockRow * mc.getBlocksize();
            int col_offset = (int)blockCol * mc.getBlocksize();
            block = mb.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, false, block);
            return new Tuple2((Object)new MatrixIndexes(blockRow + 1L, blockCol + 1L), (Object)block);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Tuple2<TensorIndexes, TensorBlock> createIndexedTensorBlock(TensorBlock mb, TensorCharacteristics tc, long ix) {
        try {
            long[] blockIx = UtilFunctions.computeTensorIndexes(tc, ix);
            int[] outDims = new int[tc.getNumDims()];
            int[] offset = new int[tc.getNumDims()];
            UtilFunctions.computeSliceInfo(tc, blockIx, outDims, offset);
            TensorBlock outBlock = new TensorBlock(mb.getValueType(), outDims);
            outBlock = mb.slice(offset, outBlock);
            return new Tuple2((Object)new TensorIndexes(blockIx), (Object)outBlock);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JavaPairRDD<Long, FrameBlock> toFrameJavaPairRDD(JavaSparkContext sc, FrameBlock src) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        LinkedList list = new LinkedList();
        int blksize = ConfigurationManager.getBlocksize();
        for (int blockRow = 0; blockRow < (int)Math.ceil((double)src.getNumRows() / (double)blksize); ++blockRow) {
            int maxRow = blockRow * blksize + blksize < src.getNumRows() ? blksize : src.getNumRows() - blockRow * blksize;
            int roffset = blockRow * blksize;
            FrameBlock block = new FrameBlock(src.getSchema());
            src.slice(roffset, roffset + maxRow - 1, 0, src.getNumColumns() - 1, block);
            if (roffset == 0) {
                block.setColumnMetadata(src.getColumnMetadata());
            }
            list.addLast(new Tuple2((Object)((long)roffset + 1L), (Object)block));
        }
        JavaPairRDD<Long, FrameBlock> result = sc.parallelizePairs(list);
        if (DMLScript.STATISTICS) {
            SparkStatistics.accParallelizeTime(System.nanoTime() - t0);
            SparkStatistics.incParallelizeCount(1L);
        }
        return result;
    }

    public static MatrixBlock toMatrixBlock(RDDObject rdd, int rlen, int clen, int blen, long nnz) {
        return SparkExecutionContext.toMatrixBlock(rdd.getRDD(), rlen, clen, blen, nnz);
    }

    public static MatrixBlock toMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen, int blen, long nnz) {
        MatrixBlock out;
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        Boolean singleBlock = rlen <= blen && clen <= blen;
        MatrixBlock matrixBlock = out = singleBlock != false ? SparkExecutionContext.toMatrixBlockSingleBlock(rdd, rlen, clen) : SparkExecutionContext.toMatrixBlockMultiBlock(rdd, rlen, clen, blen, nnz);
        if (DMLScript.STATISTICS) {
            SparkStatistics.accCollectTime(System.nanoTime() - t0);
        }
        return out;
    }

    private static MatrixBlock toMatrixBlockSingleBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen) {
        List list = rdd.collect();
        if (list.size() > 1) {
            throw new DMLRuntimeException("Expecting no more than one result block but got: " + list.size());
        }
        MatrixBlock out = list.size() == 1 ? (MatrixBlock)((Tuple2)list.get(0))._2() : new MatrixBlock(rlen, clen, true);
        out.examSparsity();
        return out;
    }

    private static MatrixBlock toMatrixBlockMultiBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen, int blen, long nnz) {
        long lnnz = nnz >= 0L ? nnz : (long)rlen * (long)clen;
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, lnnz);
        MatrixBlock out = new MatrixBlock(rlen, clen, sparse, lnnz);
        Future<MatrixBlock> fout = out.allocateBlockAsync();
        List<Tuple2<MatrixIndexes, MatrixBlock>> list = rdd.collect();
        out = IOUtilFunctions.get(fout);
        LongAdder aNnz = new LongAdder();
        SparkExecutionContext.blockPartitionsToMatrixBlock(list, out, aNnz, blen);
        if (sparse) {
            out.sortSparseRows();
        }
        if (SparkExecutionContext.containsCompressedMatrixBlock(list)) {
            out.recomputeNonZeros();
        } else {
            out.setNonZeros(aNnz.longValue());
        }
        out.examSparsity();
        return out;
    }

    private static boolean containsCompressedMatrixBlock(List<Tuple2<MatrixIndexes, MatrixBlock>> list) {
        for (Tuple2<MatrixIndexes, MatrixBlock> t : list) {
            if (!(t._2() instanceof CompressedMatrixBlock)) continue;
            return true;
        }
        return false;
    }

    private static void blockPartitionsToMatrixBlock(List<Tuple2<MatrixIndexes, MatrixBlock>> tuples, MatrixBlock out, LongAdder aNnz, int blen) {
        if (out.isInSparseFormat()) {
            SparkExecutionContext.blockPartitionsToMatrixBlockSingleThread(tuples, out, aNnz, blen);
        } else {
            SparkExecutionContext.blockPartitionsToMatrixBlockMultiThreaded(tuples, out, aNnz, blen);
        }
    }

    private static void blockPartitionsToMatrixBlockSingleThread(List<Tuple2<MatrixIndexes, MatrixBlock>> tuples, MatrixBlock out, LongAdder aNnz, int blen) {
        boolean sparse = out.isInSparseFormat();
        boolean sparseCopyShallow = sparse && out.getNumColumns() <= blen;
        for (Tuple2<MatrixIndexes, MatrixBlock> tuple : tuples) {
            SparkExecutionContext.blockPartitionToMatrixBlock(tuple, out, aNnz, blen, sparseCopyShallow);
        }
    }

    private static void blockPartitionsToMatrixBlockMultiThreaded(List<Tuple2<MatrixIndexes, MatrixBlock>> tuples, MatrixBlock out, LongAdder aNnz, int blen) {
        try {
            int k = InfrastructureAnalyzer.getLocalParallelism();
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<BlockPartitionToMatrixBlockTask> tasks = new ArrayList<BlockPartitionToMatrixBlockTask>();
            int tSize = tuples.size();
            int blockSize = Math.max(tSize / k / 2, 1);
            for (int i = 0; i < tSize; i += blockSize) {
                tasks.add(new BlockPartitionToMatrixBlockTask(tuples, i, Math.min(i + blockSize, tSize), out, aNnz, blen, false));
            }
            for (Future f : pool.invokeAll(tasks)) {
                f.get();
            }
            pool.shutdown();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new DMLRuntimeException("Parallel block partitions to matrix block failed", ex);
        }
    }

    private static void blockPartitionToMatrixBlock(Tuple2<MatrixIndexes, MatrixBlock> tuple, MatrixBlock out, LongAdder aNnz, int blen, boolean sparseCopyShallow) {
        MatrixIndexes ix = (MatrixIndexes)tuple._1();
        MatrixBlock block = (MatrixBlock)tuple._2();
        int row_offset = (int)(ix.getRowIndex() - 1L) * blen;
        int col_offset = (int)(ix.getColumnIndex() - 1L) * blen;
        block.putInto(out, row_offset, col_offset, sparseCopyShallow);
        aNnz.add(block.getNonZeros());
    }

    public static MatrixBlock toMatrixBlock(RDDObject rdd, int rlen, int clen, long nnz) {
        return SparkExecutionContext.toMatrixBlock(rdd.getRDD(), rlen, clen, nnz);
    }

    public static MatrixBlock toMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixCell> rdd, int rlen, int clen, long nnz) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock out = null;
        long lnnz = nnz >= 0L ? nnz : (long)rlen * (long)clen;
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, lnnz);
        out = new MatrixBlock(rlen, clen, sparse);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            MatrixIndexes ix = (MatrixIndexes)keyval._1();
            MatrixCell cell = (MatrixCell)keyval._2();
            out.appendValue((int)ix.getRowIndex() - 1, (int)ix.getColumnIndex() - 1, cell.getValue());
        }
        if (sparse) {
            out.sortSparseRows();
        }
        out.recomputeNonZeros();
        out.examSparsity();
        if (DMLScript.STATISTICS) {
            SparkStatistics.accCollectTime(System.nanoTime() - t0);
        }
        return out;
    }

    public static TensorBlock toTensorBlock(JavaPairRDD<TensorIndexes, TensorBlock> rdd, DataCharacteristics dc) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        int[] idims = dc.getIntDims();
        List list = rdd.collect();
        Types.ValueType vt = ((TensorBlock)((Tuple2)list.get((int)0))._2).getValueType();
        TensorBlock out = new TensorBlock(vt, idims).allocateBlock();
        for (Tuple2 keyval : list) {
            int i;
            TensorIndexes ix = (TensorIndexes)keyval._1();
            TensorBlock block = (TensorBlock)keyval._2();
            int[] lower = new int[ix.getNumDims()];
            int[] upper = new int[ix.getNumDims()];
            for (i = 0; i < lower.length; ++i) {
                lower[i] = (int)((ix.getIndex(i) - 1L) * (long)dc.getBlocksize());
                upper[i] = lower[i] + block.getDim(i) - 1;
            }
            int n = upper.length - 1;
            upper[n] = upper[n] + 1;
            for (i = upper.length - 1; i > 0; --i) {
                if (upper[i] != block.getDim(i)) continue;
                upper[i] = 0;
                int n2 = i - 1;
                upper[n2] = upper[n2] + 1;
            }
            out.copy(lower, upper, block);
        }
        if (DMLScript.STATISTICS) {
            SparkStatistics.accCollectTime(System.nanoTime() - t0);
        }
        return out;
    }

    public static PartitionedBlock<MatrixBlock> toPartitionedMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen, int blen, long nnz) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        PartitionedBlock<MatrixBlock> out = new PartitionedBlock<MatrixBlock>(rlen, clen, blen);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            MatrixIndexes ix = (MatrixIndexes)keyval._1();
            MatrixBlock block = (MatrixBlock)keyval._2();
            out.setBlock((int)ix.getRowIndex(), (int)ix.getColumnIndex(), block);
        }
        if (DMLScript.STATISTICS) {
            SparkStatistics.accCollectTime(System.nanoTime() - t0);
        }
        return out;
    }

    public static FrameBlock toFrameBlock(RDDObject rdd, Types.ValueType[] schema, int rlen, int clen) {
        JavaPairRDD<Long, FrameBlock> lrdd = rdd.getRDD();
        return SparkExecutionContext.toFrameBlock(lrdd, schema, rlen, clen);
    }

    public static FrameBlock toFrameBlock(JavaPairRDD<Long, FrameBlock> rdd, Types.ValueType[] schema, int rlen, int clen) {
        long t0;
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (schema == null) {
            schema = UtilFunctions.nCopies(clen, Types.ValueType.STRING);
        }
        FrameBlock out = new FrameBlock(schema, rlen);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            int ix = (int)((Long)keyval._1() - 1L);
            FrameBlock block = (FrameBlock)keyval._2();
            out.copy(ix, ix + block.getNumRows() - 1, 0, block.getNumColumns() - 1, block);
            if (ix != 0) continue;
            out.setColumnNames(block.getColumnNames());
            out.setColumnMetadata(block.getColumnMetadata());
        }
        if (DMLScript.STATISTICS) {
            SparkStatistics.accCollectTime(System.nanoTime() - t0);
        }
        return out;
    }

    public static long writeMatrixRDDtoHDFS(RDDObject rdd, String path, Types.FileFormat fmt) {
        JavaPairRDD<? extends Writable, Object> lrdd = rdd.getRDD();
        InputOutputInfo oinfo = InputOutputInfo.get(Types.DataType.MATRIX, fmt);
        if (ConfigurationManager.isCompressionEnabled()) {
            lrdd = lrdd.mapValues(new DeCompressionSPInstruction.DeCompressionFunction());
        }
        LongAccumulator aNnz = SparkExecutionContext.getSparkContextStatic().sc().longAccumulator("nnz");
        lrdd = lrdd.mapValues(new ComputeBinaryBlockNnzFunction(aNnz));
        lrdd.saveAsHadoopFile(path, oinfo.keyClass, oinfo.valueClass, oinfo.outputFormatClass);
        return aNnz.value();
    }

    public static void writeFrameRDDtoHDFS(RDDObject rdd, String path, Types.FileFormat fmt) {
        JavaPairRDD<Object, Object> lrdd = rdd.getRDD();
        InputOutputInfo oinfo = InputOutputInfo.get(Types.DataType.FRAME, fmt);
        if (fmt == Types.FileFormat.BINARY) {
            lrdd = lrdd.mapToPair(new FrameRDDConverterUtils.LongFrameToLongWritableFrameFunction());
        }
        lrdd.saveAsHadoopFile(path, oinfo.keyClass, oinfo.valueClass, oinfo.outputFormatClass);
    }

    public void addLineageRDD(String varParent, String varChild) {
        RDDObject parent = this.getCacheableData(varParent).getRDDHandle();
        RDDObject child = this.getCacheableData(varChild).getRDDHandle();
        parent.addLineageChild(child);
    }

    public void addLineageBroadcast(String varParent, String varChild) {
        RDDObject parent = this.getCacheableData(varParent).getRDDHandle();
        BroadcastObject<?> child = this.getCacheableData(varChild).getBroadcastHandle();
        parent.addLineageChild(child);
    }

    public void addLineage(String varParent, String varChild, boolean broadcast) {
        if (broadcast) {
            this.addLineageBroadcast(varParent, varChild);
        } else {
            this.addLineageRDD(varParent, varChild);
        }
    }

    @Override
    public void cleanupCacheableData(CacheableData<?> mo) {
        if (DMLScript.JMLC_MEM_STATISTICS) {
            Statistics.removeCPMemObject(System.identityHashCode(mo));
        }
        if (!mo.isCleanupEnabled()) {
            return;
        }
        try {
            if (!this.getVariables().hasReferences(mo)) {
                mo.clearData(this.getTID());
                if (mo.isHDFSFileExists() && mo.getFileName() != null) {
                    if (mo.getRDDHandle() == null) {
                        HDFSTool.deleteFileWithMTDIfExistOnHDFS(mo.getFileName());
                    } else {
                        RDDObject rdd = mo.getRDDHandle();
                        rdd.setHDFSFilename(mo.getFileName());
                    }
                }
                if (mo.getRDDHandle() != null) {
                    this.rCleanupLineageObject(mo.getRDDHandle());
                }
                if (mo.getBroadcastHandle() != null) {
                    this.rCleanupLineageObject(mo.getBroadcastHandle());
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private void rCleanupLineageObject(LineageObject lob) throws IOException {
        if (lob.getNumReferences() > 0) {
            return;
        }
        if (lob.hasBackReference()) {
            return;
        }
        if (lob.isInLineageCache()) {
            return;
        }
        SparkExecutionContext.cleanupSingleLineageObject(lob);
        for (LineageObject c : lob.getLineageChilds()) {
            c.decrementNumReferences();
            this.rCleanupLineageObject(c);
        }
    }

    public static void cleanupSingleLineageObject(LineageObject lob) {
        if (lob instanceof RDDObject) {
            RDDObject rdd = (RDDObject)lob;
            int rddID = rdd.getRDD().id();
            SparkExecutionContext.cleanupRDDVariable(rdd.getRDD());
            if (rdd.getHDFSFilename() != null) {
                try {
                    HDFSTool.deleteFileWithMTDIfExistOnHDFS(rdd.getHDFSFilename());
                }
                catch (IOException e) {
                    throw new DMLRuntimeException(e);
                }
            }
            if (rdd.isParallelizedRDD()) {
                _parRDDs.deregisterRDD(rddID);
            }
        } else if (lob instanceof BroadcastObject) {
            Broadcast bc;
            PartitionedBroadcast pbm;
            BroadcastObject bob = (BroadcastObject)lob;
            if (bob.isPartitionedBroadcastValid() && (pbm = bob.getPartitionedBroadcast()) != null) {
                pbm.destroy();
            }
            if (((BroadcastObject)lob).isNonPartitionedBroadcastValid() && (bc = bob.getNonPartitionedBroadcast()) != null) {
                SparkExecutionContext.cleanupBroadcastVariable(bc);
            }
            CacheableData.addBroadcastSize(-bob.getSize());
        }
    }

    public static void cleanupBroadcastVariable(Broadcast<?> bvar) {
        if (bvar.isValid()) {
            bvar.destroy(false);
        }
    }

    public static void cleanupRDDVariable(JavaPairRDD<?, ?> rvar) {
        if (rvar.getStorageLevel() != StorageLevel.NONE()) {
            rvar.unpersist(false);
        }
    }

    public void repartitionAndCacheMatrixObject(String var) {
        int numPartitions;
        MatrixObject mo = this.getMatrixObject(var);
        DataCharacteristics dcIn = mo.getDataCharacteristics();
        if (!OptimizerUtils.exceedsCachingThreshold(mo.getNumColumns(), OptimizerUtils.estimateSizeExactSparsity(dcIn))) {
            return;
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = this.getRDDHandleForMatrixObject(mo, Types.FileFormat.BINARY);
        if (SparkUtils.isHashPartitioned(in)) {
            return;
        }
        if (mo.getRDDHandle().allowsShortCircuitRead() && this.isRDDMarkedForCaching(in.id()) && !SparkExecutionContext.isRDDCached(in.id()) && (numPartitions = SparkUtils.getNumPreferredPartitions(dcIn, in = ((RDDObject)mo.getRDDHandle().getLineageChilds().get(0)).getRDD())) < in.getNumPartitions()) {
            in = in.coalesce(numPartitions);
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDAggregateUtils.mergeByKey(in, false);
        if (OptimizerUtils.checkSparseBlockCSRConversion(dcIn)) {
            out = out.mapValues(new CreateSparseBlockFunction(SparseBlock.Type.CSR));
        }
        out.persist(Checkpoint.DEFAULT_STORAGE_LEVEL).count();
        RDDObject inro = mo.getRDDHandle();
        RDDObject outro = new RDDObject(out);
        outro.setCheckpointRDD(true);
        outro.addLineageChild(inro);
        mo.setRDDHandle(outro);
    }

    public void cacheMatrixObject(String var) {
        MatrixObject mo = this.getMatrixObject(var);
        if (!OptimizerUtils.exceedsCachingThreshold(mo.getNumColumns(), OptimizerUtils.estimateSizeExactSparsity(mo.getDataCharacteristics()))) {
            return;
        }
        JavaPairRDD<?, ?> in = this.getRDDHandleForMatrixObject(mo, Types.FileFormat.BINARY);
        if (!SparkExecutionContext.isRDDCached(in.id())) {
            in.count();
        }
    }

    public int setThreadLocalSchedulerPool() {
        int pool = -1;
        pool = SparkExecutionContext.allocSchedulerPoolName();
        this.getSparkContext().sc().setLocalProperty("spark.scheduler.pool", "parforPool" + pool);
        return pool;
    }

    public void cleanupThreadLocalSchedulerPool(int pool) {
        SparkExecutionContext.freeSchedulerPoolName(pool);
        this.getSparkContext().sc().setLocalProperty("spark.scheduler.pool", null);
    }

    private static synchronized int allocSchedulerPoolName() {
        int pool = ArrayUtils.indexOf((boolean[])_poolBuff, (boolean)false);
        if (pool < 0) {
            pool = _poolBuff.length;
            _poolBuff = Arrays.copyOf(_poolBuff, (int)Math.min(2L * (long)pool, Integer.MAX_VALUE));
        }
        SparkExecutionContext._poolBuff[pool] = true;
        return pool;
    }

    private static synchronized void freeSchedulerPoolName(int pool) {
        SparkExecutionContext._poolBuff[pool] = false;
    }

    private boolean isRDDMarkedForCaching(int rddID) {
        JavaSparkContext jsc = this.getSparkContext();
        return jsc.sc().getPersistentRDDs().contains((Object)rddID);
    }

    public static boolean isRDDCached(int rddID) {
        if (!SparkExecutionContext.isSparkContextCreated()) {
            return false;
        }
        JavaSparkContext jsc = _spctx;
        if (!jsc.sc().getPersistentRDDs().contains((Object)rddID)) {
            return false;
        }
        for (RDDInfo info : jsc.sc().getRDDStorageInfo()) {
            if (info.id() != rddID) continue;
            return info.isCached();
        }
        return false;
    }

    public static long getMemCachedRDDSize(int rddID) {
        if (!SparkExecutionContext.isSparkContextCreated()) {
            return 0L;
        }
        JavaSparkContext jsc = _spctx;
        if (!jsc.sc().getPersistentRDDs().contains((Object)rddID)) {
            return 0L;
        }
        for (RDDInfo info : jsc.sc().getRDDStorageInfo()) {
            if (info.id() != rddID || !info.isCached()) continue;
            return info.memSize();
        }
        return 0L;
    }

    public static long getStorageSpaceUsed() {
        if (!SparkExecutionContext.isSparkContextCreated()) {
            return 0L;
        }
        JavaSparkContext jsc = _spctx;
        return Arrays.stream(jsc.sc().getRDDStorageInfo()).mapToLong(RDDInfo::memSize).sum();
    }

    public static synchronized SparkClusterConfig getSparkClusterConfig() {
        if (_sconf == null) {
            _sconf = new SparkClusterConfig();
        }
        return _sconf;
    }

    public static double getBroadcastMemoryBudget() {
        return SparkExecutionContext.getSparkClusterConfig().getBroadcastMemoryBudget();
    }

    public static double getDataMemoryBudget(boolean min, boolean refresh) {
        return SparkExecutionContext.getSparkClusterConfig().getDataMemoryBudget(min, refresh);
    }

    public static int getNumExecutors() {
        return SparkExecutionContext.getSparkClusterConfig().getNumExecutors();
    }

    public static int getDefaultParallelism(boolean refresh) {
        return SparkExecutionContext.getSparkClusterConfig().getDefaultParallelism(refresh);
    }

    private static class MemoryManagerParRDDs {
        private final long _limit;
        private long _size;
        private HashMap<Integer, Long> _rdds;

        public MemoryManagerParRDDs(double fractionMem) {
            this._limit = (long)(fractionMem * (double)InfrastructureAnalyzer.getLocalMaxMemory());
            this._size = 0L;
            this._rdds = new HashMap();
        }

        public synchronized boolean reserve(long rddSize) {
            boolean ret = rddSize + this._size < this._limit;
            this._size += ret ? rddSize : 0L;
            return ret;
        }

        public synchronized void registerRDD(int rddID, long rddSize, boolean reserved) {
            if (!reserved) {
                throw new RuntimeException("Unsupported rdd registration without size reservation for " + rddSize + " bytes.");
            }
            this._rdds.put(rddID, rddSize);
        }

        public synchronized void deregisterRDD(int rddID) {
            Long rddSize = this._rdds.remove(rddID);
            this._size -= rddSize != null ? rddSize : 0L;
        }

        public synchronized void clear() {
            this._size = 0L;
            this._rdds.clear();
        }
    }

    public static class SparkClusterConfig {
        private static final double BROADCAST_DATA_FRACTION = 0.7;
        private static final double BROADCAST_DATA_FRACTION_LEGACY = 0.35;
        private static final long RESERVED_SYSTEM_MEMORY_BYTES = 314572800L;
        private boolean _legacyVersion = false;
        private boolean _confOnly = false;
        private long _memExecutor = -1L;
        private double _memDataMinFrac = -1.0;
        private double _memDataMaxFrac = -1.0;
        private double _memBroadcastFrac = -1.0;
        private int _numExecutors = -1;
        private int _defaultPar = -1;

        public SparkClusterConfig() {
            SparkExecutionContext.handleIllegalReflectiveAccessSpark();
            SparkConf sconf = SparkExecutionContext.createSystemDSSparkConf();
            this._confOnly = true;
            String sparkVersion = SparkClusterConfig.getSparkVersionString();
            boolean bl = this._legacyVersion = UtilFunctions.compareVersion(sparkVersion, "1.6.0") < 0 || sconf.getBoolean("spark.memory.useLegacyMode", false);
            if (this._legacyVersion) {
                this.analyzeSparkConfiguationLegacy(sconf);
            } else {
                this.analyzeSparkConfiguation(sconf);
            }
            if (ExecutionContext.LOG.isDebugEnabled()) {
                ExecutionContext.LOG.debug((Object)this.toString());
            }
        }

        public long getBroadcastMemoryBudget() {
            return (long)((double)this._memExecutor * this._memBroadcastFrac);
        }

        public long getDataMemoryBudget(boolean min, boolean refresh) {
            int numExec = this._numExecutors;
            if (refresh && !this._confOnly || SparkExecutionContext.isSparkContextCreated()) {
                numExec = Math.max(SparkExecutionContext.getSparkContextStatic().sc().getExecutorMemoryStatus().size() - 1, 1);
            }
            return (long)((double)((long)numExec * this._memExecutor) * (min ? this._memDataMinFrac : this._memDataMaxFrac));
        }

        public int getNumExecutors() {
            if (this._numExecutors < 0) {
                this.analyzeSparkParallelismConfiguation(null);
            }
            return this._numExecutors;
        }

        public int getDefaultParallelism(boolean refresh) {
            if (this._defaultPar < 0 && !refresh) {
                this.analyzeSparkParallelismConfiguation(null);
            }
            int par = refresh && !this._confOnly || SparkExecutionContext.isSparkContextCreated() ? SparkExecutionContext.getSparkContextStatic().defaultParallelism() : this._defaultPar;
            return Math.max(par, 1);
        }

        public void analyzeSparkConfiguationLegacy(SparkConf conf) {
            double dataFrac;
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemDSSparkConf() : conf;
            this._memExecutor = UtilFunctions.parseMemorySize(sconf.get("spark.executor.memory", "1g"));
            this._memDataMinFrac = dataFrac = sconf.getDouble("spark.storage.memoryFraction", 0.6);
            this._memDataMaxFrac = dataFrac;
            this._memBroadcastFrac = dataFrac * 0.35;
            this.analyzeSparkParallelismConfiguation(sconf);
        }

        public void analyzeSparkConfiguation(SparkConf conf) {
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemDSSparkConf() : conf;
            this._memExecutor = UtilFunctions.parseMemorySize(sconf.get("spark.executor.memory", "1g")) - 314572800L;
            double unifiedMem = sconf.getDouble("spark.memory.fraction", 0.6);
            this._memDataMinFrac = unifiedMem * sconf.getDouble("spark.memory.storageFraction", 0.5);
            this._memDataMaxFrac = unifiedMem;
            this._memBroadcastFrac = this._memDataMinFrac * 0.7;
            this.analyzeSparkParallelismConfiguation(sconf);
        }

        private void analyzeSparkParallelismConfiguation(SparkConf conf) {
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemDSSparkConf() : conf;
            int numExecutors = sconf.getInt("spark.executor.instances", -1);
            int numCoresPerExec = sconf.getInt("spark.executor.cores", -1);
            int defaultPar = sconf.getInt("spark.default.parallelism", -1);
            if (numExecutors > 1 && (defaultPar > 1 || numCoresPerExec > 1)) {
                this._numExecutors = numExecutors;
                this._defaultPar = defaultPar > 1 ? defaultPar : numExecutors * numCoresPerExec;
                this._confOnly &= true;
            } else if (DMLScript.USE_LOCAL_SPARK_CONFIG) {
                this._numExecutors = 1;
                this._defaultPar = 2;
                this._confOnly &= true;
            } else {
                JavaSparkContext jsc = SparkExecutionContext.getSparkContextStatic();
                this._numExecutors = Math.max(jsc.sc().getExecutorMemoryStatus().size() - 1, 1);
                this._defaultPar = jsc.defaultParallelism();
                this._confOnly &= false;
            }
        }

        private static String getSparkVersionString() {
            if (SparkExecutionContext.isSparkContextCreated()) {
                return SparkExecutionContext.getSparkContextStatic().version();
            }
            return package$.MODULE$.SPARK_VERSION();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SparkClusterConfig: \n");
            sb.append("-- legacyVersion    = " + this._legacyVersion + " (" + SparkClusterConfig.getSparkVersionString() + ")\n");
            sb.append("-- confOnly         = " + this._confOnly + "\n");
            sb.append("-- numExecutors     = " + this._numExecutors + "\n");
            sb.append("-- defaultPar       = " + this._defaultPar + "\n");
            sb.append("-- memExecutor      = " + this._memExecutor + "\n");
            sb.append("-- memDataMinFrac   = " + this._memDataMinFrac + "\n");
            sb.append("-- memDataMaxFrac   = " + this._memDataMaxFrac + "\n");
            sb.append("-- memBroadcastFrac = " + this._memBroadcastFrac + "\n");
            return sb.toString();
        }
    }

    private static class BlockPartitionToMatrixBlockTask
    implements Callable<Object> {
        private final List<Tuple2<MatrixIndexes, MatrixBlock>> _tuples;
        private final int _start;
        private final int _end;
        private final MatrixBlock _out;
        private final LongAdder _aNnz;
        private final int _blen;
        private final boolean _sparseCopyShallow;

        protected BlockPartitionToMatrixBlockTask(List<Tuple2<MatrixIndexes, MatrixBlock>> tuples, int start, int end, MatrixBlock out, LongAdder aNnz, int blen, boolean sparseCopyShallow) {
            this._tuples = tuples;
            this._start = start;
            this._end = end;
            this._out = out;
            this._aNnz = aNnz;
            this._blen = blen;
            this._sparseCopyShallow = sparseCopyShallow;
        }

        @Override
        public Object call() {
            for (int i = this._start; i < this._end; ++i) {
                SparkExecutionContext.blockPartitionToMatrixBlock(this._tuples.get(i), this._out, this._aNnz, this._blen, this._sparseCopyShallow);
            }
            return null;
        }
    }
}

