/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.MatrixObjectFuture;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.controlprogram.paramserv.homomorphicEncryption.SEALClient;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.instructions.gpu.context.CSRPointer;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageDebugger;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.Statistics;

public class ExecutionContext {
    protected static final Log LOG = LogFactory.getLog((String)ExecutionContext.class.getName());
    protected Program _prog = null;
    protected LocalVariableMap _variables;
    protected long _tid = -1L;
    protected boolean _autoCreateVars;
    protected Lineage _lineage;
    protected SEALClient _seal_client;
    protected Set<String> _fnNames;
    protected List<GPUContext> _gpuContexts = new ArrayList<GPUContext>();

    protected ExecutionContext() {
        this(true, DMLScript.LINEAGE, null);
    }

    protected ExecutionContext(boolean allocateVariableMap, boolean allocateLineage, Program prog) {
        this._variables = allocateVariableMap ? new LocalVariableMap() : null;
        this._autoCreateVars = false;
        this._lineage = allocateLineage ? new Lineage() : null;
        this._prog = prog;
        this._fnNames = new HashSet<String>();
    }

    public ExecutionContext(LocalVariableMap vars) {
        this._variables = vars;
        this._autoCreateVars = false;
        this._lineage = null;
        this._prog = null;
        this._fnNames = new HashSet<String>();
    }

    public Program getProgram() {
        return this._prog;
    }

    public void setProgram(Program prog) {
        this._prog = prog;
    }

    public LocalVariableMap getVariables() {
        return this._variables;
    }

    public void setVariables(LocalVariableMap vars) {
        this._variables = vars;
    }

    public Lineage getLineage() {
        return this._lineage;
    }

    public void setLineage(Lineage lineage) {
        this._lineage = lineage;
    }

    public boolean isAutoCreateVars() {
        return this._autoCreateVars;
    }

    public void setAutoCreateVars(boolean flag) {
        this._autoCreateVars = flag;
    }

    public void setTID(long tid) {
        this._tid = tid;
    }

    public long getTID() {
        return this._tid;
    }

    public void setSealClient(SEALClient seal_client) {
        this._seal_client = seal_client;
    }

    public SEALClient getSealClient() {
        return this._seal_client;
    }

    public GPUContext getGPUContext(int index) {
        try {
            return this._gpuContexts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setGPUContexts(List<GPUContext> gpuContexts) {
        this._gpuContexts = gpuContexts;
        if (!LineageCacheConfig.ReuseCacheType.isNone()) {
            LineageGPUCacheEviction.setGPUContext(gpuContexts.get(0));
        }
    }

    public List<GPUContext> getGPUContexts() {
        return this._gpuContexts;
    }

    public int getNumGPUContexts() {
        return this._gpuContexts.size();
    }

    public Data getVariable(String name) {
        return this._variables.get(name);
    }

    public Data getVariable(CPOperand operand) {
        return operand.getDataType().isScalar() ? this.getScalarInput(operand) : this.getVariable(operand.getName());
    }

    public void setVariable(String name, Data val) {
        this._variables.put(name, val);
    }

    public boolean containsVariable(CPOperand operand) {
        return this.containsVariable(operand.getName());
    }

    public boolean containsVariable(String name) {
        return this._variables.keySet().contains(name);
    }

    public Data removeVariable(String name) {
        return this._variables.remove(name);
    }

    public void setMetaData(String fname, MetaData md) {
        this._variables.get(fname).setMetaData(md);
    }

    public MetaData getMetaData(String varname) {
        Data tmp = this._variables.get(varname);
        if (tmp == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(varname));
        }
        return tmp.getMetaData();
    }

    public boolean isMatrixObject(String varname) {
        Data dat = this.getVariable(varname);
        return dat != null && dat instanceof MatrixObject;
    }

    public MatrixObject getMatrixObject(CPOperand input) {
        return this.getMatrixObject(input.getName());
    }

    public MatrixObject getMatrixObject(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(varname));
        }
        if (!(dat instanceof MatrixObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix: " + dat.getClass().getName());
        }
        return (MatrixObject)dat;
    }

    public MatrixLineagePair getMatrixLineagePair(CPOperand cpo) {
        return this.getMatrixLineagePair(cpo.getName());
    }

    public MatrixLineagePair getMatrixLineagePair(String varname) {
        MatrixObject mo = this.getMatrixObject(varname);
        if (mo == null) {
            return null;
        }
        return MatrixLineagePair.of(mo, DMLScript.LINEAGE ? this.getLineageItem(varname) : null);
    }

    public TensorObject getTensorObject(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(varname));
        }
        if (!(dat instanceof TensorObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a tensor.");
        }
        return (TensorObject)dat;
    }

    public boolean isFrameObject(String varname) {
        Data dat = this.getVariable(varname);
        return dat != null && dat instanceof FrameObject;
    }

    public FrameObject getFrameObject(CPOperand input) {
        return this.getFrameObject(input.getName());
    }

    public FrameObject getFrameObject(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(varname));
        }
        if (!(dat instanceof FrameObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a frame.");
        }
        return (FrameObject)dat;
    }

    public CacheableData<?> getCacheableData(CPOperand input) {
        return this.getCacheableData(input.getName());
    }

    public CacheableData<?> getCacheableData(String varname) {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(varname));
        }
        if (!(dat instanceof CacheableData)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix, tensor or frame.");
        }
        return (CacheableData)dat;
    }

    public void releaseCacheableData(String varname) {
        this.getCacheableData(varname).release();
    }

    public DataCharacteristics getDataCharacteristics(String varname) {
        return this.getMetaData(varname).getDataCharacteristics();
    }

    public MatrixBlock getMatrixInput(String varName) {
        return (MatrixBlock)this.getMatrixObject(varName).acquireRead();
    }

    public MatrixBlock getMatrixInput(CPOperand input) {
        return (MatrixBlock)this.getMatrixObject(input.getName()).acquireRead();
    }

    public TensorBlock getTensorInput(String varName) {
        return (TensorBlock)this.getTensorObject(varName).acquireRead();
    }

    public void setMetaData(String varName, long nrows, long ncols) {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getNumRows() == nrows && mo.getNumColumns() == ncols) {
            return;
        }
        MetaData oldMetaData = mo.getMetaData();
        if (oldMetaData == null || !(oldMetaData instanceof MetaDataFormat)) {
            throw new DMLRuntimeException("Metadata not available");
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(nrows, ncols, mo.getBlocksize());
        mo.setMetaData(new MetaDataFormat(mc, ((MetaDataFormat)oldMetaData).getFileFormat()));
    }

    private static long validateDimensions(long d1, long d2) {
        if (d1 >= 0L && d2 >= 0L && d1 != d2) {
            throw new DMLRuntimeException("Incorrect dimensions:" + d1 + " != " + d2);
        }
        return Math.max(d1, d2);
    }

    public Pair<MatrixObject, Boolean> getDenseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols) {
        return this.getDenseMatrixOutputForGPUInstruction(varName, numRows, numCols, true);
    }

    public Pair<MatrixObject, Boolean> getDenseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols, boolean initialize) {
        MatrixObject mo = this.allocateGPUMatrixObject(varName, numRows, numCols);
        boolean allocated = mo.getGPUObject(this.getGPUContext(0)).acquireDeviceModifyDense(initialize);
        mo.getDataCharacteristics().setNonZeros(-1L);
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public Pair<MatrixObject, Boolean> getSparseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols, long nnz) {
        return this.getSparseMatrixOutputForGPUInstruction(varName, numRows, numCols, nnz, true);
    }

    public Pair<MatrixObject, Boolean> getSparseMatrixOutputForGPUInstruction(String varName, long numRows, long numCols, long nnz, boolean initialize) {
        MatrixObject mo = this.allocateGPUMatrixObject(varName, numRows, numCols);
        mo.getDataCharacteristics().setNonZeros(nnz);
        boolean allocated = mo.getGPUObject(this.getGPUContext(0)).acquireDeviceModifySparse(initialize);
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public MatrixObject allocateGPUMatrixObject(String varName, long numRows, long numCols) {
        MatrixObject mo = this.getMatrixObject(varName);
        long dim1 = -1L;
        long dim2 = -1L;
        try {
            dim1 = ExecutionContext.validateDimensions(mo.getNumRows(), numRows);
            dim2 = ExecutionContext.validateDimensions(mo.getNumColumns(), numCols);
        }
        catch (DMLRuntimeException e) {
            throw new DMLRuntimeException("Incorrect dimensions given to allocateGPUMatrixObject: [" + numRows + "," + numCols + "], [" + mo.getNumRows() + "," + mo.getNumColumns() + "]", e);
        }
        if (dim1 != mo.getNumRows() || dim2 != mo.getNumColumns()) {
            mo.getDataCharacteristics().setDimension(dim1, dim2);
        }
        if (mo.getGPUObject(this.getGPUContext(0)) == null) {
            GPUObject newGObj = this.getGPUContext(0).createGPUObject(mo);
            mo.setGPUObject(this.getGPUContext(0), newGObj);
        }
        mo.getGPUObject(this.getGPUContext(0)).addWriteLock();
        return mo;
    }

    public long getGPUDensePointerAddress(MatrixObject obj) {
        if (obj.getGPUObject(this.getGPUContext(0)) == null) {
            return 0L;
        }
        return obj.getGPUObject(this.getGPUContext(0)).getDensePointerAddress();
    }

    public CSRPointer getGPUSparsePointerAddress(MatrixObject obj) {
        if (obj.getGPUObject(this.getGPUContext(0)) == null) {
            throw new RuntimeException("No CSRPointer for MatrixObject " + obj.toString());
        }
        return obj.getGPUObject(this.getGPUContext(0)).getJcudaSparseMatrixPtr();
    }

    public MatrixObject getMatrixInputForGPUInstruction(String varName, String opcode) {
        GPUContext gCtx = this.getGPUContext(0);
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo == null) {
            throw new DMLRuntimeException("No matrix object available for variable:" + varName);
        }
        if (mo.getGPUObject(gCtx) == null) {
            GPUObject newGObj = gCtx.createGPUObject(mo);
            mo.setGPUObject(gCtx, newGObj);
        }
        mo.getGPUObject(gCtx).acquireDeviceRead(opcode);
        return mo;
    }

    public void releaseMatrixInput(String varName) {
        this.getMatrixObject(varName).release();
    }

    public void releaseMatrixInput(String ... varNames) {
        for (String varName : varNames) {
            this.releaseMatrixInput(varName);
        }
    }

    public void releaseMatrixInputForGPUInstruction(String varName) {
        this.getMatrixObject(varName).getGPUObject(this.getGPUContext(0)).releaseInput();
    }

    public FrameBlock getFrameInput(String varName) {
        return (FrameBlock)this.getFrameObject(varName).acquireRead();
    }

    public void releaseFrameInput(String varName) {
        this.getFrameObject(varName).release();
    }

    public void releaseTensorInput(String varName) {
        this.getTensorObject(varName).release();
    }

    public void releaseTensorInput(String ... varNames) {
        for (String varName : varNames) {
            this.releaseTensorInput(varName);
        }
    }

    public ScalarObject getScalarInput(CPOperand input) {
        return input.isLiteral() ? input.getLiteral() : this.getScalarInput(input.getName(), input.getValueType(), false);
    }

    public ScalarObject getScalarInput(String name, Types.ValueType vt, boolean isLiteral) {
        if (isLiteral) {
            return ScalarObjectFactory.createScalarObject(vt, name);
        }
        Data obj = this.getVariable(name);
        if (obj == null) {
            throw new DMLRuntimeException("Unknown variable: " + name);
        }
        return (ScalarObject)obj;
    }

    public void setScalarOutput(String varName, ScalarObject so) {
        this.setVariable(varName, so);
    }

    public ListObject getListObject(CPOperand input) {
        return this.getListObject(input.getName());
    }

    public ListObject getListObject(String name) {
        Data dat = this.getVariable(name);
        if (dat == null) {
            throw new DMLRuntimeException(ExecutionContext.getNonExistingVarError(name));
        }
        if (!(dat instanceof ListObject)) {
            throw new DMLRuntimeException("Variable '" + name + "' is not a list.");
        }
        return (ListObject)dat;
    }

    private List<MatrixObject> getMatricesFromList(ListObject lo) {
        ArrayList<MatrixObject> ret = new ArrayList<MatrixObject>();
        for (Data e : lo.getData()) {
            if (e instanceof MatrixObject) {
                ret.add((MatrixObject)e);
                continue;
            }
            if (e instanceof ListObject) {
                ret.addAll(this.getMatricesFromList((ListObject)e));
                continue;
            }
            throw new DMLRuntimeException("List must contain only matrices or lists for rbind/cbind.");
        }
        return ret;
    }

    public void releaseMatrixOutputForGPUInstruction(String varName) {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getGPUObject(this.getGPUContext(0)) == null || !mo.getGPUObject(this.getGPUContext(0)).isAllocated()) {
            throw new DMLRuntimeException("No output is allocated on GPU");
        }
        this.setMetaData(varName, new MetaDataFormat(mo.getDataCharacteristics(), Types.FileFormat.BINARY));
        mo.getGPUObject(this.getGPUContext(0)).releaseOutput();
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData) {
        this.setMatrixOutputAndLineage(varName, outputData, null);
    }

    public void setMatrixOutputAndLineage(CPOperand var, MatrixBlock outputData, LineageItem li) {
        this.setMatrixOutputAndLineage(var.getName(), outputData, li);
    }

    public void setMatrixOutputAndLineage(String varName, MatrixBlock outputData, LineageItem li) {
        if (this.isAutoCreateVars() && !this.containsVariable(varName)) {
            this.setVariable(varName, ExecutionContext.createMatrixObject(outputData));
        }
        MatrixObject mo = this.getMatrixObject(varName);
        mo.acquireModify(outputData);
        mo.setCacheLineage(li);
        mo.release();
    }

    public void setMatrixOutputAndLineage(String varName, Future<MatrixBlock> fmb, LineageItem li) {
        if (this.isAutoCreateVars() && !this.containsVariable(varName)) {
            MatrixObjectFuture matrixObjectFuture = new MatrixObjectFuture(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), fmb);
        }
        MatrixObject mo = this.getMatrixObject(varName);
        MatrixObjectFuture fmo = new MatrixObjectFuture(mo, fmb);
        fmo.setCacheLineage(li);
        this.setVariable(varName, fmo);
    }

    public void setMatrixOutput(String varName, Future<MatrixBlock> fmb) {
        this.setMatrixOutputAndLineage(varName, fmb, null);
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData, MatrixObject.UpdateType flag) {
        if (this.isAutoCreateVars() && !this.containsVariable(varName)) {
            this.setVariable(varName, ExecutionContext.createMatrixObject(outputData));
        }
        if (flag.isInPlace()) {
            MatrixObject mo = this.getMatrixObject(varName);
            mo.setUpdateType(flag);
        }
        this.setMatrixOutput(varName, outputData);
    }

    public void setTensorOutput(String varName, TensorBlock outputData) {
        TensorObject to = this.getTensorObject(varName);
        to.acquireModify(outputData);
        to.release();
        this.setVariable(varName, to);
    }

    public void setFrameOutput(String varName, FrameBlock outputData) {
        if (this.isAutoCreateVars() && !this.containsVariable(varName)) {
            this.setVariable(varName, ExecutionContext.createFrameObject(outputData));
        }
        FrameObject fo = this.getFrameObject(varName);
        fo.setSchema(outputData.getSchema());
        fo.acquireModify(outputData);
        fo.release();
        this.setVariable(varName, fo);
    }

    public static CacheableData<?> createCacheableData(CacheBlock<?> cb) {
        if (cb instanceof MatrixBlock) {
            return ExecutionContext.createMatrixObject((MatrixBlock)cb);
        }
        if (cb instanceof FrameBlock) {
            return ExecutionContext.createFrameObject((FrameBlock)cb);
        }
        return null;
    }

    public static MatrixObject createMatrixObject(MatrixBlock mb) {
        long nRow = mb.getNumRows();
        long nCol = mb.getNumColumns();
        int bz = ConfigurationManager.getBlocksize();
        MetaDataFormat md = new MetaDataFormat(new MatrixCharacteristics(nRow, nCol, bz), Types.FileFormat.BINARY);
        return new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), md, mb);
    }

    public static MatrixObject createMatrixObject(DataCharacteristics dc) {
        long nRow = dc.getRows();
        long nCol = dc.getCols();
        int bz = dc.getBlocksize() == -1 ? ConfigurationManager.getBlocksize() : dc.getBlocksize();
        MetaDataFormat md = new MetaDataFormat(new MatrixCharacteristics(nRow, nCol, bz), Types.FileFormat.BINARY);
        return new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), md);
    }

    public static FrameObject createFrameObject(DataCharacteristics dc) {
        FrameObject ret = new FrameObject(OptimizerUtils.getUniqueTempFileName());
        ret.setMetaData(new MetaDataFormat(new MatrixCharacteristics(dc.getRows(), dc.getCols()), Types.FileFormat.BINARY));
        ret.getMetaData().getDataCharacteristics().setBlocksize(ConfigurationManager.getBlocksize());
        return ret;
    }

    public static FrameObject createFrameObject(FrameBlock fb) {
        FrameObject ret = new FrameObject(OptimizerUtils.getUniqueTempFileName());
        ret.acquireModify(fb);
        ret.setMetaData(new MetaDataFormat(new MatrixCharacteristics(fb.getNumRows(), fb.getNumColumns()), Types.FileFormat.BINARY));
        ret.release();
        return ret;
    }

    public List<MatrixBlock> getMatrixInputs(CPOperand[] inputs) {
        return this.getMatrixInputs(inputs, false);
    }

    public List<MatrixBlock> getMatrixInputs(CPOperand[] inputs, boolean includeList) {
        List<MatrixBlock> ret = Arrays.stream(inputs).filter(in -> in.isMatrix()).map(in -> this.getMatrixInput(in.getName())).collect(Collectors.toList());
        if (includeList) {
            List lolist = Arrays.stream(inputs).filter(in -> in.isList()).map(in -> this.getListObject(in.getName())).collect(Collectors.toList());
            for (ListObject lo : lolist) {
                ret.addAll(this.getMatricesFromList(lo).stream().map(mo -> (MatrixBlock)mo.acquireRead()).collect(Collectors.toList()));
            }
        }
        return ret;
    }

    public List<ScalarObject> getScalarInputs(CPOperand[] inputs) {
        return Arrays.stream(inputs).filter(in -> in.isScalar()).map(in -> this.getScalarInput((CPOperand)in)).collect(Collectors.toList());
    }

    public void releaseMatrixInputs(CPOperand[] inputs) {
        this.releaseMatrixInputs(inputs, false);
    }

    public void releaseMatrixInputs(CPOperand[] inputs, boolean includeList) {
        Arrays.stream(inputs).filter(in -> in.isMatrix()).forEach(in -> this.releaseMatrixInput(in.getName()));
        if (includeList) {
            List lolist = Arrays.stream(inputs).filter(in -> in.isList()).map(in -> this.getListObject(in.getName())).collect(Collectors.toList());
            for (ListObject lo : lolist) {
                this.getMatricesFromList(lo).stream().forEach(mo -> mo.release());
            }
        }
    }

    public Queue<Boolean> pinVariables(List<String> varList) {
        Data dat;
        LinkedList<Boolean> varsStates = new LinkedList<Boolean>();
        for (String varName : varList) {
            dat = this._variables.get(varName);
            if (dat instanceof CacheableData) {
                varsStates.add(((CacheableData)dat).isCleanupEnabled());
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            varsStates.addAll(((ListObject)dat).getCleanupStates());
        }
        for (String varName : varList) {
            dat = this._variables.get(varName);
            if (dat instanceof CacheableData) {
                ((CacheableData)dat).enableCleanup(false);
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            ((ListObject)dat).enableCleanup(false);
        }
        return varsStates;
    }

    public void unpinVariables(List<String> varList, Queue<Boolean> varsState) {
        for (String varName : varList) {
            Data dat = this._variables.get(varName);
            if (dat instanceof CacheableData) {
                ((CacheableData)dat).enableCleanup(varsState.poll());
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            ((ListObject)dat).enableCleanup(varsState);
        }
    }

    public ArrayList<String> getVarList() {
        return new ArrayList<String>(this._variables.keySet());
    }

    public ArrayList<String> getVarListPartitioned() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String var : this._variables.keySet()) {
            Data dat = this._variables.get(var);
            if (!(dat instanceof MatrixObject) || !((MatrixObject)dat).isPartitioned()) continue;
            ret.add(var);
        }
        return ret;
    }

    public final void cleanupDataObject(Data dat) {
        if (dat == null) {
            return;
        }
        if (dat instanceof CacheableData) {
            this.cleanupCacheableData((CacheableData)dat);
        } else if (dat instanceof ListObject) {
            for (Data dat2 : ((ListObject)dat).getData()) {
                this.cleanupDataObject(dat2);
            }
        }
    }

    public void cleanupCacheableData(CacheableData<?> mo) {
        boolean fileExists;
        if (DMLScript.JMLC_MEM_STATISTICS) {
            Statistics.removeCPMemObject(System.identityHashCode(mo));
        }
        boolean bl = fileExists = mo.isHDFSFileExists() && mo.getFileName() != null;
        if (!CacheableData.isCachingActive() && !fileExists) {
            return;
        }
        try {
            if (mo.isCleanupEnabled() && !this.getVariables().hasReferences(mo)) {
                mo.clearData(this.getTID());
                if (fileExists) {
                    HDFSTool.deleteFileIfExistOnHDFS(mo.getFileName());
                    HDFSTool.deleteFileIfExistOnHDFS(mo.getFileName() + ".mtd");
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public boolean isFederated(CPOperand input) {
        Data data = this.getVariable(input);
        return data instanceof CacheableData && ((CacheableData)data).isFederated();
    }

    public boolean isFederated(CPOperand input, FTypes.FType type) {
        Data data = this.getVariable(input);
        return data instanceof CacheableData && ((CacheableData)data).isFederated(type);
    }

    public void traceLineage(Instruction inst) {
        if (this._lineage == null) {
            throw new DMLRuntimeException("Lineage Trace unavailable.");
        }
        this._lineage.trace(inst, this);
    }

    public void maintainLineageDebuggerInfo(Instruction inst) {
        if (this._lineage == null) {
            throw new DMLRuntimeException("Lineage Trace unavailable.");
        }
        LineageDebugger.maintainSpecialValueBits(this._lineage, inst, this);
    }

    public LineageItem getLineageItem(CPOperand input) {
        return this.getLineageItem(input.getName());
    }

    public LineageItem getLineageItem(String varname) {
        if (this._lineage == null) {
            throw new DMLRuntimeException("Lineage Trace unavailable.");
        }
        return this._lineage.get(varname);
    }

    public LineageItem getOrCreateLineageItem(CPOperand input) {
        if (this._lineage == null) {
            throw new DMLRuntimeException("Lineage Trace unavailable.");
        }
        return this._lineage.getOrCreate(input);
    }

    public void replaceLineageItem(String varname, LineageItem li) {
        if (!LineageCacheConfig.isLineageTraceReuse()) {
            return;
        }
        if (this._lineage == null) {
            throw new DMLRuntimeException("Lineage Trace unavailable.");
        }
        if (this._lineage.get(varname) == null) {
            throw new DMLRuntimeException("Lineage item does not exist for " + varname);
        }
        this._lineage.set(varname, li);
    }

    private static String getNonExistingVarError(String varname) {
        return "Variable '" + varname + "' does not exist in the symbol table.";
    }

    public void addTmpParforFunction(String fname) {
        this._fnNames.add(fname);
    }

    public Set<String> getTmpParforFunctions() {
        return this._fnNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName().toString());
        if (this._prog != null) {
            sb.append("\nProgram: " + this._prog.toString());
        }
        if (this._variables != null) {
            sb.append("\nLocalVariableMap: " + this._variables.toString());
        }
        if (this._lineage != null) {
            sb.append("\nLineage: " + this._lineage.toString());
        }
        return sb.toString();
    }
}

