/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.iogen.TextTrieNode;
import org.apache.sysds.runtime.matrix.data.Pair;

public class TextTrie {
    private TextTrieNode root = new TextTrieNode();

    TextTrie() {
    }

    public void reverseInsert(String word, int rowIndex) {
        TextTrieNode current = this.root;
        for (int i = word.length() - 1; i >= 0; --i) {
            current = current.getChildren().computeIfAbsent(Character.valueOf(word.charAt(i)), c -> new TextTrieNode());
            current.addRowIndex(rowIndex);
        }
        current.setEndOfWord(true);
    }

    public void insert(String word, int rowIndex) {
        TextTrieNode current = this.root;
        for (char l : word.toCharArray()) {
            current = current.getChildren().computeIfAbsent(Character.valueOf(l), c -> new TextTrieNode());
            current.addRowIndex(rowIndex);
        }
        current.setEndOfWord(true);
    }

    public TextTrieNode containsString(String word) {
        TextTrieNode current = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            TextTrieNode node = current.getChildren().get(Character.valueOf(ch));
            if (node == null) {
                return null;
            }
            current = node;
        }
        return current;
    }

    public int containsStringAndSet(String word) {
        TextTrieNode result = this.containsString(word);
        int rowIndex = -1;
        if (result != null && (rowIndex = result.getRowIndex()) != -1) {
            result.setRowIndexUsed(rowIndex);
        }
        return rowIndex;
    }

    public ArrayList<Pair<String, Set<Integer>>> getAllKeys() {
        ArrayList<Pair<String, Set<Integer>>> result = new ArrayList<Pair<String, Set<Integer>>>();
        ArrayList<Key> allKeys = new ArrayList<Key>();
        this.getAllKeys(this.root, allKeys, new Key(new StringBuilder(), new ArrayList<Integer>()));
        Comparator<Key> compare = Comparator.comparing(Key::getIndexSetSize).thenComparing(Key::getKeyLength).reversed();
        List sortedKeys = allKeys.stream().sorted(compare).collect(Collectors.toList());
        for (Key k : sortedKeys) {
            result.add(new Pair<String, Set<Integer>>(k.getKey().toString(), k.getIndexSet()));
        }
        return result;
    }

    private void getAllKeys(TextTrieNode node, ArrayList<Key> result, Key curKey) {
        if (node.getChildren().size() == 0) {
            return;
        }
        for (Character k : node.getChildren().keySet()) {
            TextTrieNode child = node.getChildren().get(k);
            ArrayList<Integer> tList = new ArrayList<Integer>();
            tList.addAll(child.getRowIndexes());
            Key key = new Key(new StringBuilder(curKey.getKey()).append(k), tList);
            result.add(key);
            this.getAllKeys(child, result, key);
        }
    }

    private class Key {
        private StringBuilder key;
        private ArrayList<Integer> rowIndexes;
        private int keyLength;
        private Set<Integer> indexSet;
        private int indexSetSize;

        public Key(StringBuilder key, ArrayList<Integer> rowIndexes) {
            this.key = key;
            this.rowIndexes = rowIndexes;
            this.keyLength = key.length();
            this.indexSet = new HashSet<Integer>();
            this.indexSet.addAll(rowIndexes);
            this.indexSetSize = this.indexSet.size();
        }

        public StringBuilder getKey() {
            return this.key;
        }

        public void setKey(StringBuilder key) {
            this.key = key;
        }

        public ArrayList<Integer> getRowIndexes() {
            return this.rowIndexes;
        }

        public void setRowIndexes(ArrayList<Integer> rowIndexes) {
            this.rowIndexes = rowIndexes;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public Set<Integer> getIndexSet() {
            return this.indexSet;
        }

        public int getIndexSetSize() {
            return this.indexSetSize;
        }

        public void print() {
            Gson gson = new Gson();
            System.out.println(this.key.toString() + " " + gson.toJson(this.indexSet));
        }
    }
}

