/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.CompressionSettingsBuilder;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SchemeFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupUncompressed
extends AColGroup {
    private static final long serialVersionUID = -8254271148043292199L;
    private final MatrixBlock _data;

    private ColGroupUncompressed(MatrixBlock mb, IColIndex colIndexes) {
        super(colIndexes);
        this._data = mb;
    }

    public static AColGroup create(MatrixBlock mb, IColIndex colIndexes) {
        if (mb == null || mb.isEmpty()) {
            return new ColGroupEmpty(colIndexes);
        }
        return new ColGroupUncompressed(mb, colIndexes);
    }

    public static AColGroup create(IColIndex colIndexes, MatrixBlock rawBlock, boolean transposed) {
        int _numRows;
        if (rawBlock.isEmptyBlock(false)) {
            return new ColGroupEmpty(colIndexes);
        }
        if (!transposed && colIndexes.size() == rawBlock.getNumColumns()) {
            return new ColGroupUncompressed(rawBlock, colIndexes);
        }
        int n = _numRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        if (colIndexes.size() == 1) {
            MatrixBlock mb;
            int col = colIndexes.get(0);
            if (transposed) {
                mb = rawBlock.slice(col, col, 0, rawBlock.getNumColumns() - 1);
                mb = LibMatrixReorg.transposeInPlace(mb, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                mb = rawBlock.slice(0, rawBlock.getNumRows() - 1, col, col);
            }
            return ColGroupUncompressed.create(mb, colIndexes);
        }
        MatrixBlock mb = new MatrixBlock(_numRows, colIndexes.size(), rawBlock.isInSparseFormat());
        int m = _numRows;
        int n2 = colIndexes.size();
        if (transposed) {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mb.appendValue(i, j, rawBlock.quickGetValue(colIndexes.get(j), i));
                }
            }
        } else {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mb.appendValue(i, j, rawBlock.quickGetValue(i, colIndexes.get(j)));
                }
            }
        }
        mb.recomputeNonZeros();
        mb.examSparsity();
        return ColGroupUncompressed.create(mb, colIndexes);
    }

    public static AColGroup create(MatrixBlock data) {
        return ColGroupUncompressed.create(ColIndexFactory.create(data.getNumColumns()), data, false);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.UNCOMPRESSED;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.UNCOMPRESSED;
    }

    public MatrixBlock getData() {
        return this._data;
    }

    @Override
    public long estimateInMemorySize() {
        return ColGroupSizes.estimateInMemorySizeUncompressed(this._data.getNumRows(), this._colIndexes.isContiguous(), this.getNumCols(), this._data.getSparsity());
    }

    @Override
    public void decompressToDenseBlock(DenseBlock db, int rl, int ru, int offR, int offC) {
        if (this._data.isInSparseFormat()) {
            this.decompressToDenseBlockSparseData(db, rl, ru, offR, offC);
        } else if (this._colIndexes.size() == db.getDim(1)) {
            this.decompressToDenseBlockDenseDataAllColumns(db, rl, ru, offR);
        } else {
            this.decompressToDenseBlockDenseData(db, rl, ru, offR, offC);
        }
    }

    private void decompressToDenseBlockDenseData(DenseBlock db, int rl, int ru, int offR, int offC) {
        int offT = rl + offR;
        int nCol = this._colIndexes.size();
        double[] values = this._data.getDenseBlockValues();
        int offS = rl * nCol;
        int row = rl;
        while (row < ru) {
            double[] c = db.values(offT);
            int off = db.pos(offT) + offC;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[offS + j];
            }
            ++row;
            ++offT;
            offS += nCol;
        }
    }

    private void decompressToDenseBlockDenseDataAllColumns(DenseBlock db, int rl, int ru, int offR) {
        int offT = rl + offR;
        int nCol = this._colIndexes.size();
        DenseBlock tb = this._data.getDenseBlock();
        int row = rl;
        while (row < ru) {
            double[] values = tb.values(row);
            int offS = tb.pos(row);
            double[] c = db.values(offT);
            int off = db.pos(offT);
            for (int j = 0; j < nCol; ++j) {
                double v = values[offS + j];
                int n = off + j;
                c[n] = c[n] + v;
            }
            ++row;
            ++offT;
        }
    }

    private void decompressToDenseBlockSparseData(DenseBlock db, int rl, int ru, int offR, int offC) {
        SparseBlock sb = this._data.getSparseBlock();
        int row = rl;
        int offT = rl + offR;
        while (row < ru) {
            if (!sb.isEmpty(row)) {
                double[] c = db.values(offT);
                int off = db.pos(offT) + offC;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int col = apos; col < alen; ++col) {
                    int n = this._colIndexes.get(aix[col]) + off;
                    c[n] = c[n] + avals[col];
                }
            }
            ++row;
            ++offT;
        }
    }

    @Override
    public void decompressToSparseBlock(SparseBlock ret, int rl, int ru, int offR, int offC) {
        if (this._data.isInSparseFormat()) {
            this.decompressToSparseBlockSparseData(ret, rl, ru, offR, offC);
        } else {
            this.decompressToSparseBlockDenseData(ret, rl, ru, offR, offC);
        }
    }

    private void decompressToSparseBlockDenseData(SparseBlock ret, int rl, int ru, int offR, int offC) {
        int nCol = this._colIndexes.size();
        double[] values = this._data.getDenseBlockValues();
        int offS = rl * nCol;
        int row = rl;
        int offT = rl + offR;
        while (row < ru) {
            for (int j = 0; j < nCol; ++j) {
                ret.append(offT, offC + this._colIndexes.get(j), values[offS + j]);
            }
            ++row;
            ++offT;
            offS += nCol;
        }
    }

    private void decompressToSparseBlockSparseData(SparseBlock ret, int rl, int ru, int offR, int offC) {
        int offT = rl + offR;
        SparseBlock sb = this._data.getSparseBlock();
        int row = rl;
        while (row < ru) {
            if (!sb.isEmpty(row)) {
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int col = apos; col < alen; ++col) {
                    ret.append(offT, offC + this._colIndexes.get(aix[col]), avals[col]);
                }
            }
            ++row;
            ++offT;
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        return this._data.quickGetValue(r, colIdx);
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        int nCol = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] retV = result.getDenseBlockValues();
        if (matrix.isInSparseFormat()) {
            this.lmmNPSparse(matrix.getSparseBlock(), nCol, retV, nColRet, rl, ru, cl, cu);
        } else {
            DenseBlock db = matrix.getDenseBlock();
            if (db.isContiguous()) {
                this.lmmNPDense(db.values(0), nCol, retV, nColRet, rl, ru, cl, cu);
            } else {
                throw new NotImplementedException("Not implemented support for leftMultByMatrixNoPreAgg non contiguous dense matrix");
            }
        }
    }

    protected void lmmNPSparse(SparseBlock sb, int nCol, double[] retV, int nColRet, int rl, int ru, int cl, int cu) {
        if (cl != 0 || cu != this._data.getNumRows()) {
            throw new NotImplementedException();
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock dsb = this._data.getSparseBlock();
            for (int r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                int aposL = sb.pos(r);
                int alenL = sb.size(r) + aposL;
                int[] aixL = sb.indexes(r);
                double[] avalL = sb.values(r);
                int offR = r * nColRet;
                for (int j = aposL; j < alenL; ++j) {
                    int c = aixL[j];
                    if (dsb.isEmpty(c)) continue;
                    double v = avalL[j];
                    int apos = dsb.pos(c);
                    int alen = dsb.size(c) + apos;
                    int[] aix = dsb.indexes(c);
                    double[] aval = dsb.values(c);
                    for (int i = apos; i < alen; ++i) {
                        int n = offR + this._colIndexes.get(aix[i]);
                        retV[n] = retV[n] + v * aval[i];
                    }
                }
            }
        } else {
            double[] dV = this._data.getDenseBlockValues();
            int nColD = this._colIndexes.size();
            for (int r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                int aposL = sb.pos(r);
                int alenL = sb.size(r) + aposL;
                int[] aixL = sb.indexes(r);
                double[] avalL = sb.values(r);
                int offR = r * nColRet;
                for (int j = aposL; j < alenL; ++j) {
                    int c = aixL[j];
                    double v = avalL[j];
                    int offD = c * nColD;
                    for (int i = 0; i < nColD; ++i) {
                        int n = offR + this._colIndexes.get(i);
                        retV[n] = retV[n] + v * dV[offD + i];
                    }
                }
            }
        }
    }

    protected void lmmNPDense(double[] mV, int nCol, double[] retV, int nColRet, int rl, int ru, int cl, int cu) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int r = rl; r < ru; ++r) {
                int off = r * nCol;
                int offR = r * nColRet;
                for (int c = cl; c < cu; ++c) {
                    if (sb.isEmpty(c)) continue;
                    int apos = sb.pos(c);
                    int alen = sb.size(c) + apos;
                    int[] aix = sb.indexes(c);
                    double[] aval = sb.values(c);
                    double v = mV[off + c];
                    for (int i = apos; i < alen; ++i) {
                        int n = offR + this._colIndexes.get(aix[i]);
                        retV[n] = retV[n] + v * aval[i];
                    }
                }
            }
        } else {
            double[] dV = this._data.getDenseBlockValues();
            int nColD = this._colIndexes.size();
            for (int r = rl; r < ru; ++r) {
                int off = r * nCol;
                int offR = r * nColRet;
                for (int c = cl; c < cu; ++c) {
                    int offD = c * nColD;
                    double v = mV[off + c];
                    for (int i = 0; i < nColD; ++i) {
                        int n = offR + this._colIndexes.get(i);
                        retV[n] = retV[n] + v * dV[offD + i];
                    }
                }
            }
        }
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        MatrixBlock retContent = this._data.scalarOperations(op, new MatrixBlock());
        return ColGroupUncompressed.create(retContent, this.getColIndices());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        MatrixBlock retContent = this._data.unaryOperations(op, new MatrixBlock());
        return ColGroupUncompressed.create(retContent, this.getColIndices());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        LOG.warn((Object)"Binary row op left is not supported for Uncompressed Matrix, Implement support for VMr in MatrixBlock Binary Cell operations");
        MatrixBlockDictionary d = MatrixBlockDictionary.create(this._data);
        IDictionary dm = d.binOpLeft(op, v, this._colIndexes);
        if (dm == null) {
            return ColGroupUncompressed.create(null, this._colIndexes);
        }
        return ColGroupUncompressed.create(((MatrixBlockDictionary)dm).getMatrixBlock(), this._colIndexes);
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        MatrixBlock rowVector = Util.extractValues(v, this._colIndexes);
        return ColGroupUncompressed.create(this._data.binaryOperations(op, rowVector, null), this._colIndexes);
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, double[] result, int nRows, int rl, int ru) {
        ValueFunction fn = op.aggOp.increOp.fn;
        if (fn instanceof Multiply && op.indexFn instanceof ReduceAll && result[0] == 0.0) {
            return;
        }
        if (fn instanceof Builtin && ((Builtin)fn).getBuiltinCode() == Builtin.BuiltinCode.MAXINDEX || fn instanceof CM) {
            throw new DMLRuntimeException("Not supported type of Unary Aggregate on colGroup");
        }
        MatrixBlock tmpData = rl == 0 && ru == nRows ? this._data : this._data.slice(rl, ru - 1, false);
        MatrixBlock tmp = tmpData.aggregateUnaryOperations(op, new MatrixBlock(), tmpData.getNumRows(), new MatrixIndexes(1L, 1L), true);
        if (tmp.isEmpty()) {
            if (op.aggOp.increOp.fn instanceof Builtin) {
                Builtin b = (Builtin)op.aggOp.increOp.fn;
                if (op.indexFn instanceof ReduceRow) {
                    for (int i = 0; i < this._colIndexes.size(); ++i) {
                        result[this._colIndexes.get((int)i)] = b.execute(result[this._colIndexes.get(i)], 0.0);
                    }
                } else if (op.indexFn instanceof ReduceAll) {
                    result[0] = b.execute(result[0], 0.0);
                } else {
                    for (int row = rl; row < ru; ++row) {
                        result[row] = b.execute(result[row], 0.0);
                    }
                }
            } else if (op.aggOp.increOp.fn instanceof Multiply) {
                if (op.indexFn instanceof ReduceRow) {
                    for (int i = 0; i < this._colIndexes.size(); ++i) {
                        result[this._colIndexes.get((int)i)] = 0.0;
                    }
                } else if (op.indexFn instanceof ReduceAll) {
                    result[0] = 0.0;
                } else {
                    Arrays.fill(result, rl, ru, 0.0);
                }
            }
            return;
        }
        tmp.sparseToDense();
        double[] tmpV = tmp.getDenseBlockValues();
        if (op.aggOp.increOp.fn instanceof Builtin) {
            Builtin b = (Builtin)op.aggOp.increOp.fn;
            if (op.indexFn instanceof ReduceRow) {
                for (int i = 0; i < tmpV.length; ++i) {
                    result[this._colIndexes.get((int)i)] = b.execute(result[this._colIndexes.get(i)], tmpV[i]);
                }
            } else if (op.indexFn instanceof ReduceAll) {
                result[0] = b.execute(result[0], tmpV[0]);
            } else {
                int i = 0;
                for (int row = rl; row < ru; ++row) {
                    result[row] = b.execute(result[row], tmpV[i]);
                    ++i;
                }
            }
        } else if (op.aggOp.increOp.fn instanceof Multiply) {
            if (op.indexFn instanceof ReduceRow) {
                for (int i = 0; i < tmpV.length; ++i) {
                    result[this._colIndexes.get((int)i)] = tmpV[i];
                }
            } else if (op.indexFn instanceof ReduceAll) {
                result[0] = result[0] * tmpV[0];
            } else {
                int i = 0;
                int row = rl;
                while (row < ru) {
                    int n = row++;
                    result[n] = result[n] * tmpV[i];
                    ++i;
                }
            }
        } else if (op.indexFn instanceof ReduceRow) {
            for (int i = 0; i < tmpV.length; ++i) {
                int n = this._colIndexes.get(i);
                result[n] = result[n] + tmpV[i];
            }
        } else if (op.indexFn instanceof ReduceAll) {
            result[0] = result[0] + tmpV[0];
        } else {
            int i = 0;
            int row = rl;
            while (row < ru) {
                int n = row++;
                result[n] = result[n] + tmpV[i];
                ++i;
            }
        }
    }

    public static ColGroupUncompressed read(DataInput in) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        MatrixBlock data = new MatrixBlock();
        data.readFields(in);
        return new ColGroupUncompressed(data, cols);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._data.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        return super.getExactSizeOnDisk() + this._data.getExactSizeOnDisk();
    }

    @Override
    public double getMin() {
        return this._data.min();
    }

    @Override
    public double getMax() {
        return this._data.max();
    }

    @Override
    public double getSum(int nRows) {
        return this._data.sum();
    }

    @Override
    public final void tsmm(MatrixBlock ret, int nRows) {
        int tCol = this._colIndexes.size();
        MatrixBlock tmp = new MatrixBlock(tCol, tCol, true);
        LibMatrixMult.matrixMultTransposeSelf(this._data, tmp, true, false);
        if (tmp.isInSparseFormat()) {
            int numColumns = ret.getNumColumns();
            double[] result = ret.getDenseBlockValues();
            SparseBlock sb = tmp.getSparseBlock();
            for (int row = 0; row < tCol; ++row) {
                int offRet = this._colIndexes.get(row) * numColumns;
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] aval = sb.values(row);
                for (int j = apos; j < alen; ++j) {
                    int n = offRet + this._colIndexes.get(aix[j]);
                    result[n] = result[n] + aval[j];
                }
            }
        } else {
            int numColumns = ret.getNumColumns();
            double[] result = ret.getDenseBlockValues();
            double[] tmpV = tmp.getDenseBlockValues();
            int row = 0;
            int offTmp = 0;
            while (row < tCol) {
                int offRet = this._colIndexes.get(row) * numColumns;
                for (int col = row; col < tCol; ++col) {
                    int n = offRet + this._colIndexes.get(col);
                    result[n] = result[n] + tmpV[offTmp + col];
                }
                ++row;
                offTmp += tCol;
            }
        }
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        return this._data.getNonZeros();
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock result, int nRows) {
        if (lhs instanceof ColGroupUncompressed) {
            this.leftMultByAColGroupUncompressed((ColGroupUncompressed)lhs, result);
        } else if (lhs instanceof APreAgg) {
            this.leftMultByAPreAggColGroup((APreAgg)lhs, result);
        } else {
            throw new DMLCompressionException("Not supported leftMult colgroup type: " + lhs.getClass().getSimpleName());
        }
    }

    private void leftMultByAPreAggColGroup(APreAgg paCG, MatrixBlock result) {
        int nCols = paCG.getNumCols();
        MatrixBlock dictM = paCG._dict.getMBDict(nCols).getMatrixBlock();
        if (dictM == null) {
            return;
        }
        if (paCG.getNumCols() != 1) {
            LOG.warn((Object)"\nInefficient transpose of uncompressed to fit to t(AColGroup) %*% UncompressedColGroup mult by colGroup uncompressed column\nCurrently solved by t(t(Uncompressed) %*% AColGroup)");
        }
        int k = InfrastructureAnalyzer.getLocalParallelism();
        MatrixBlock ucCGT = LibMatrixReorg.transpose(this.getData(), k);
        MatrixBlock preAgg = new MatrixBlock(1, paCG.getNumValues(), false);
        MatrixBlock tmpRes = new MatrixBlock(1, nCols, false);
        preAgg.allocateDenseBlock();
        tmpRes.allocateDenseBlock();
        int nRowsTransposed = ucCGT.getNumRows();
        double[] retV = result.getDenseBlockValues();
        double[] tmpV = tmpRes.getDenseBlockValues();
        int retCols = result.getNumColumns();
        for (int i = 0; i < nRowsTransposed; ++i) {
            if (ucCGT.isInSparseFormat() && ucCGT.getSparseBlock().isEmpty(i)) continue;
            paCG.preAggregate(ucCGT, preAgg.getDenseBlockValues(), i, i + 1);
            preAgg.recomputeNonZeros();
            if (preAgg.isEmpty()) continue;
            LibMatrixMult.matrixMult(preAgg, dictM, tmpRes, true);
            int rowOut = this._colIndexes.get(i);
            for (int j = 0; j < nCols; ++j) {
                int colOut = paCG._colIndexes.get(j) * retCols;
                int n = rowOut + colOut;
                retV[n] = retV[n] + tmpV[j];
            }
            if (i >= nRowsTransposed - 1) continue;
            preAgg.reset(1, paCG.getPreAggregateSize());
            tmpRes.reset(1, nCols);
        }
    }

    private void leftMultByAColGroupUncompressed(ColGroupUncompressed lhs, MatrixBlock result) {
        MatrixBlock tmpRet = new MatrixBlock(lhs.getNumCols(), this._colIndexes.size(), 0L);
        int k = InfrastructureAnalyzer.getLocalParallelism();
        if (lhs._data.getNumColumns() != 1) {
            LOG.warn((Object)"Inefficient Left Matrix Multiplication with transpose of left hand side : t(l) %*% r");
        }
        MatrixBlock lhData = lhs._data;
        MatrixBlock transposed = LibMatrixReorg.transpose(lhData, k);
        transposed.setNonZeros(lhData.getNonZeros());
        LibMatrixMult.matrixMult(transposed, this._data, tmpRet);
        double[] resV = result.getDenseBlockValues();
        int nColOut = result.getNumColumns();
        if (tmpRet.isInSparseFormat()) {
            SparseBlock sb = tmpRet.getSparseBlock();
            for (int row = 0; row < lhs._colIndexes.size(); ++row) {
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                int offRes = lhs._colIndexes.get(row) * nColOut;
                for (int col = apos; col < alen; ++col) {
                    int n = offRes + this._colIndexes.get(aix[col]);
                    resV[n] = resV[n] + avals[col];
                }
            }
        } else {
            double[] tmpRetV = tmpRet.getDenseBlockValues();
            for (int row = 0; row < lhs._colIndexes.size(); ++row) {
                int offRes = lhs._colIndexes.get(row) * nColOut;
                int offTmp = this._colIndexes.size() * row;
                for (int col = 0; col < this._colIndexes.size(); ++col) {
                    int n = offRes + this._colIndexes.get(col);
                    resV[n] = resV[n] + tmpRetV[offTmp + col];
                }
            }
        }
    }

    @Override
    public void tsmmAColGroup(AColGroup lhs, MatrixBlock result) {
        if (lhs instanceof ColGroupUncompressed) {
            this.tsmmUncompressedColGroup((ColGroupUncompressed)lhs, result);
        } else {
            lhs.tsmmAColGroup(this, result);
        }
    }

    private void tsmmUncompressedColGroup(ColGroupUncompressed lhs, MatrixBlock result) {
        MatrixBlock tmpRet = new MatrixBlock(lhs.getNumCols(), this._colIndexes.size(), 0L);
        int k = InfrastructureAnalyzer.getLocalParallelism();
        if (lhs._data == this._data) {
            LibMatrixMult.matrixMultTransposeSelf(this._data, tmpRet, true, k);
        } else {
            LOG.warn((Object)"Inefficient Left Matrix Multiplication with transpose of left hand side : t(l) %*% r");
            LibMatrixMult.matrixMult(LibMatrixReorg.transpose(lhs._data, k), this._data, tmpRet);
        }
        double[] resV = result.getDenseBlockValues();
        int nCols = result.getNumColumns();
        if (tmpRet.isInSparseFormat()) {
            SparseBlock sb = tmpRet.getSparseBlock();
            for (int row = 0; row < lhs._colIndexes.size(); ++row) {
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row) + apos;
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int col = apos; col < alen; ++col) {
                    DictLibMatrixMult.addToUpperTriangle(nCols, lhs._colIndexes.get(row), this._colIndexes.get(aix[col]), resV, avals[col]);
                }
            }
        } else {
            double[] tmpRetV = tmpRet.getDenseBlockValues();
            for (int row = 0; row < lhs._colIndexes.size(); ++row) {
                int offTmp = lhs._colIndexes.size() * row;
                int oid = lhs._colIndexes.get(row);
                for (int col = 0; col < this._colIndexes.size(); ++col) {
                    DictLibMatrixMult.addToUpperTriangle(nCols, oid, this._colIndexes.get(col), resV, tmpRetV[offTmp + col]);
                }
            }
        }
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        return this.sliceMultiColumns(idx, idx + 1, ColIndexFactory.create(1));
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, IColIndex outputCols) {
        MatrixBlock newData = this._data.slice(0, this._data.getNumRows() - 1, idStart, idEnd - 1, true);
        return ColGroupUncompressed.create(newData, outputCols);
    }

    @Override
    public AColGroup rightMultByMatrix(MatrixBlock right, IColIndex allCols) {
        MatrixBlock subBlockRight;
        IColIndex outputCols;
        int nColR = right.getNumColumns();
        IColIndex iColIndex = outputCols = allCols != null ? allCols : ColIndexFactory.create(nColR);
        if (right.isEmpty()) {
            return null;
        }
        if (right.isInSparseFormat()) {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, true);
            subBlockRight.allocateSparseRowsBlock();
            SparseBlock sbR = right.getSparseBlock();
            SparseBlock subR = subBlockRight.getSparseBlock();
            long nnz = 0L;
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                if (sbR.isEmpty(this._colIndexes.get(i))) continue;
                subR.set(i, sbR.get(this._colIndexes.get(i)), false);
                nnz += (long)sbR.get(this._colIndexes.get(i)).size();
            }
            subBlockRight.setNonZeros(nnz);
        } else {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, false);
            subBlockRight.allocateDenseBlock();
            double[] sbr = subBlockRight.getDenseBlockValues();
            double[] rightV = right.getDenseBlockValues();
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                int offSubBlock = i * nColR;
                int offRight = this._colIndexes.get(i) * nColR;
                System.arraycopy(rightV, offRight, sbr, offSubBlock, nColR);
            }
            subBlockRight.setNonZeros(this._data.getNumColumns() * nColR);
        }
        MatrixBlock out = new MatrixBlock(this._data.getNumRows(), nColR, false);
        LibMatrixMult.matrixMult(this._data, subBlockRight, out, InfrastructureAnalyzer.getLocalParallelism());
        return ColGroupUncompressed.create(out, outputCols);
    }

    @Override
    public int getNumValues() {
        return this._data.getNumRows();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        MatrixBlock replaced = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return ColGroupUncompressed.create(replaced, this._colIndexes);
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        MatrixBlock colSum = this._data.colSum();
        if (colSum.isInSparseFormat()) {
            SparseBlock sb = colSum.getSparseBlock();
            double[] rv = sb.values(0);
            int[] idx = sb.indexes(0);
            for (int i = 0; i < idx.length; ++i) {
                int n = this._colIndexes.get(idx[i]);
                c[n] = c[n] + rv[i];
            }
        } else {
            double[] dv = colSum.getDenseBlockValues();
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                int n = this._colIndexes.get(i);
                c[n] = c[n] + dv[i];
            }
        }
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._data.cmOperations(op);
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        MatrixBlock nd = LibMatrixReorg.rexpand(this._data, new MatrixBlock(), max, false, cast, ignore, 1);
        return ColGroupUncompressed.create(nd, ColIndexFactory.create(max));
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        return e.getCost(nRows, nRows, nCols, nVals, this._data.getSparsity());
    }

    @Override
    public boolean isEmpty() {
        return this._data.isEmpty();
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        MatrixBlock mb = this._data.slice(rl, ru - 1);
        if (mb.isEmpty()) {
            return null;
        }
        return new ColGroupUncompressed(mb, this._colIndexes);
    }

    @Override
    public AColGroup append(AColGroup g) {
        if (g instanceof ColGroupUncompressed && g.getColIndices().equals(this._colIndexes)) {
            ColGroupUncompressed gDDC = (ColGroupUncompressed)g;
            MatrixBlock nd = this._data.append(gDDC._data, false);
            return ColGroupUncompressed.create(nd, this._colIndexes);
        }
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        MatrixBlock ret = new MatrixBlock(rlen, this._colIndexes.size(), this._data.isInSparseFormat());
        ret.allocateBlock();
        SparseBlock sb = ret.getSparseBlock();
        DenseBlock db = ret.getDenseBlock();
        IColIndex target = ColIndexFactory.create(this._colIndexes.size());
        for (int i = 0; i < g.length; ++i) {
            int start = i * blen;
            int end = Math.min(i * blen + blen, rlen);
            AColGroup gs = g[i];
            if (this._data.isInSparseFormat()) {
                gs.copyAndSet(target).decompressToSparseBlock(sb, 0, end - start, start, 0);
                continue;
            }
            gs.copyAndSet(target).decompressToDenseBlock(db, 0, end - start, start, 0);
        }
        ret.recomputeNonZeros();
        return new ColGroupUncompressed(ret, this._colIndexes);
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return SchemeFactory.create(this._colIndexes, AColGroup.CompressionType.UNCOMPRESSED);
    }

    @Override
    public AColGroup recompress() {
        MatrixBlock mb = (MatrixBlock)CompressedMatrixBlockFactory.compress(this._data).getLeft();
        if (mb instanceof CompressedMatrixBlock) {
            CompressedMatrixBlock cmb = (CompressedMatrixBlock)mb;
            List<AColGroup> gs = cmb.getColGroups();
            if (gs.size() > 1) {
                LOG.error((Object)"The uncompressed column group did compress into multiple groups");
                return this;
            }
            return gs.get(0).copyAndSet(this._colIndexes);
        }
        return this;
    }

    @Override
    public CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        IEncode map = EncodingFactory.createFromMatrixBlock(this._data, false, ColIndexFactory.create(this._data.getNumColumns()));
        int _numRows = this._data.getNumRows();
        CompressionSettings _cs = new CompressionSettingsBuilder().create();
        EstimationFactors em = map.extractFacts(_numRows, this._data.getSparsity(), this._data.getSparsity(), _cs);
        return new CompressedSizeInfoColGroup(this._colIndexes, em, _cs.validCompressions, map);
    }

    @Override
    public AColGroup copyAndSet(IColIndex colIndexes) {
        return new ColGroupUncompressed(this._data, colIndexes);
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), this._data.getNonZeros());
        for (int r = 0; r < this._data.getNumRows(); ++r) {
            for (int c = 0; c < this._data.getNumColumns(); ++c) {
                ret.quickSetValue(r, c, this._data.quickGetValue(r, reordering[c]));
            }
        }
        return ColGroupUncompressed.create(newColIndex, ret, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n");
        sb.append(" numCols : " + this._data.getNumColumns());
        sb.append(" numRows : " + this._data.getNumRows());
        sb.append(" nonZeros: " + this._data.getNonZeros());
        sb.append(" Sparse : " + this._data.isInSparseFormat());
        sb.append("\n");
        if (this._data.getNumRows() < 1000) {
            sb.append(this._data.toString());
        } else {
            sb.append(" don't print uncompressed matrix because it is to big.");
        }
        return sb.toString();
    }
}

