/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;

public class OptionalArray<T>
extends Array<T> {
    protected Array<T> _a;
    protected ABooleanArray _n;

    public OptionalArray(T[] a) {
        super(a.length);
        if (a instanceof Boolean[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.BOOLEAN, a.length);
        } else if (a instanceof Integer[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.INT32, a.length);
        } else if (a instanceof Double[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.FP64, a.length);
        } else if (a instanceof Float[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.FP32, a.length);
        } else if (a instanceof Long[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.INT64, a.length);
        } else if (a instanceof Character[]) {
            this._a = ArrayFactory.allocate(Types.ValueType.CHARACTER, a.length);
        } else {
            throw new DMLRuntimeException("Invalid type for Optional Array: " + a.getClass().getSimpleName());
        }
        this._n = ArrayFactory.allocateBoolean(a.length);
        for (int i = 0; i < a.length; ++i) {
            this._a.set(i, a[i]);
            this._n.set(i, a[i] != null);
        }
    }

    public OptionalArray(Array<T> a, boolean empty) {
        super(a.size());
        if (a instanceof OptionalArray) {
            throw new DMLRuntimeException("Not allowed optional optional array");
        }
        if (a instanceof StringArray) {
            throw new DMLRuntimeException("Not allowed StringArray in OptionalArray");
        }
        this._a = a;
        this._n = ArrayFactory.allocateBoolean(a.size());
        if (!empty) {
            this._n.fill(true);
        }
    }

    public OptionalArray(Array<T> a, ABooleanArray n) {
        super(a.size());
        if (a instanceof OptionalArray) {
            throw new DMLRuntimeException("Not allowed optional optional array");
        }
        if (a instanceof StringArray) {
            throw new DMLRuntimeException("Not allowed StringArray in OptionalArray");
        }
        if (n.size() != a.size()) {
            throw new DMLRuntimeException("Incompatible sizes of arrays for optional array");
        }
        this._a = a;
        this._n = n;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.OPTIONAL.ordinal());
        this._a.write(out);
        this._n.write(out);
    }

    @Override
    public long getExactSerializedSize() {
        return 1L + this._a.getExactSerializedSize() + this._n.getExactSerializedSize();
    }

    public void readFields(DataInput in) throws IOException {
        throw new DMLRuntimeException("Should not be called");
    }

    protected static OptionalArray<?> readOpt(DataInput in, int nRow) throws IOException {
        Array<?> a = ArrayFactory.read(in, nRow);
        ABooleanArray n = (ABooleanArray)ArrayFactory.read(in, nRow);
        switch (a.getValueType()) {
            case BOOLEAN: {
                return new OptionalArray(a, n);
            }
            case FP32: {
                return new OptionalArray(a, n);
            }
            case FP64: {
                return new OptionalArray(a, n);
            }
            case UINT8: 
            case INT32: {
                return new OptionalArray(a, n);
            }
            case INT64: {
                return new OptionalArray(a, n);
            }
        }
        return new OptionalArray(a, n);
    }

    @Override
    public T get(int index) {
        return (Boolean)this._n.get(index) != false ? (T)this._a.get(index) : null;
    }

    @Override
    public Object get() {
        return this._a.get();
    }

    @Override
    public double getAsDouble(int i) {
        return (Boolean)this._n.get(i) != false ? this._a.getAsDouble(i) : 0.0;
    }

    @Override
    public double getAsNaNDouble(int i) {
        return (Boolean)this._n.get(i) != false ? this._a.getAsDouble(i) : Double.NaN;
    }

    @Override
    public void set(int index, T value) {
        if (value == null) {
            this._n.set(index, false);
        } else {
            this._n.set(index, true);
            this._a.set(index, value);
        }
    }

    @Override
    public void set(int index, double value) {
        this._a.set(index, value);
        this._n.set(index, true);
    }

    @Override
    public void set(int index, String value) {
        if (value == null) {
            this._n.set(index, false);
        } else {
            this._a.set(index, value);
            this._n.set(index, true);
        }
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            Object o = value.get(i);
            if (o == null) {
                this._n.set(i, false);
                continue;
            }
            this._a.set(i, UtilFunctions.objectToString(value.get(i)));
            this._n.set(i, true);
        }
    }

    @Override
    public void set(int rl, int ru, Array<T> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void set(int rl, int ru, Array<T> value, int rlSrc) {
        if (value instanceof OptionalArray) {
            this._a.set(rl, ru, OptionalArray.getBasic(value), rlSrc);
        } else {
            this._a.set(rl, ru, value, rlSrc);
        }
        ABooleanArray nulls = value.getNulls();
        if (nulls != null) {
            this._n.set(rl, ru, nulls, rlSrc);
        } else {
            for (int i = rl; i <= ru; ++i) {
                this._n.set(i, true);
            }
        }
    }

    private static <T> Array<T> getBasic(Array<T> value) {
        while (value instanceof OptionalArray) {
            value = ((OptionalArray)value)._a;
        }
        return value;
    }

    @Override
    public void setNz(int rl, int ru, Array<T> value) {
        for (int i = rl; i <= ru; ++i) {
            T v = value.get(i);
            if (v == null) continue;
            this.set(i, v);
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            String v = UtilFunctions.objectToString(value.get(i));
            if (v == null) continue;
            this.set(i, v);
        }
    }

    @Override
    public void append(String value) {
        this._n.append(value != null);
        this._a.append(value);
        this._size = this._a.size();
    }

    @Override
    public void append(T value) {
        this._n.append(value != null);
        this._a.append(value);
        this._size = this._a.size();
    }

    @Override
    public Array<T> append(Array<T> other) {
        OptionalArray<T> otherOpt = other instanceof OptionalArray ? (OptionalArray<T>)other : new OptionalArray<T>(other, false);
        ABooleanArray n = (ABooleanArray)this._n.append(otherOpt._n);
        Array<T> a = this._a.append(otherOpt._a);
        return new OptionalArray<T>(a, n);
    }

    public static <T> OptionalArray<T> appendOther(OptionalArray<T> that, Array<T> appended) {
        int endSize = appended.size();
        ABooleanArray nullsThat = that._n;
        ABooleanArray optsEnd = ArrayFactory.allocateBoolean(endSize);
        optsEnd.fill(true);
        optsEnd.set(endSize - that.size(), endSize - 1, nullsThat);
        return new OptionalArray<T>(appended, optsEnd);
    }

    @Override
    public Array<T> slice(int rl, int ru) {
        return new OptionalArray<T>(this._a.slice(rl, ru), this._n.slice(rl, ru));
    }

    @Override
    public void reset(int size) {
        this._size = size;
        this._a.reset(size);
        this._n.reset(size);
    }

    @Override
    public byte[] getAsByteArray() {
        return this._a.getAsByteArray();
    }

    @Override
    public Types.ValueType getValueType() {
        return this._a.getValueType();
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType() {
        return new Pair<Types.ValueType, Boolean>(this.getValueType(), true);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.OPTIONAL;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        Array<Boolean> a = this._a.changeTypeBitSet();
        return new OptionalArray<Boolean>(a, this._n);
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        Array<Boolean> a = this._a.changeTypeBoolean();
        return new OptionalArray<Boolean>(a, this._n);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        Array<Double> a = this._a.changeTypeDouble();
        return new OptionalArray<Double>(a, this._n);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        Array<Float> a = this._a.changeTypeFloat();
        return new OptionalArray<Float>(a, this._n);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        Array<Integer> a = this._a.changeTypeInteger();
        return new OptionalArray<Integer>(a, this._n);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        Array<Long> a = this._a.changeTypeLong();
        return new OptionalArray<Long>(a, this._n);
    }

    @Override
    protected Array<Character> changeTypeCharacter() {
        Array<Character> a = this._a.changeTypeCharacter();
        return new OptionalArray<Character>(a, this._n);
    }

    @Override
    protected Array<String> changeTypeString() {
        StringArray a = (StringArray)this._a.changeTypeString();
        String[] d = a.get();
        for (int i = 0; i < this._size; ++i) {
            if (((Boolean)this._n.get(i)).booleanValue()) continue;
            d[i] = null;
        }
        return a;
    }

    @Override
    public void fill(String val) {
        this._n.fill(val != null);
        this._a.fill(val);
    }

    @Override
    public void fill(T val) {
        this._n.fill(val != null);
        this._a.fill(val);
    }

    @Override
    public boolean isShallowSerialize() {
        return this._a.isShallowSerialize();
    }

    @Override
    public ABooleanArray getNulls() {
        return this._n;
    }

    @Override
    public Array<T> clone() {
        return new OptionalArray<T>(this._a.clone(), this._n.clone());
    }

    @Override
    public boolean isEmpty() {
        return !this._n.isAllTrue();
    }

    @Override
    public Array<T> select(int[] indices) {
        return new OptionalArray<T>(this._a.select(indices), this._n.select(indices));
    }

    @Override
    public Array<T> select(boolean[] select, int nTrue) {
        return new OptionalArray<T>(this._a.select(select, nTrue), this._n.select(select, nTrue));
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._n.isNotEmpty(i) && this._a.isNotEmpty(i);
    }

    @Override
    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        switch (t) {
            case BOOLEAN: {
                if (this.size() > 64) {
                    return this.changeTypeBitSet();
                }
                return this.changeTypeBoolean();
            }
            case FP32: {
                return this.changeTypeFloat();
            }
            case FP64: {
                return this.changeTypeDouble();
            }
            case UINT8: {
                throw new NotImplementedException();
            }
            case INT32: {
                return this.changeTypeInteger();
            }
            case INT64: {
                return this.changeTypeLong();
            }
            case CHARACTER: {
                return this.changeTypeCharacter();
            }
        }
        return this.changeTypeString();
    }

    @Override
    public boolean containsNull() {
        return !this._n.isAllTrue();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size + 2);
        sb.append(super.toString() + "<" + this._a.getClass().getSimpleName() + ">:[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this.get(i) + ",");
        }
        sb.append(this.get(this._size - 1));
        sb.append("]");
        return sb.toString();
    }
}

