/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlockTransposed
extends ReaderColumnSelection {
    private final double[] _data;

    protected ReaderColumnSelectionDenseSingleBlockTransposed(MatrixBlock data, int[] colIndexes, int rl, int ru) {
        super((int[])colIndexes.clone(), rl, Math.min(ru, data.getNumColumns()) - 1);
        this._data = data.getDenseBlockValues();
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this._colIndexes[i] = this._colIndexes[i] * data.getNumColumns();
        }
    }

    @Override
    protected DblArray getNextRow() {
        boolean empty = true;
        while (empty && this._rl < this._ru) {
            ++this._rl;
            for (int i = 0; i < this._colIndexes.length; ++i) {
                double v = this._data[this._colIndexes[i] + this._rl];
                empty &= v == 0.0;
                this.reusableArr[i] = v;
            }
        }
        return empty ? null : this.reusableReturn;
    }
}

