/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseMultiBlock;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseMultiBlockTransposed;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseSingleBlock;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionDenseSingleBlockTransposed;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionSparse;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelectionSparseTransposed;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ReaderColumnSelection {
    protected static final Log LOG = LogFactory.getLog((String)ReaderColumnSelection.class.getName());
    protected final int[] _colIndexes;
    protected final DblArray reusableReturn;
    protected final double[] reusableArr;
    protected final int _ru;
    protected int _rl;

    protected ReaderColumnSelection(int[] colIndexes, int rl, int ru) {
        this._colIndexes = colIndexes;
        this._rl = rl;
        this._ru = ru;
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    public final DblArray nextRow() {
        if (this._rl >= this._ru) {
            return null;
        }
        DblArray ret = this.getNextRow();
        if (ret != null) {
            ret.resetHash();
        }
        return ret;
    }

    protected abstract DblArray getNextRow();

    public int getCurrentRowIndex() {
        return this._rl;
    }

    public static ReaderColumnSelection createReader(MatrixBlock rawBlock, int[] colIndices, boolean transposed) {
        boolean rl = false;
        int ru = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        return ReaderColumnSelection.createReader(rawBlock, colIndices, transposed, 0, ru);
    }

    public static ReaderColumnSelection createReader(MatrixBlock rawBlock, int[] colIndices, boolean transposed, int rl, int ru) {
        ReaderColumnSelection.checkInput(rawBlock, colIndices, rl, ru);
        --rl;
        if (transposed) {
            if (rawBlock.isInSparseFormat()) {
                return new ReaderColumnSelectionSparseTransposed(rawBlock, colIndices, rl, ru);
            }
            if (rawBlock.getDenseBlock().numBlocks() > 1) {
                return new ReaderColumnSelectionDenseMultiBlockTransposed(rawBlock, colIndices, rl, ru);
            }
            return new ReaderColumnSelectionDenseSingleBlockTransposed(rawBlock, colIndices, rl, ru);
        }
        if (rawBlock.isInSparseFormat()) {
            return new ReaderColumnSelectionSparse(rawBlock, colIndices, rl, ru);
        }
        if (rawBlock.getDenseBlock().numBlocks() > 1) {
            return new ReaderColumnSelectionDenseMultiBlock(rawBlock, colIndices, rl, ru);
        }
        return new ReaderColumnSelectionDenseSingleBlock(rawBlock, colIndices, rl, ru);
    }

    private static void checkInput(MatrixBlock rawBlock, int[] colIndices, int rl, int ru) {
        if (colIndices.length <= 1) {
            throw new DMLCompressionException("Column selection reader should not be done on single column groups");
        }
        if (rawBlock.getSparseBlock() == null && rawBlock.getDenseBlock() == null) {
            throw new DMLCompressionException("Input Block was null");
        }
        if (rl >= ru) {
            throw new DMLCompressionException("Invalid inverse range for reader " + rl + " to " + ru);
        }
    }
}

