/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.DenseEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class SparseEncoding
implements IEncode {
    protected final AMapToData map;
    protected final AOffset off;
    protected final int nRows;
    protected final int zeroCount;

    protected SparseEncoding(AMapToData map, AOffset off, int zeroCount, int nRows) {
        this.map = map;
        this.off = off;
        this.zeroCount = zeroCount;
        this.nRows = nRows;
        if (off.getOffsetToLast() > nRows) {
            throw new DMLCompressionException("Invalid Sparse Encoding because offsets are calculated incorrectly");
        }
    }

    @Override
    public IEncode combine(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return this;
        }
        if (e instanceof SparseEncoding) {
            SparseEncoding es = (SparseEncoding)e;
            if (es.off == this.off && es.map == this.map) {
                return this;
            }
            return this.combineSparse((SparseEncoding)e);
        }
        return e.combine(this);
    }

    protected IEncode combineSparse(SparseEncoding e) {
        int sr;
        if (e.nRows != this.nRows) {
            throw new DMLCompressionException("invalid number of rows");
        }
        int maxUnique = e.getUnique() * this.getUnique();
        int[] d = new int[maxUnique - 1];
        int fl = this.off.getOffsetToLast();
        int fr = e.off.getOffsetToLast();
        AIterator itl = this.off.getIterator();
        AIterator itr = e.off.getIterator();
        int nVl = this.getUnique();
        int nVr = e.getUnique();
        int sl = this.map.size();
        if (sl + (sr = e.map.size()) > this.nRows / 2) {
            return SparseEncoding.combineSparseToDense(this.map, e.map, itl, itr, fl, fr, nVl, nVr, d, this.nRows, maxUnique);
        }
        IntArrayList retOff = new IntArrayList(Math.max(sr, sl));
        IntArrayList tmpVals = new IntArrayList(Math.max(sr, sl));
        int unique = SparseEncoding.combineSparse(this.map, e.map, itl, itr, retOff, tmpVals, fl, fr, nVl, nVr, d);
        if (retOff.size() < this.nRows / 4) {
            try {
                AOffset o = OffsetFactory.createOffset(retOff);
                AMapToData retMap = MapToFactory.create(tmpVals.size(), tmpVals.extractValues(), unique - 1);
                return new SparseEncoding(retMap, o, this.nRows - retOff.size(), this.nRows);
            }
            catch (Exception ex) {
                throw new DMLCompressionException("Failed combining sparse " + retOff + " " + this + "  " + e, ex);
            }
        }
        AMapToData retMap = MapToFactory.create(this.nRows, unique);
        for (int i = 0; i < retOff.size(); ++i) {
            retMap.set(retOff.get(i), tmpVals.get(i) + 1);
        }
        return new DenseEncoding(retMap);
    }

    private static int combineSparse(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, IntArrayList retOff, IntArrayList tmpVals, int fl, int fr, int nVl, int nVr, int[] d) {
        int defR = (nVr - 1) * nVl;
        int defL = nVl - 1;
        int newUID = 1;
        int il = itl.value();
        int ir = itr.value();
        if (il == fl && ir == fr) {
            if (fl == fr) {
                int nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                return SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
            }
            if (fl < fr) {
                newUID = SparseEncoding.addVal(lMap.getIndex(itl.getDataIndex()) + defR, il, d, newUID, tmpVals, retOff);
                return SparseEncoding.addVal(rMap.getIndex(itr.getDataIndex()) * nVl + defL, ir, d, newUID, tmpVals, retOff);
            }
            newUID = SparseEncoding.addVal(rMap.getIndex(itr.getDataIndex()) * nVl + defL, ir, d, newUID, tmpVals, retOff);
            return SparseEncoding.addVal(lMap.getIndex(itl.getDataIndex()) + defR, il, d, newUID, tmpVals, retOff);
        }
        while (il < fl && ir < fr) {
            int nv;
            if (il == ir) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
                ir = itr.next();
                continue;
            }
            if (il < ir) {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
                continue;
            }
            nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
            newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
            ir = itr.next();
        }
        newUID = SparseEncoding.combineSparseTail(lMap, rMap, itl, itr, retOff, tmpVals, fl, fr, nVl, nVr, d, newUID);
        return newUID;
    }

    private static int combineSparseTail(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, IntArrayList retOff, IntArrayList tmpVals, int fl, int fr, int nVl, int nVr, int[] d, int newUID) {
        block11: {
            int nv;
            int ir;
            int defL;
            int defR;
            block10: {
                int nv2;
                defR = (nVr - 1) * nVl;
                defL = nVl - 1;
                int il = itl.value();
                ir = itr.value();
                if (il >= fl) break block10;
                while (il < fr && il < fl) {
                    nv2 = lMap.getIndex(itl.getDataIndex()) + defR;
                    newUID = SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                    il = itl.next();
                }
                if (fl == fr) {
                    nv2 = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                    return SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                }
                if (il == fr) {
                    nv2 = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                    newUID = SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                    il = itl.next();
                } else {
                    nv2 = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                    newUID = SparseEncoding.addVal(nv2, fr, d, newUID, tmpVals, retOff);
                }
                while (il < fl) {
                    nv2 = lMap.getIndex(itl.getDataIndex()) + defR;
                    newUID = SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                    il = itl.next();
                }
                break block11;
            }
            if (ir >= fr) break block11;
            while (ir < fl && ir < fr) {
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            }
            if (fr == fl) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                return SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
            }
            if (ir == fl) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            } else {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, fl, d, newUID, tmpVals, retOff);
            }
            while (ir < fr) {
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            }
        }
        return newUID;
    }

    private static int addVal(int nv, int offset, int[] d, int newUID, IntArrayList tmpVals, IntArrayList offsets) {
        int mapV = d[nv];
        if (mapV == 0) {
            d[nv] = newUID++;
            mapV = d[nv];
        }
        tmpVals.appendValue(mapV - 1);
        offsets.appendValue(offset);
        return newUID;
    }

    private static DenseEncoding combineSparseToDense(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, int fl, int fr, int nVl, int nVr, int[] d, int nRows, int maxUnique) {
        AMapToData retMap = MapToFactory.create(nRows, (nVl + 1) * (nVr + 1));
        int il = itl.value();
        while (il < fl) {
            retMap.set(il, lMap.getIndex(itl.getDataIndex()) + 1);
            il = itl.next();
        }
        retMap.set(fl, lMap.getIndex(itl.getDataIndex()) + 1);
        int ir = itr.value();
        while (ir < fr) {
            int vl = retMap.getIndex(ir);
            int vr = rMap.getIndex(itr.getDataIndex()) + 1;
            retMap.set(ir, vl + vr * nVl);
            ir = itr.next();
        }
        retMap.set(fr, retMap.getIndex(fr) + (rMap.getIndex(itr.getDataIndex()) + 1) * nVl);
        AMapToData tmpMap = MapToFactory.create(maxUnique, maxUnique + 1);
        int newUID = 1;
        for (int r = 0; r < retMap.size(); ++r) {
            int nv = retMap.getIndex(r);
            int mv = tmpMap.getIndex(nv);
            if (mv == 0) {
                mv = tmpMap.setAndGet(nv, newUID++);
            }
            retMap.set(r, mv - 1);
        }
        retMap.setUnique(newUID - 1);
        return new DenseEncoding(retMap);
    }

    @Override
    public int getUnique() {
        return this.map.getUnique() + 1;
    }

    @Override
    public EstimationFactors extractFacts(int[] cols, int nRows, double tupleSparsity, double matrixSparsity) {
        int largestOffs = nRows - this.map.size();
        tupleSparsity = Math.min((double)this.map.size() / (double)nRows, tupleSparsity);
        int[] counts = this.map.getCounts(new int[this.map.getUnique()]);
        return new EstimationFactors(cols.length, this.map.getUnique(), this.map.size(), largestOffs, counts, 0, nRows, false, true, matrixSparsity, tupleSparsity);
    }

    @Override
    public boolean isDense() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("mapping: ");
        sb.append(this.map);
        sb.append("\n");
        sb.append("offsets: ");
        sb.append(this.off);
        return sb.toString();
    }
}

