/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u001df!\u0002\u0017.\u0001=*\u0004\u0002\u0003\"\u0001\u0005\u0003\u0007I\u0011\u0001#\t\u0011-\u0003!\u00111A\u0005\u00021C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006K!\u0012\u0005\t'\u0002\u0011\t\u0019!C\u0001\t\"AA\u000b\u0001BA\u0002\u0013\u0005Q\u000b\u0003\u0005X\u0001\t\u0005\t\u0015)\u0003F\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u000b\u0005\u0004A\u0011\u00012\t\u000f%\u0004!\u0019!C\u0001U\"1a\u000e\u0001Q\u0001\n-DQa\u001c\u0001\u0005\u0002ADQA \u0001\u0005\u0002}Dq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t\t\n\u0001C\u0001\u0003_Cq!!0\u0001\t\u0003\ty\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\tI\u0010\u0001C\u0001\u0003wDqA!\u0002\u0001\t\u0003\u00119\u0001C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B\u001d\u0001\u0011\u0005!1\b\u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0001\u0005\u001bBqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003v\u0001!\tAa\u001e\t\u000f\te\u0004\u0001\"\u0003\u0003|\u001dA!qQ\u0017\t\u0002=\u0012IIB\u0004-[!\u0005qFa#\t\r\u00054C\u0011\u0001BG\u0011%\u0011yI\nb\u0001\n\u0003\u0011\t\n\u0003\u0005\u0003\"\u001a\u0002\u000b\u0011\u0002BJ\u0011%\u0011\u0019K\nb\u0001\n\u0003\u0011\t\n\u0003\u0005\u0003&\u001a\u0002\u000b\u0011\u0002BJ\u0005I\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0006\u001cH/\u001a:\u000b\u00059z\u0013aB:u_J\fw-\u001a\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sON\u0019\u0001A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\ti\u0004)D\u0001?\u0015\tyt&\u0001\u0005j]R,'O\\1m\u0013\t\teHA\u0004M_\u001e<\u0017N\\4\u0002\u001d\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oi\u000e\u0001Q#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!{\u0013a\u0001:qG&\u0011!j\u0012\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0003I!'/\u001b<fe\u0016sG\r]8j]R|F%Z9\u0015\u00055\u0003\u0006CA\u001cO\u0013\ty\u0005H\u0001\u0003V]&$\bbB)\u0003\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014a\u00043sSZ,'/\u00128ea>Lg\u000e\u001e\u0011\u0002/\u0011\u0014\u0018N^3s\u0011\u0016\f'\u000f\u001e2fCR,e\u000e\u001a)pS:$\u0018a\u00073sSZ,'\u000fS3beR\u0014W-\u0019;F]\u0012\u0004v.\u001b8u?\u0012*\u0017\u000f\u0006\u0002N-\"9\u0011+BA\u0001\u0002\u0004)\u0015\u0001\u00073sSZ,'\u000fS3beR\u0014W-\u0019;F]\u0012\u0004v.\u001b8uA\u0005!1m\u001c8g!\tQ6,D\u00010\u0013\tavFA\u0005Ta\u0006\u00148nQ8oM\u0006A\u0011n\u001d#sSZ,'\u000f\u0005\u00028?&\u0011\u0001\r\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)1-\u001a4hQB\u0011A\rA\u0007\u0002[!)!)\u0003a\u0001\u000b\")1+\u0003a\u0001\u000b\")\u0001,\u0003a\u00013\")Q,\u0003a\u0001=\u00069A/[7f_V$X#A6\u0011\u0005\u0019c\u0017BA7H\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f^\u0001\ti&lWm\\;uA\u0005q!/Z7pm\u0016,\u00050Z2vi>\u0014HCA'r\u0011\u0015\u0011H\u00021\u0001t\u0003\u0019)\u00070Z2JIB\u0011Ao\u001f\b\u0003kf\u0004\"A\u001e\u001d\u000e\u0003]T!\u0001_\"\u0002\rq\u0012xn\u001c;?\u0013\tQ\b(\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>9\u0003e!WmY8n[&\u001c8/[8o\u00052|7m['b]\u0006<WM]:\u0015\u00075\u000b\t\u0001C\u0004\u0002\u00045\u0001\r!!\u0002\u0002\u0017\u0015DXmY;u_JLEm\u001d\t\u0006\u0003\u000f\t\tb\u001d\b\u0005\u0003\u0013\tiAD\u0002w\u0003\u0017I\u0011!O\u0005\u0004\u0003\u001fA\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u00049\u0003q9W\r\u001e*fa2L7-\u0019;f\u0013:4wNR8s%\u0012#%\t\\8dWN$B!a\u0007\u0002<A1\u0011qAA\t\u0003;\u0001B!a\b\u000269!\u0011\u0011EA\u0019\u001d\u0011\t\u0019#a\f\u000f\t\u0005\u0015\u0012Q\u0006\b\u0005\u0003O\tYCD\u0002w\u0003SI\u0011\u0001N\u0005\u0003eMJ!\u0001M\u0019\n\u00059z\u0013bAA\u001a[\u0005!\"\t\\8dW6\u000bg.Y4fe6+7o]1hKNLA!a\u000e\u0002:\tq!+\u001a9mS\u000e\fG/\u001a\"m_\u000e\\'bAA\u001a[!9\u0011Q\b\bA\u0002\u0005}\u0012A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\t\u0004I\u0006\u0005\u0013bAA\"[\tq!\t\\8dW6\u000bg.Y4fe&#\u0017a\u0005:f[>4X-\u0012=fGV$xN]!ts:\u001cGcA'\u0002J!)!o\u0004a\u0001g\u0006!\"/Z4jgR,'O\u00117pG.l\u0015M\\1hKJ$B\"a\u0010\u0002P\u0005M\u0013QLA4\u0003WBq!!\u0015\u0011\u0001\u0004\ty$\u0001\u0002jI\"9\u0011Q\u000b\tA\u0002\u0005]\u0013!\u00037pG\u0006dG)\u001b:t!\u00119\u0014\u0011L:\n\u0007\u0005m\u0003HA\u0003BeJ\f\u0017\u0010C\u0004\u0002`A\u0001\r!!\u0019\u0002!5\f\u0007p\u00148IK\u0006\u0004X*Z7TSj,\u0007cA\u001c\u0002d%\u0019\u0011Q\r\u001d\u0003\t1{gn\u001a\u0005\b\u0003S\u0002\u0002\u0019AA1\u0003Ei\u0017\r_(gM\"+\u0017\r]'f[NK'0\u001a\u0005\u0007\u0003[\u0002\u0002\u0019A#\u0002\u001fM$xN]1hK\u0016sG\r]8j]R\fq\"\u001e9eCR,'\t\\8dW&sgm\u001c\u000b\f=\u0006M\u0014QOA@\u0003\u0013\u000bi\tC\u0004\u0002>E\u0001\r!a\u0010\t\u000f\u0005]\u0014\u00031\u0001\u0002z\u00059!\r\\8dW&#\u0007c\u00013\u0002|%\u0019\u0011QP\u0017\u0003\u000f\tcwnY6JI\"9\u0011\u0011Q\tA\u0002\u0005\r\u0015\u0001D:u_J\fw-\u001a'fm\u0016d\u0007c\u00013\u0002\u0006&\u0019\u0011qQ\u0017\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000f\u0005-\u0015\u00031\u0001\u0002b\u00059Q.Z7TSj,\u0007bBAH#\u0001\u0007\u0011\u0011M\u0001\tI&\u001c8nU5{K\u0006aq-\u001a;M_\u000e\fG/[8ogR!\u0011QSAL!\u0019\t9!!\u0005\u0002@!9\u0011q\u000f\nA\u0002\u0005e\u0014!F4fi2{7-\u0019;j_:\u001c\u0018I\u001c3Ti\u0006$Xo\u001d\u000b\u0007\u0003;\u000bI+a+\u0011\u000b]\ny*a)\n\u0007\u0005\u0005\u0006H\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\t)+\u0003\u0003\u0002(\u0006e\"a\u0006\"m_\u000e\\Gj\\2bi&|gn]!oIN#\u0018\r^;t\u0011\u001d\t9h\u0005a\u0001\u0003sBa!!,\u0014\u0001\u0004\u0019\u0018!\u0004:fcV,7\u000f^3s\u0011>\u001cH\u000f\u0006\u0003\u00022\u0006]\u0006CBA\u0004\u0003g\u000b)*\u0003\u0003\u00026\u0006U!AC%oI\u0016DX\rZ*fc\"9\u0011\u0011\u0018\u000bA\u0002\u0005m\u0016\u0001\u00032m_\u000e\\\u0017\nZ:\u0011\u000b]\nI&!\u001f\u0002\u0011\r|g\u000e^1j]N$2AXAa\u0011\u001d\t9(\u0006a\u0001\u0003s\n\u0001bZ3u!\u0016,'o\u001d\u000b\u0005\u0003+\u000b9\rC\u0004\u0002>Y\u0001\r!a\u0010\u0002;\u001d,Go\u00155vM\u001adW\rU;tQ6+'oZ3s\u0019>\u001c\u0017\r^5p]N$b!!&\u0002N\u0006]\u0007bBAh/\u0001\u0007\u0011\u0011[\u0001\u0011]VlW*\u001a:hKJ\u001ch*Z3eK\u0012\u00042aNAj\u0013\r\t)\u000e\u000f\u0002\u0004\u0013:$\bbBAm/\u0001\u0007\u00111\\\u0001\u000eQ>\u001cHo\u001d+p\r&dG/\u001a:\u0011\tQ\fin]\u0005\u0004\u0003?l(aA*fi\u0006y\"/Z7pm\u0016\u001c\u0006.\u001e4gY\u0016\u0004Vo\u001d5NKJ<WM\u001d'pG\u0006$\u0018n\u001c8\u0015\u00075\u000b)\u000f\u0003\u0004\u0002hb\u0001\ra]\u0001\u0005Q>\u001cH/\u0001\fhKR,\u00050Z2vi>\u0014XI\u001c3q_&tGOU3g)\u0011\ti/a<\u0011\t]\ny*\u0012\u0005\u0007\u0003cL\u0002\u0019A:\u0002\u0015\u0015DXmY;u_JLE-A\u0006sK6|g/\u001a\"m_\u000e\\GcA'\u0002x\"9\u0011q\u000f\u000eA\u0002\u0005e\u0014!\u0003:f[>4XM\u00153e)\u0015i\u0015Q B\u0001\u0011\u001d\typ\u0007a\u0001\u0003#\fQA\u001d3e\u0013\u0012DaAa\u0001\u001c\u0001\u0004q\u0016\u0001\u00032m_\u000e\\\u0017N\\4\u0002\u001bI,Wn\u001c<f'\",hM\u001a7f)\u0015i%\u0011\u0002B\u0007\u0011\u001d\u0011Y\u0001\ba\u0001\u0003#\f\u0011b\u001d5vM\u001adW-\u00133\t\r\t\rA\u00041\u0001_\u0003=\u0011X-\\8wK\n\u0013x.\u00193dCN$HcB'\u0003\u0014\t]!1\u0004\u0005\b\u0005+i\u0002\u0019AA1\u0003-\u0011'o\\1eG\u0006\u001cH/\u00133\t\r\teQ\u00041\u0001_\u0003A\u0011X-\\8wK\u001a\u0013x.\\'bgR,'\u000f\u0003\u0004\u0003\u0004u\u0001\rAX\u0001\u0010O\u0016$X*Z7pef\u001cF/\u0019;vgV\u0011!\u0011\u0005\t\bi\n\r\u0012q\bB\u0014\u0013\r\u0011)# \u0002\u0004\u001b\u0006\u0004\bcB\u001c\u0003*\u0005\u0005\u0014\u0011M\u0005\u0004\u0005WA$A\u0002+va2,''\u0001\thKR\u001cFo\u001c:bO\u0016\u001cF/\u0019;vgV\u0011!\u0011\u0007\t\u0006o\u0005e#1\u0007\t\u0004I\nU\u0012b\u0001B\u001c[\ti1\u000b^8sC\u001e,7\u000b^1ukN\fabZ3u\u00052|7m[*uCR,8\u000f\u0006\u0004\u0003>\t\u0015#q\t\t\bi\n\r\u0012q\bB !\r!'\u0011I\u0005\u0004\u0005\u0007j#a\u0003\"m_\u000e\\7\u000b^1ukNDq!a\u001e!\u0001\u0004\tI\b\u0003\u0005\u0003J\u0001\u0002\n\u00111\u0001_\u0003M\t7o[*u_J\fw-Z#oIB|\u0017N\u001c;t\u0003a9W\r\u001e\"m_\u000e\\7\u000b^1ukN$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fR3A\u0018B)W\t\u0011\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B/q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005$q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE4fi6\u000bGo\u00195j]\u001e\u0014En\\2l\u0013\u0012\u001cHC\u0002B4\u0005S\u0012\u0019\b\u0005\u0004\u0002\b\u0005E\u0011\u0011\u0010\u0005\b\u0005W\u0012\u0003\u0019\u0001B7\u0003\u00191\u0017\u000e\u001c;feB1qGa\u001c\u0002zyK1A!\u001d9\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0003J\t\u0002\rAX\u0001\u0005gR|\u0007\u000fF\u0001N\u0003\u0011!X\r\u001c7\u0015\u00075\u0013i\bC\u0004\u0003\u0000\u0011\u0002\rA!!\u0002\u000f5,7o]1hKB\u0019qGa!\n\u0007\t\u0015\u0005HA\u0002B]f\f!C\u00117pG.l\u0015M\\1hKJl\u0015m\u001d;feB\u0011AMJ\n\u0003MY\"\"A!#\u0002)\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'F+\t\u0011\u0019\n\u0005\u0003\u0003\u0016\n}UB\u0001BL\u0015\u0011\u0011IJa'\u0002\t1\fgn\u001a\u0006\u0003\u0005;\u000bAA[1wC&\u0019APa&\u0002+\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'FA\u0005qBIU%W\u000bJ{\u0006*R!S)\n+\u0015\tV0F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u0001 \tJKe+\u0012*`\u0011\u0016\u000b%\u000b\u0016\"F\u0003R{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u0003\u0003")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private RpcEndpointRef driverHeartbeatEndPoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_HEARTBEAT_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_HEARTBEAT_ENDPOINT_NAME();
    }

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcEndpointRef driverHeartbeatEndPoint() {
        return this.driverHeartbeatEndPoint;
    }

    public void driverHeartbeatEndPoint_$eq(RpcEndpointRef x$1) {
        this.driverHeartbeatEndPoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(execId).append(" successfully in removeExecutor").toString());
    }

    public void decommissionBlockManagers(Seq<String> executorIds) {
        this.driverEndpoint().ask(new BlockManagerMessages.DecommissionBlockManagers(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public Seq<BlockManagerMessages.ReplicateBlock> getReplicateInfoForRDDBlocks(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetReplicateInfoForRDDBlocks(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Removal of executor ").append(execId).append(" requested").toString());
    }

    public BlockManagerId registerBlockManager(BlockManagerId id, String[] localDirs, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef storageEndpoint) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Registering BlockManager ").append(id).toString());
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(id, localDirs, maxOnHeapMemSize, maxOffHeapMemSize, storageEndpoint), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registered BlockManager ").append(updatedId).toString());
        return updatedId;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updated info of block ").append(blockId).toString());
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId, String requesterHost) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId, requesterHost), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Seq<BlockManagerId> getShufflePushMergerLocations(int numMergersNeeded, Set<String> hostsToFilter) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetShufflePushMergerLocations(numMergersNeeded, hostsToFilter), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeShufflePushMergerLocation(String host) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShufflePushMergerLocation(host), ClassTag$.MODULE$.Unit());
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to remove RDD ").append(rddId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to remove shuffle ").append(shuffleId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to remove broadcast ").append(broadcastId$1).append(" with removeFromMaster = ").append(removeFromMaster$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        if (this.driverEndpoint() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        if (this.driverEndpoint() == null) {
            return (StorageStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StorageStatus.class));
        }
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askStorageEndpoints) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askStorageEndpoints);
        Map response = (Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
        scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
        scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
        ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
        CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable blockStatus = (scala.collection.immutable.Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
        }
        return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            Option status = (Option)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)blockManagerId, s)));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askStorageEndpoints) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askStorageEndpoints);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public void stop() {
        block2: {
            if (this.driverEndpoint() == null || !this.isDriver) break block2;
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            if (BoxesRunTime.unboxToBoolean(this.driverHeartbeatEndPoint().askSync(BlockManagerMessages$StopBlockManagerMaster$.MODULE$, ClassTag$.MODULE$.Boolean()))) {
                this.driverHeartbeatEndPoint_$eq(null);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to stop BlockManagerMasterHeartbeatEndpoint");
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMaster stopped");
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, RpcEndpointRef driverHeartbeatEndPoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.driverHeartbeatEndPoint = driverHeartbeatEndPoint;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

