/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetChar;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetSingle;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetTwo;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public interface OffsetFactory {
    public static final Log LOG = LogFactory.getLog((String)OffsetFactory.class.getName());

    public static AOffset createOffset(int[] indexes) {
        return OffsetFactory.createOffset(indexes, 0, indexes.length);
    }

    public static AOffset createOffset(IntArrayList indexes) {
        return OffsetFactory.createOffset(indexes.extractValues(), 0, indexes.size());
    }

    public static AOffset createOffset(int[] indexes, int apos, int alen) {
        long charSize;
        int endLength = alen - apos - 1;
        if (endLength < 0) {
            throw new DMLCompressionException("Invalid empty offset to create");
        }
        if (endLength == 0) {
            return new OffsetSingle(indexes[apos]);
        }
        if (endLength == 1) {
            return new OffsetTwo(indexes[apos], indexes[apos + 1]);
        }
        int minValue = indexes[apos];
        int maxValue = indexes[alen - 1];
        int range = maxValue - minValue;
        int correctionByte = OffsetFactory.correctionByte(range, endLength);
        int correctionChar = OffsetFactory.correctionChar(range, endLength);
        long byteSize = OffsetByte.estimateInMemorySize(endLength + correctionByte);
        if (byteSize < (charSize = OffsetChar.estimateInMemorySize(endLength + correctionChar))) {
            return new OffsetByte(indexes, apos, alen);
        }
        return new OffsetChar(indexes, apos, alen);
    }

    public static AOffset readIn(DataInput in) throws IOException {
        OFF_TYPE t = OFF_TYPE.values()[in.readByte()];
        switch (t) {
            case SINGLE_OFFSET: {
                return OffsetSingle.readFields(in);
            }
            case TWO_OFFSET: {
                return OffsetTwo.readFields(in);
            }
            case BYTE: {
                return OffsetByte.readFields(in);
            }
        }
        return OffsetChar.readFields(in);
    }

    public static long estimateInMemorySize(int size, int nRows) {
        if (size == 0) {
            return 8L;
        }
        if (size == 1) {
            return OffsetSingle.estimateInMemorySize();
        }
        if (size == 2) {
            return OffsetTwo.estimateInMemorySize();
        }
        int avgDiff = nRows / size;
        if (avgDiff < 256) {
            int correctionByte = OffsetFactory.correctionByte(nRows, size);
            return OffsetByte.estimateInMemorySize(size - 1 + correctionByte);
        }
        int correctionChar = OffsetFactory.correctionChar(nRows, size);
        return OffsetChar.estimateInMemorySize(size - 1 + correctionChar);
    }

    public static int correctionByte(int nRows, int size) {
        return Math.max(nRows - size * 256, 0) / 256;
    }

    public static int correctionChar(int nRows, int size) {
        return Math.max(nRows - size * 65535, 0) / 65535;
    }

    public static enum OFF_TYPE {
        BYTE,
        CHAR,
        SINGLE_OFFSET,
        TWO_OFFSET;

    }
}

