/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;

public class Federated
extends Lop {
    private Lop _type;
    private Lop _addresses;
    private Lop _ranges;

    public Federated(HashMap<String, Lop> inputLops, Types.DataType dataType, Types.ValueType valueType) {
        super(Lop.Type.Federated, dataType, valueType);
        this._type = inputLops.get("type");
        this._addresses = inputLops.get("addresses");
        this._ranges = inputLops.get("ranges");
        this.addInput(this._type);
        this._type.addOutput(this);
        this.addInput(this._addresses);
        this._addresses.addOutput(this);
        this.addInput(this._ranges);
        this._ranges.addOutput(this);
    }

    @Override
    public String getInstructions(String type, String addresses, String ranges, String output) {
        StringBuilder sb = new StringBuilder("FED");
        sb.append("\u00b0");
        sb.append("fedinit");
        sb.append("\u00b0");
        sb.append(this._type.prepScalarInputOperand(type));
        sb.append("\u00b0");
        sb.append(this._addresses.prepScalarInputOperand(addresses));
        sb.append("\u00b0");
        sb.append(this._ranges.prepScalarInputOperand(ranges));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String toString() {
        return "FedInit";
    }
}

