/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.spark_project.jetty.client.AbstractHttpClientTransport;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.Origin;
import org.spark_project.jetty.client.http.HttpConnectionOverHTTP;
import org.spark_project.jetty.client.http.HttpDestinationOverHTTP;
import org.spark_project.jetty.io.Connection;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.util.Promise;

public class HttpClientTransportOverHTTP
extends AbstractHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return connection;
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<org.spark_project.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @Deprecated
    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination) {
        throw new UnsupportedOperationException("Deprecated, override newHttpConnection(EndPoint, HttpDestination, Promise<Connection>) instead");
    }
}

