/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockUIData;
import org.apache.spark.storage.ExecutorStreamBlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\t)\u00111C\u00117pG.\u001cF/\u0019;vg2K7\u000f^3oKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011AbD\u0007\u0002\u001b)\u0011a\u0002B\u0001\ng\u000eDW\rZ;mKJL!\u0001E\u0007\u0003\u001bM\u0003\u0018M]6MSN$XM\\3s\u0011\u0015\u0011\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00053\u0005i!\r\\8dW6\u000bg.Y4feN,\u0012A\u0007\t\u00057\t\"s%D\u0001\u001d\u0015\tib$A\u0004nkR\f'\r\\3\u000b\u0005}\u0001\u0013AC2pY2,7\r^5p]*\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$9\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\f&\u0013\t1#A\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u0011\tm\u0011\u0003f\u000b\t\u0003-%J!A\u000b\u0002\u0003\u000f\tcwnY6JIB\u0011a\u0003L\u0005\u0003[\t\u00111B\u00117pG.,\u0016\nR1uC\"1q\u0006\u0001Q\u0001\ni\taB\u00197pG.l\u0015M\\1hKJ\u001c\b\u0005C\u00032\u0001\u0011\u0005#'\u0001\bp]\ncwnY6Va\u0012\fG/\u001a3\u0015\u0005M:\u0004C\u0001\u001b6\u001b\u0005\u0001\u0013B\u0001\u001c!\u0005\u0011)f.\u001b;\t\u000ba\u0002\u0004\u0019A\u001d\u0002\u0019\tdwnY6Va\u0012\fG/\u001a3\u0011\u00051Q\u0014BA\u001e\u000e\u0005e\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\ncwnY6Va\u0012\fG/\u001a3\t\u000bu\u0002A\u0011\t \u0002'=t'\t\\8dW6\u000bg.Y4fe\u0006#G-\u001a3\u0015\u0005Mz\u0004\"\u0002!=\u0001\u0004\t\u0015!\u00052m_\u000e\\W*\u00198bO\u0016\u0014\u0018\t\u001a3fIB\u0011ABQ\u0005\u0003\u00076\u0011ad\u00159be.d\u0015n\u001d;f]\u0016\u0014(\t\\8dW6\u000bg.Y4fe\u0006#G-\u001a3\t\u000b\u0015\u0003A\u0011\t$\u0002+=t'\t\\8dW6\u000bg.Y4feJ+Wn\u001c<fIR\u00111g\u0012\u0005\u0006\u0011\u0012\u0003\r!S\u0001\u0014E2|7m['b]\u0006<WM\u001d*f[>4X\r\u001a\t\u0003\u0019)K!aS\u0007\u0003AM\u0003\u0018M]6MSN$XM\\3s\u00052|7m['b]\u0006<WM\u001d*f[>4X\r\u001a\u0005\u0006\u001b\u0002!\tAT\u0001\u001dC2dW\t_3dkR|'o\u0015;sK\u0006l'\t\\8dWN#\u0018\r^;t+\u0005y\u0005c\u0001)Y7:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)N\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005]\u0003\u0013a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9\u0006\u0005\u0005\u0002\u00179&\u0011QL\u0001\u0002\u001a\u000bb,7-\u001e;peN#(/Z1n\u00052|7m[*uCR,8\u000f")
public class BlockStatusListener
extends SparkListener {
    private final HashMap<BlockManagerId, HashMap<BlockId, BlockUIData>> blockManagers = new HashMap();

    private HashMap<BlockManagerId, HashMap<BlockId, BlockUIData>> blockManagers() {
        return this.blockManagers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        BlockId blockId = blockUpdated.blockUpdatedInfo().blockId();
        if (!(blockId instanceof StreamBlockId)) return;
        BlockManagerId blockManagerId = blockUpdated.blockUpdatedInfo().blockManagerId();
        StorageLevel storageLevel = blockUpdated.blockUpdatedInfo().storageLevel();
        long memSize = blockUpdated.blockUpdatedInfo().memSize();
        long diskSize = blockUpdated.blockUpdatedInfo().diskSize();
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().get((Object)blockManagerId).foreach((Function1)new Serializable(this, blockId, blockManagerId, storageLevel, memSize, diskSize){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;
                private final BlockManagerId blockManagerId$1;
                private final StorageLevel storageLevel$1;
                private final long memSize$1;
                private final long diskSize$1;

                public final Serializable apply(HashMap<BlockId, BlockUIData> blocksInBlockManager) {
                    return this.storageLevel$1.isValid() ? blocksInBlockManager.put((Object)this.blockId$1, (Object)new BlockUIData(this.blockId$1, this.blockManagerId$1.hostPort(), this.storageLevel$1, this.memSize$1, this.diskSize$1)) : blocksInBlockManager.$minus$eq((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                    this.blockManagerId$1 = blockManagerId$1;
                    this.storageLevel$1 = storageLevel$1;
                    this.memSize$1 = memSize$1;
                    this.diskSize$1 = diskSize$1;
                }
            });
            return;
        }
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().put((Object)blockManagerAdded.blockManagerId(), (Object)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            return;
        }
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().$minus$eq((Object)blockManagerRemoved.blockManagerId());
            return;
        }
    }

    public synchronized Seq<ExecutorStreamBlockStatus> allExecutorStreamBlockStatus() {
        return ((TraversableOnce)this.blockManagers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ExecutorStreamBlockStatus apply(Tuple2<BlockManagerId, HashMap<BlockId, BlockUIData>> x0$1) {
                Tuple2<BlockManagerId, HashMap<BlockId, BlockUIData>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                    HashMap blocks = (HashMap)tuple2._2();
                    ExecutorStreamBlockStatus executorStreamBlockStatus = new ExecutorStreamBlockStatus(blockManagerId.executorId(), blockManagerId.hostPort(), (Seq<BlockUIData>)blocks.values().toSeq());
                    return executorStreamBlockStatus;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }
}

