/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkHadoopWriter$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import org.apache.spark.rdd.HadoopRDD$;
import org.apache.spark.util.SerializableJobConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tmb!B\u0001\u0003\u0001\tA!!E*qCJ\\\u0007*\u00193p_B<&/\u001b;fe*\u00111\u0001B\u0001\u0006gB\f'o\u001b\u0006\u0003\u000b\u0019\ta!\u00199bG\",'\"A\u0004\u0002\u0007=\u0014xm\u0005\u0003\u0001\u0013=)\u0002C\u0001\u0006\u000e\u001b\u0005Y!\"\u0001\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u00059Y!AB!osJ+g\r\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\u0005\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007C\u0001\u0006\u0017\u0013\t92B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u001dQwNY\"p]\u001a\u001c\u0001\u0001\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u00051Q.\u00199sK\u0012T!\u0001\t\u0003\u0002\r!\fGm\\8q\u0013\t\u0011SDA\u0004K_\n\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t!\u0001C\u0003\u001aG\u0001\u00071\u0004C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\u00079|w/F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003vi&d'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012A\u0001R1uK\"1Q\u0007\u0001Q\u0001\n1\nAA\\8xA!9q\u0007\u0001b\u0001\n\u0013A\u0014\u0001B2p]\u001a,\u0012!\u000f\t\u0003uqj\u0011a\u000f\u0006\u0003_\tI!!P\u001e\u0003'M+'/[1mSj\f'\r\\3K_\n\u001cuN\u001c4\t\r}\u0002\u0001\u0015!\u0003:\u0003\u0015\u0019wN\u001c4!\u0011\u001d\t\u0005\u00011A\u0005\n\t\u000bQA[8c\u0013\u0012+\u0012a\u0011\t\u0003\u0015\u0011K!!R\u0006\u0003\u0007%sG\u000fC\u0004H\u0001\u0001\u0007I\u0011\u0002%\u0002\u0013)|'-\u0013#`I\u0015\fHCA%M!\tQ!*\u0003\u0002L\u0017\t!QK\\5u\u0011\u001die)!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011\u0019y\u0005\u0001)Q\u0005\u0007\u00061!n\u001c2J\t\u0002Bq!\u0015\u0001A\u0002\u0013%!)A\u0004ta2LG/\u0013#\t\u000fM\u0003\u0001\u0019!C\u0005)\u0006Y1\u000f\u001d7ji&#u\fJ3r)\tIU\u000bC\u0004N%\u0006\u0005\t\u0019A\"\t\r]\u0003\u0001\u0015)\u0003D\u0003!\u0019\b\u000f\\5u\u0013\u0012\u0003\u0003bB-\u0001\u0001\u0004%IAQ\u0001\nCR$X-\u001c9u\u0013\u0012Cqa\u0017\u0001A\u0002\u0013%A,A\u0007biR,W\u000e\u001d;J\t~#S-\u001d\u000b\u0003\u0013vCq!\u0014.\u0002\u0002\u0003\u00071\t\u0003\u0004`\u0001\u0001\u0006KaQ\u0001\u000bCR$X-\u001c9u\u0013\u0012\u0003\u0003bB1\u0001\u0001\u0004%IAY\u0001\u0004U&#U#A2\u0011\u0007\u001d\"g-\u0003\u0002f\u0005\t!2+\u001a:jC2L'0\u00192mK^\u0013\u0018\u000e^1cY\u0016\u0004\"\u0001H4\n\u0005!l\"!\u0002&pE&#\u0005b\u00026\u0001\u0001\u0004%Ia[\u0001\bU&#u\fJ3r)\tIE\u000eC\u0004NS\u0006\u0005\t\u0019A2\t\r9\u0004\u0001\u0015)\u0003d\u0003\u0011Q\u0017\n\u0012\u0011\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006!A/Y%E+\u0005\u0011\bcA\u0014egB\u0011A\u0004^\u0005\u0003kv\u0011Q\u0002V1tW\u0006#H/Z7qi&#\u0005bB<\u0001\u0001\u0004%I\u0001_\u0001\ti\u0006LEi\u0018\u0013fcR\u0011\u0011*\u001f\u0005\b\u001bZ\f\t\u00111\u0001s\u0011\u0019Y\b\u0001)Q\u0005e\u0006)A/Y%EA!9Q\u0010\u0001a\u0001\n\u0013q\u0018AB<sSR,'/F\u0001\u0000!\u0015a\u0012\u0011A\u0005\n\u0013\r\t\u0019!\b\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0005\u0003\u0013\t!b\u001e:ji\u0016\u0014x\fJ3r)\rI\u00151\u0002\u0005\t\u001b\u0006\u0015\u0011\u0011!a\u0001\u007f\"9\u0011q\u0002\u0001!B\u0013y\u0018aB<sSR,'\u000f\t\u0015\u0005\u0003\u001b\t\u0019\u0002E\u0002\u000b\u0003+I1!a\u0006\f\u0005%!(/\u00198tS\u0016tG\u000fC\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e\u00051am\u001c:nCR,\"!a\b\u0011\u000bq\t\t#C\u0005\n\u0007\u0005\rRD\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG\u000fC\u0005\u0002(\u0001\u0001\r\u0011\"\u0003\u0002*\u0005Qam\u001c:nCR|F%Z9\u0015\u0007%\u000bY\u0003C\u0005N\u0003K\t\t\u00111\u0001\u0002 !A\u0011q\u0006\u0001!B\u0013\ty\"A\u0004g_Jl\u0017\r\u001e\u0011)\t\u00055\u00121\u0003\u0005\n\u0003k\u0001\u0001\u0019!C\u0005\u0003o\t\u0011bY8n[&$H/\u001a:\u0016\u0005\u0005e\u0002c\u0001\u000f\u0002<%\u0019\u0011QH\u000f\u0003\u001f=+H\u000f];u\u0007>lW.\u001b;uKJD\u0011\"!\u0011\u0001\u0001\u0004%I!a\u0011\u0002\u001b\r|W.\\5ui\u0016\u0014x\fJ3r)\rI\u0015Q\t\u0005\n\u001b\u0006}\u0012\u0011!a\u0001\u0003sA\u0001\"!\u0013\u0001A\u0003&\u0011\u0011H\u0001\u000bG>lW.\u001b;uKJ\u0004\u0003\u0006BA$\u0003'A\u0011\"a\u0014\u0001\u0001\u0004%I!!\u0015\u0002\u0015)|'mQ8oi\u0016DH/\u0006\u0002\u0002TA\u0019A$!\u0016\n\u0007\u0005]SD\u0001\u0006K_\n\u001cuN\u001c;fqRD\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\u0002\u001d)|'mQ8oi\u0016DHo\u0018\u0013fcR\u0019\u0011*a\u0018\t\u00135\u000bI&!AA\u0002\u0005M\u0003\u0002CA2\u0001\u0001\u0006K!a\u0015\u0002\u0017)|'mQ8oi\u0016DH\u000f\t\u0015\u0005\u0003C\n\u0019\u0002C\u0005\u0002j\u0001\u0001\r\u0011\"\u0003\u0002l\u0005YA/Y:l\u0007>tG/\u001a=u+\t\ti\u0007E\u0002\u001d\u0003_J1!!\u001d\u001e\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005]\u0014a\u0004;bg.\u001cuN\u001c;fqR|F%Z9\u0015\u0007%\u000bI\bC\u0005N\u0003g\n\t\u00111\u0001\u0002n!A\u0011Q\u0010\u0001!B\u0013\ti'\u0001\u0007uCN\\7i\u001c8uKb$\b\u0005\u000b\u0003\u0002|\u0005M\u0001bBAB\u0001\u0011\u0005\u0011QQ\u0001\taJ,7+\u001a;vaR\t\u0011\nC\u0004\u0002\n\u0002!\t!a#\u0002\u000bM,G/\u001e9\u0015\u000f%\u000bi)!%\u0002\u0016\"9\u0011qRAD\u0001\u0004\u0019\u0015!\u00026pE&$\u0007bBAJ\u0003\u000f\u0003\raQ\u0001\bgBd\u0017\u000e^5e\u0011\u001d\t9*a\"A\u0002\r\u000b\u0011\"\u0019;uK6\u0004H/\u001b3\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u0006\u0006!q\u000e]3o\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000bQa\u001e:ji\u0016$R!SAR\u0003OCq!!*\u0002\u001e\u0002\u0007\u0011\"A\u0002lKfDq!!+\u0002\u001e\u0002\u0007\u0011\"A\u0003wC2,X\rC\u0004\u0002.\u0002!\t!!\"\u0002\u000b\rdwn]3\t\u000f\u0005E\u0006\u0001\"\u0001\u0002\u0006\u000611m\\7nSRDq!!.\u0001\t\u0003\t))A\u0005d_6l\u0017\u000e\u001e&pE\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016aD4fi>+H\u000f];u\r>\u0014X.\u0019;\u0015\u0005\u0005}\u0001bBA`\u0001\u0011%\u0011\u0011Y\u0001\u0013O\u0016$x*\u001e;qkR\u001cu.\\7jiR,'\u000f\u0006\u0002\u0002:!9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0017!D4fi*{'mQ8oi\u0016DH\u000f\u0006\u0002\u0002T!9\u00111\u001a\u0001\u0005\n\u00055\u0017AD4fiR\u000b7o[\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003[Bq!!5\u0001\t#\t\u0019.A\u000boK^$\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0015\r\u00055\u0014Q[Al\u0011\u00199\u0014q\u001aa\u00017!9\u0011\u0011\\Ah\u0001\u0004\u0019\u0018!C1ui\u0016l\u0007\u000f^%e\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\faa]3u\u0013\u0012\u001bHcB%\u0002b\u0006\r\u0018Q\u001d\u0005\b\u0003\u001f\u000bY\u000e1\u0001D\u0011\u001d\t\u0019*a7A\u0002\rCq!a&\u0002\\\u0002\u00071i\u0002\u0005\u0002j\nA\tAAAv\u0003E\u0019\u0006/\u0019:l\u0011\u0006$wn\u001c9Xe&$XM\u001d\t\u0004O\u00055haB\u0001\u0003\u0011\u0003\u0011\u0011q^\n\u0005\u0003[LQ\u0003C\u0004%\u0003[$\t!a=\u0015\u0005\u0005-\b\u0002CA|\u0003[$\t!!?\u0002\u0017\r\u0014X-\u0019;f\u0015>\u0014\u0017\n\u0012\u000b\u0006M\u0006m\u0018q \u0005\b\u0003{\f)\u00101\u0001-\u0003\u0011!\u0018.\\3\t\u000f\t\u0005\u0011Q\u001fa\u0001\u0007\u0006\u0011\u0011\u000e\u001a\u0005\t\u0005\u000b\ti\u000f\"\u0001\u0003\b\u0005!2M]3bi\u0016\u0004\u0016\r\u001e5Ge>l7\u000b\u001e:j]\u001e$bA!\u0003\u0003\u0016\t\u001d\u0002\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\u0007\t=q$\u0001\u0002gg&!!1\u0003B\u0007\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\t]!1\u0001a\u0001\u00053\tA\u0001]1uQB!!1\u0004B\u0011\u001d\rQ!QD\u0005\u0004\u0005?Y\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003$\t\u0015\"AB*ue&twMC\u0002\u0003 -Aaa\u000eB\u0002\u0001\u0004Y\u0002B\u0003B\u0016\u0003[\f\t\u0011\"\u0003\u0003.\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0003\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\r\u0011)\u0004M\u0001\u0005Y\u0006tw-\u0003\u0003\u0003:\tM\"AB(cU\u0016\u001cG\u000f")
public class SparkHadoopWriter
implements Logging,
Serializable {
    private final Date now;
    private final SerializableJobConf conf;
    private int jobID;
    private int splitID;
    private int attemptID;
    private SerializableWritable<JobID> jID;
    private SerializableWritable<TaskAttemptID> taID;
    private transient RecordWriter<Object, Object> writer;
    private transient OutputFormat<Object, Object> format;
    private transient org.apache.hadoop.mapred.OutputCommitter committer;
    private transient JobContext jobContext;
    private transient org.apache.hadoop.mapred.TaskAttemptContext taskContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Path createPathFromString(String string, JobConf jobConf) {
        return SparkHadoopWriter$.MODULE$.createPathFromString(string, jobConf);
    }

    public static JobID createJobID(Date date, int n) {
        return SparkHadoopWriter$.MODULE$.createJobID(date, n);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private Date now() {
        return this.now;
    }

    private SerializableJobConf conf() {
        return this.conf;
    }

    private int jobID() {
        return this.jobID;
    }

    private void jobID_$eq(int x$1) {
        this.jobID = x$1;
    }

    private int splitID() {
        return this.splitID;
    }

    private void splitID_$eq(int x$1) {
        this.splitID = x$1;
    }

    private int attemptID() {
        return this.attemptID;
    }

    private void attemptID_$eq(int x$1) {
        this.attemptID = x$1;
    }

    private SerializableWritable<JobID> jID() {
        return this.jID;
    }

    private void jID_$eq(SerializableWritable<JobID> x$1) {
        this.jID = x$1;
    }

    private SerializableWritable<TaskAttemptID> taID() {
        return this.taID;
    }

    private void taID_$eq(SerializableWritable<TaskAttemptID> x$1) {
        this.taID = x$1;
    }

    private RecordWriter<Object, Object> writer() {
        return this.writer;
    }

    private void writer_$eq(RecordWriter<Object, Object> x$1) {
        this.writer = x$1;
    }

    private OutputFormat<Object, Object> format() {
        return this.format;
    }

    private void format_$eq(OutputFormat<Object, Object> x$1) {
        this.format = x$1;
    }

    private org.apache.hadoop.mapred.OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(org.apache.hadoop.mapred.OutputCommitter x$1) {
        this.committer = x$1;
    }

    private JobContext jobContext() {
        return this.jobContext;
    }

    private void jobContext_$eq(JobContext x$1) {
        this.jobContext = x$1;
    }

    private org.apache.hadoop.mapred.TaskAttemptContext taskContext() {
        return this.taskContext;
    }

    private void taskContext_$eq(org.apache.hadoop.mapred.TaskAttemptContext x$1) {
        this.taskContext = x$1;
    }

    public void preSetup() {
        this.setIDs(0, 0, 0);
        HadoopRDD$.MODULE$.addLocalConfiguration("", 0, 0, 0, this.conf().value());
        JobContext jCtxt = this.getJobContext();
        this.getOutputCommitter().setupJob(jCtxt);
    }

    public void setup(int jobid, int splitid, int attemptid) {
        this.setIDs(jobid, splitid, attemptid);
        HadoopRDD$.MODULE$.addLocalConfiguration(new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(this.now()), jobid, this.splitID(), this.attemptID(), this.conf().value());
    }

    public void open() {
        NumberFormat numfmt = NumberFormat.getInstance(Locale.US);
        numfmt.setMinimumIntegerDigits(5);
        numfmt.setGroupingUsed(false);
        String outputName = new StringBuilder().append((Object)"part-").append((Object)numfmt.format(this.splitID())).toString();
        Path path = FileOutputFormat.getOutputPath((JobConf)this.conf().value());
        FileSystem fs = path == null ? FileSystem.get((Configuration)this.conf().value()) : path.getFileSystem((Configuration)this.conf().value());
        this.getOutputCommitter().setupTask(this.getTaskContext());
        this.writer_$eq((RecordWriter<Object, Object>)this.getOutputFormat().getRecordWriter(fs, this.conf().value(), outputName, (Progressable)Reporter.NULL));
    }

    public void write(Object key, Object value2) {
        if (this.writer() == null) {
            throw new IOException("Writer is null, open() has not been called");
        }
        this.writer().write(key, value2);
    }

    public void close() {
        this.writer().close(Reporter.NULL);
    }

    public void commit() {
        SparkHadoopMapRedUtil$.MODULE$.commitTask((OutputCommitter)this.getOutputCommitter(), (TaskAttemptContext)this.getTaskContext(), this.jobID(), this.splitID());
    }

    public void commitJob() {
        org.apache.hadoop.mapred.OutputCommitter cmtr = this.getOutputCommitter();
        cmtr.commitJob(this.getJobContext());
    }

    private OutputFormat<Object, Object> getOutputFormat() {
        if (this.format() == null) {
            this.format_$eq((OutputFormat<Object, Object>)this.conf().value().getOutputFormat());
        }
        return this.format();
    }

    private org.apache.hadoop.mapred.OutputCommitter getOutputCommitter() {
        if (this.committer() == null) {
            this.committer_$eq(this.conf().value().getOutputCommitter());
        }
        return this.committer();
    }

    private JobContext getJobContext() {
        if (this.jobContext() == null) {
            this.jobContext_$eq((JobContext)new JobContextImpl(this.conf().value(), (org.apache.hadoop.mapreduce.JobID)this.jID().value()));
        }
        return this.jobContext();
    }

    private org.apache.hadoop.mapred.TaskAttemptContext getTaskContext() {
        if (this.taskContext() == null) {
            this.taskContext_$eq(this.newTaskAttemptContext(this.conf().value(), this.taID().value()));
        }
        return this.taskContext();
    }

    public org.apache.hadoop.mapred.TaskAttemptContext newTaskAttemptContext(JobConf conf, TaskAttemptID attemptId) {
        return new TaskAttemptContextImpl(conf, attemptId);
    }

    private void setIDs(int jobid, int splitid, int attemptid) {
        this.jobID_$eq(jobid);
        this.splitID_$eq(splitid);
        this.attemptID_$eq(attemptid);
        this.jID_$eq(new SerializableWritable<JobID>(SparkHadoopWriter$.MODULE$.createJobID(this.now(), jobid)));
        this.taID_$eq(new SerializableWritable<TaskAttemptID>(new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jID().value(), TaskType.MAP, this.splitID()), this.attemptID())));
    }

    public SparkHadoopWriter(JobConf jobConf) {
        Logging$class.$init$(this);
        this.now = new Date();
        this.conf = new SerializableJobConf(jobConf);
        this.jobID = 0;
        this.splitID = 0;
        this.attemptID = 0;
        this.jID = null;
        this.taID = null;
        this.writer = null;
        this.format = null;
        this.committer = null;
        this.jobContext = null;
        this.taskContext = null;
    }
}

