/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.lineage.LineageMap;

public class LineageDedupBlock {
    private Map<Long, LineageMap> _distinctPaths = new HashMap<Long, LineageMap>();
    private BitSet _path = new BitSet();
    private int _numPaths = 0;
    private long _activePath = -1L;
    private ArrayList<Long> _numDistinctPaths = new ArrayList();

    public LineageMap getActiveMap() {
        if (this._activePath < 0L || !this._distinctPaths.containsKey(this._activePath)) {
            throw new DMLRuntimeException("Active path in LineageDedupBlock could not be found.");
        }
        return this._distinctPaths.get(this._activePath);
    }

    public LineageMap getMap(Long path) {
        return this._distinctPaths.containsKey(path) ? this._distinctPaths.get(path) : null;
    }

    public Map<Long, LineageMap> getPathMaps() {
        return this._distinctPaths;
    }

    public void setMap(Long takenPath, LineageMap tracedMap) {
        this._distinctPaths.put(takenPath, new LineageMap(tracedMap));
    }

    public boolean pathExists(Long path) {
        return this._distinctPaths.containsKey(path);
    }

    public void resetPath() {
        this._path.clear();
    }

    public void setPathBranch(int pos, boolean value) {
        this._path.set(pos, value);
    }

    public long getPath() {
        return this._path.length() == 0 ? 0L : this._path.toLongArray()[0];
    }

    public boolean isAllPathsTaken() {
        return this._distinctPaths.size() == this._numDistinctPaths.size();
    }

    public void traceProgramBlocks(ArrayList<ProgramBlock> pbs, ExecutionContext ec) {
        if (this._distinctPaths.size() == 0) {
            this._distinctPaths.put(0L, new LineageMap());
        }
        for (ProgramBlock pb : pbs) {
            this.traceProgramBlock(pb, ec, new ArrayList<Map.Entry<Long, LineageMap>>(this._distinctPaths.entrySet()));
        }
    }

    public void traceProgramBlock(ProgramBlock pb, ExecutionContext ec, Collection<Map.Entry<Long, LineageMap>> paths) {
        if (pb instanceof IfProgramBlock) {
            this.traceIfProgramBlock((IfProgramBlock)pb, ec, paths);
        } else if (pb instanceof BasicProgramBlock) {
            this.traceBasicProgramBlock((BasicProgramBlock)pb, ec, paths);
        } else {
            throw new DMLRuntimeException("Only BasicProgramBlocks or IfProgramBlocks are allowed inside a LineageDedupBlock.");
        }
    }

    public void traceIfProgramBlock(IfProgramBlock ipb, ExecutionContext ec, Collection<Map.Entry<Long, LineageMap>> paths) {
        ipb.setLineageDedupPathPos(this._numPaths++);
        HashMap<Long, LineageMap> rep = new HashMap<Long, LineageMap>();
        int pathKey = 1 << this._numPaths - 1;
        for (Map.Entry<Long, LineageMap> entry : paths) {
            Long pathIndex = entry.getKey() | (long)pathKey;
            rep.put(pathIndex, new LineageMap(entry.getValue()));
        }
        this._distinctPaths.putAll(rep);
        for (ProgramBlock pb : ipb.getChildBlocksIfBody()) {
            this.traceProgramBlock(pb, ec, rep.entrySet());
        }
        for (ProgramBlock pb : ipb.getChildBlocksElseBody()) {
            this.traceProgramBlock(pb, ec, paths);
        }
    }

    public void traceBasicProgramBlock(BasicProgramBlock bpb, ExecutionContext ec, Collection<Map.Entry<Long, LineageMap>> paths) {
        for (Map.Entry<Long, LineageMap> entry : paths) {
            this._activePath = entry.getKey();
            for (Instruction inst : bpb.getInstructions()) {
                entry.getValue().trace(inst, ec);
            }
        }
    }

    public void setNumPathsInPBs(ArrayList<ProgramBlock> pbs, ExecutionContext ec) {
        if (this._numDistinctPaths.size() == 0) {
            this._numDistinctPaths.add(0L);
        }
        for (ProgramBlock pb : pbs) {
            this.numPathsInPB(pb, ec, this._numDistinctPaths);
        }
    }

    private void numPathsInPB(ProgramBlock pb, ExecutionContext ec, ArrayList<Long> paths) {
        if (!(pb instanceof IfProgramBlock)) {
            if (pb instanceof BasicProgramBlock) {
                return;
            }
            throw new DMLRuntimeException("Only BasicProgramBlocks or IfProgramBlocks are allowed inside a LineageDedupBlock.");
        }
        this.numPathsInIfPB((IfProgramBlock)pb, ec, paths);
    }

    private void numPathsInIfPB(IfProgramBlock ipb, ExecutionContext ec, ArrayList<Long> paths) {
        ipb.setLineageDedupPathPos(this._numPaths++);
        ArrayList<Long> rep = new ArrayList<Long>();
        int pathKey = 1 << this._numPaths - 1;
        Iterator<Object> iterator = paths.iterator();
        while (iterator.hasNext()) {
            long p = iterator.next();
            long pathIndex = p | (long)pathKey;
            rep.add(pathIndex);
        }
        this._numDistinctPaths.addAll(rep);
        for (ProgramBlock pb : ipb.getChildBlocksIfBody()) {
            this.numPathsInPB(pb, ec, rep);
        }
        for (ProgramBlock pb : ipb.getChildBlocksElseBody()) {
            this.numPathsInPB(pb, ec, paths);
        }
    }
}

