/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceNode;
import org.apache.avro.ipc.trace.Util;

public class TraceCollection {
    private static final int MAX_DATA_POINTS = 1000;
    private int exectuionPathHash;
    private TraceNodeStats root;
    private TreeSet<Trace> traces;

    public TraceNodeStats getNodeWithID(int hashCode) {
        return this.getNodeWithIDRecurse(hashCode, this.root);
    }

    public TraceNodeStats getNodeWithIDRecurse(int hashCode, TraceNodeStats start) {
        if (start.hashCode() == hashCode) {
            return start;
        }
        for (TraceNodeStats tn : start.children) {
            TraceNodeStats potential = this.getNodeWithIDRecurse(hashCode, tn);
            if (potential == null) continue;
            return potential;
        }
        return null;
    }

    private static long getLongAverage(Collection<Long> c) {
        double out = 0.0;
        for (Long l : c) {
            out += (double)l.longValue() / (double)c.size();
        }
        return (long)out;
    }

    private static long getTimingAverage(Collection<TraceTiming> c) {
        if (c == null) {
            return 0L;
        }
        double out = 0.0;
        for (TraceTiming l : c) {
            Long val = l.getTotalTime();
            out += (double)val.longValue() / (double)c.size();
        }
        return (long)out;
    }

    public TraceCollection(Trace t) {
        this.exectuionPathHash = t.executionPathHash();
        this.root = new TraceNodeStats(t.getRoot());
        this.traces = new TreeSet<Trace>(new TraceComparotor());
    }

    public TraceNodeStats getRootNode() {
        return this.root;
    }

    public int getExecutionPathHash() {
        return this.exectuionPathHash;
    }

    public TreeSet<Trace> getTraces() {
        return this.traces;
    }

    public List<Trace> longestTraces(int count) {
        Trace toAdd;
        TreeSet cloned = (TreeSet)this.traces.clone();
        LinkedList<Trace> out = new LinkedList<Trace>();
        for (int i = 0; i < count && (toAdd = (Trace)cloned.pollLast()) != null; ++i) {
            out.add(toAdd);
        }
        return out;
    }

    public void addTrace(Trace t) {
        this.traces.add(t);
        if (t.executionPathHash() != this.exectuionPathHash) {
            throw new IllegalArgumentException("Trace added which does not match required execution path.");
        }
        this.recursiveProcess(t.getRoot(), this.root);
    }

    private void recursiveProcess(TraceNode tn, TraceNodeStats tns) {
        if (tn.children.size() != tns.children.size() || !tns.messageName.equals(tn.span.messageName)) {
            throw new IllegalArgumentException("Trace added does not match existingtrace");
        }
        tns.requestPayloads.add(tn.span.requestPayloadSize);
        tns.responsePayloads.add(tn.span.responsePayloadSize);
        tns.traceTimings.add(new TraceTiming(tn.getPreLinkTime(), tn.getProcessTime(), tn.getPostLinkTime()));
        tns.messageName = tn.span.messageName;
        for (int i = 0; i < tn.children.size(); ++i) {
            this.recursiveProcess(tn.children.get(i), tns.children.get(i));
        }
    }

    public String printBrief() {
        String out = "TraceCollection:\n";
        out = out + this.printRecurse(this.root, 0);
        return out;
    }

    public String printRecurse(TraceNodeStats n, int depth) {
        String out = "";
        for (int i = 0; i < depth; ++i) {
            out = out + "  ";
        }
        out = out + n.printBrief() + "\n";
        for (TraceNodeStats child : n.children) {
            out = out + this.printRecurse(child, depth + 1);
        }
        return out;
    }

    public class TraceComparotor
    implements Comparator<Trace> {
        @Override
        public int compare(Trace o1, Trace o2) {
            Long rtt1 = o1.getRoot().getPreLinkTime() + o1.getRoot().getProcessTime() + o1.getRoot().getPostLinkTime();
            Long rtt2 = o2.getRoot().getPreLinkTime() + o2.getRoot().getProcessTime() + o2.getRoot().getPostLinkTime();
            return rtt1.compareTo(rtt2);
        }
    }

    public class TraceNodeStats {
        CharSequence messageName;
        List<TraceNodeStats> children;
        List<Long> requestPayloads = new ArrayList<Long>();
        List<Long> responsePayloads = new ArrayList<Long>();
        List<TraceTiming> traceTimings = new ArrayList<TraceTiming>();

        public TraceNodeStats(TraceNode root) {
            this.messageName = root.span.messageName;
            this.children = new LinkedList<TraceNodeStats>();
            for (TraceNode tn : root.children) {
                this.children.add(new TraceNodeStats(tn));
            }
        }

        public List<Long> getRequestPayloads() {
            return Util.sampledList(this.requestPayloads, 1000);
        }

        public List<Long> getResponsePayloads() {
            return Util.sampledList(this.responsePayloads, 1000);
        }

        public List<TraceTiming> getTraceTimings() {
            return Util.sampledList(this.traceTimings, 1000);
        }

        public List<TraceTiming> getTraceTimingsSorted() {
            List<TraceTiming> copy = Util.sampledList(this.traceTimings, 1000);
            Collections.sort(copy);
            return copy;
        }

        public List<TraceNodeStats> getChildren() {
            return this.children;
        }

        public CharSequence getMessageName() {
            return this.messageName;
        }

        public String getAverageTime(List<TraceTiming> input) {
            return Util.printableTime(TraceCollection.getTimingAverage(input));
        }

        public String getMinTime(List<TraceTiming> input) {
            TraceTiming min = Collections.min(input);
            return Util.printableTime(min.getTotalTime());
        }

        public String getMaxTime(List<TraceTiming> input) {
            TraceTiming max = Collections.max(input);
            return Util.printableTime(max.getTotalTime());
        }

        public String getAverageBytes(List<Long> input) {
            return Util.printableBytes(TraceCollection.getLongAverage(input));
        }

        public String getMinBytes(List<Long> input) {
            Long min = Collections.min(input);
            return Util.printableBytes(min);
        }

        public String getMaxBytes(List<Long> input) {
            Long max = Collections.max(input);
            return Util.printableBytes(max);
        }

        public String printBrief() {
            String out = "'" + this.messageName + "' ";
            out = out + "(Averages) Request Payload: " + this.getAverageBytes(this.requestPayloads) + " Response Payload: " + this.getAverageBytes(this.responsePayloads) + " RTT: " + this.getAverageTime(this.traceTimings);
            return out;
        }
    }

    public class TraceTiming
    implements Comparable<TraceTiming> {
        long preLinkTime;
        long computeTime;
        long postLinkTime;

        public TraceTiming(Long preLinkTime, Long computeTime, Long postLinkTime) {
            this.preLinkTime = preLinkTime;
            this.computeTime = computeTime;
            this.postLinkTime = postLinkTime;
        }

        public Long getTotalTime() {
            return new Long(this.preLinkTime + this.computeTime + this.postLinkTime);
        }

        @Override
        public int compareTo(TraceTiming other) {
            return this.getTotalTime().compareTo(other.getTotalTime());
        }

        public long getPreLinkTime() {
            return this.preLinkTime;
        }

        public long getComputeTime() {
            return this.computeTime;
        }

        public long getPostLinkTime() {
            return this.postLinkTime;
        }
    }
}

