/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.UnifiedMemoryManager;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class UnifiedMemoryManager$ {
    public static final UnifiedMemoryManager$ MODULE$;
    private final int RESERVED_SYSTEM_MEMORY_BYTES;

    static {
        new UnifiedMemoryManager$();
    }

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return this.RESERVED_SYSTEM_MEMORY_BYTES;
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * conf.getDouble("spark.memory.storageFraction", 0.5)), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long executorMemory;
        long reservedMemory;
        long minSystemMemory;
        long systemMemory = conf.getLong("spark.testing.memory", Runtime.getRuntime().maxMemory());
        if (systemMemory < (minSystemMemory = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(reservedMemory = conf.getLong("spark.testing.reservedMemory", conf.contains("spark.testing") ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)))) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"System memory ", " must "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)systemMemory)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be at least ", ". Please increase heap size using the --driver-memory "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minSystemMemory)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"option or spark.driver.memory in Spark configuration."})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (conf.contains("spark.executor.memory") && (executorMemory = conf.getSizeAsBytes("spark.executor.memory")) < minSystemMemory) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor memory ", " must be at least "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)executorMemory)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Please increase executor memory using the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minSystemMemory)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--executor-memory option or spark.executor.memory in Spark configuration."})).s((Seq)Nil$.MODULE$)).toString());
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = conf.getDouble("spark.memory.fraction", 0.6);
        return (long)((double)usableMemory * memoryFraction);
    }

    private UnifiedMemoryManager$() {
        MODULE$ = this;
        this.RESERVED_SYSTEM_MEMORY_BYTES = 314572800;
    }
}

