/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlock
extends ReaderColumnSelection {
    private final double[] _data;
    private final int _numCols;

    protected ReaderColumnSelectionDenseSingleBlock(MatrixBlock data, int[] colIndices, int rl, int ru) {
        super(colIndices, rl, Math.min(ru, data.getNumRows()));
        this._data = data.getDenseBlockValues();
        if (data.getDenseBlock().numBlocks() > 1) {
            throw new DMLCompressionException("Not handling multi block data reading in dense reader");
        }
        this._numCols = data.getNumColumns();
    }

    @Override
    protected DblArray getNextRow() {
        if (this._rl == this._ru - 1) {
            return null;
        }
        ++this._rl;
        int indexOff = this._rl * this._numCols;
        boolean empty = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            double v = this._data[indexOff + this._colIndexes[i]];
            if (v != 0.0) {
                empty = false;
            }
            this.reusableArr[i] = v;
        }
        return empty ? emptyReturn : this.reusableReturn;
    }
}

