/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupEmpty
extends ColGroupCompressed {
    private static final long serialVersionUID = 3204391661346504L;

    protected ColGroupEmpty(int numRows) {
        super(numRows);
    }

    public ColGroupEmpty(int[] colIndices, int numRows) {
        super(colIndices, numRows);
    }

    public static ColGroupEmpty generate(int nCol, int nRow) {
        int[] cols = new int[nCol];
        for (int i = 0; i < nCol; ++i) {
            cols[i] = i;
        }
        return new ColGroupEmpty(cols, nRow);
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
    }

    @Override
    protected void computeColSums(double[] c, boolean square) {
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            c[i] = builtin.execute(c[i], 0.0);
        }
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.CONST;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.EMPTY;
    }

    @Override
    public void decompressToBlockSafe(MatrixBlock target, int rl, int ru, int offT) {
    }

    @Override
    public void decompressToBlockUnSafe(MatrixBlock target, int rl, int ru, int offT) {
    }

    @Override
    public double get(int r, int c) {
        return 0.0;
    }

    @Override
    public void leftMultByMatrix(MatrixBlock a, MatrixBlock c, int rl, int ru) {
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (val0 == 0.0) {
            return this;
        }
        return new ColGroupConst(this._colIndexes, this._numRows, new Dictionary(new double[this._colIndexes.length]).apply(op));
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        if (sparseSafe) {
            return this;
        }
        return new ColGroupConst(this._colIndexes, this._numRows, new Dictionary(new double[this._colIndexes.length]).applyBinaryRowOp(op, v, true, this._colIndexes, left));
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
    }

    @Override
    public int getNumValues() {
        return 0;
    }

    @Override
    public double[] getValues() {
        return null;
    }

    @Override
    public void addMinMax(double[] ret) {
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        return builtin.execute(c, 0.0);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        for (int col : this._colIndexes) {
            c[col] = builtin.execute(c[col], 0.0);
        }
    }

    @Override
    protected void computeSum(double[] c, boolean square) {
    }

    @Override
    protected boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupEmpty || that instanceof ColGroupConst;
    }

    @Override
    public MatrixBlock getValuesAsBlock() {
        return new MatrixBlock(0, 0, false);
    }

    @Override
    public void tsmm(double[] result, int numColumns) {
    }

    @Override
    public void tsmm(double[] result, int numColumns, int idxStart, int idxEnd) {
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock c) {
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public AColGroup copy() {
        return new ColGroupEmpty(this._colIndexes, this._numRows);
    }

    @Override
    public boolean containsValue(double pattern) {
        return pattern == 0.0;
    }

    @Override
    public long getNumberNonZeros() {
        return 0L;
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        return new ColGroupEmpty(new int[]{0}, this._numRows);
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        return new ColGroupEmpty(outputCols, this._numRows);
    }

    @Override
    public AColGroup rightMultByMatrix(MatrixBlock right) {
        return null;
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        if (pattern == 0.0) {
            return ColGroupFactory.getColGroupConst(this.getNumRows(), this._colIndexes, replace);
        }
        return new ColGroupEmpty(this._colIndexes, this.getNumRows());
    }
}

